/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.I18n;

public class RelationChecker
extends Test {
    protected static int ROLE_UNKNOWN = 1701;
    protected static int ROLE_EMPTY = 1702;
    protected static int WRONG_TYPE = 1703;
    protected static int HIGH_COUNT = 1704;
    protected static int LOW_COUNT = 1705;
    protected static int ROLE_MISSING = 1706;
    protected static int RELATION_UNKNOWN = 1707;
    protected static int RELATION_EMPTY = 1708;
    static Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker :", new Object[0]), I18n.tr("This plugin checks for errors in relations.", new Object[0]));
    }

    public void initialize() throws Exception {
        this.initializePresets();
    }

    public void initializePresets() {
        Collection<TaggingPreset> collection = TaggingPresetPreference.taggingPresets;
        if (collection != null) {
            block0: for (TaggingPreset taggingPreset : collection) {
                for (TaggingPreset.Item item : taggingPreset.data) {
                    if (!(item instanceof TaggingPreset.Roles)) continue;
                    relationpresets.add(taggingPreset);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visit(Relation relation) {
        Object object;
        Object object2;
        LinkedList<TaggingPreset.Role> linkedList = new LinkedList<TaggingPreset.Role>();
        for (TaggingPreset linkedList2 : relationpresets) {
            void var6_11;
            boolean relationMember = true;
            Object var6_12 = null;
            object2 = linkedList2.data.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof TaggingPreset.Key) {
                    TaggingPreset.Key key = (TaggingPreset.Key)object;
                    if (key.value.equals(relation.get(key.key))) continue;
                    relationMember = false;
                    break;
                }
                if (!(object instanceof TaggingPreset.Roles)) continue;
                TaggingPreset.Roles roles = (TaggingPreset.Roles)object;
            }
            if (!relationMember || var6_11 == null) continue;
            linkedList.addAll(var6_11.roles);
        }
        if (linkedList.size() == 0) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Relation type is unknown", new Object[0]), RELATION_UNKNOWN, relation));
        } else {
            HashMap hashMap = new HashMap();
            for (RelationMember relationMember : relation.getMembers()) {
                void var6_17;
                String string = "";
                if (relationMember.hasRole()) {
                    String string2 = relationMember.getRole();
                }
                if ((object2 = (RoleInfo)hashMap.get(var6_17)) == null) {
                    object2 = new RoleInfo();
                }
                ++((RoleInfo)object2).total;
                if (relationMember.isRelation()) {
                    ++((RoleInfo)object2).relations;
                } else if (relationMember.isWay()) {
                    ++((RoleInfo)object2).ways;
                    if (relationMember.getWay().isClosed()) {
                        ++((RoleInfo)object2).closedways;
                    } else {
                        ++((RoleInfo)object2).openways;
                    }
                } else if (relationMember.isNode()) {
                    ++((RoleInfo)object2).nodes;
                }
                hashMap.put(var6_17, object2);
            }
            if (hashMap.isEmpty()) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Relation is empty", new Object[0]), RELATION_EMPTY, relation));
            } else {
                LinkedList<String> linkedList2 = new LinkedList<String>();
                for (TaggingPreset.Role role : linkedList) {
                    String string;
                    long l;
                    long l2;
                    linkedList2.add(role.key);
                    object2 = role.key;
                    if ("".equals(object2)) {
                        object2 = I18n.tr("<empty>", new Object[0]);
                    }
                    if ((l2 = (object = (RoleInfo)hashMap.get(role.key)) == null ? 0L : (long)((RoleInfo)object).total) != (l = role.getValidCount(l2))) {
                        if (l2 == 0L) {
                            string = I18n.marktr("Role {0} missing");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr(string, object2), MessageFormat.format(string, object2), ROLE_MISSING, relation));
                        } else if (l > l2) {
                            string = I18n.marktr("Number of {0} roles too low ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr(string, object2, l2), MessageFormat.format(string, object2, l2), LOW_COUNT, relation));
                        } else {
                            string = I18n.marktr("Number of {0} roles too high ({1})");
                            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr(string, object2, l2), MessageFormat.format(string, object2, l2), HIGH_COUNT, relation));
                        }
                    }
                    if (object == null) continue;
                    if (role.types.contains((Object)TaggingPreset.PresetType.WAY) || !(!role.types.contains((Object)TaggingPreset.PresetType.CLOSEDWAY) ? ((RoleInfo)object).ways > 0 : ((RoleInfo)object).openways > 0)) {
                        if ((role.types.contains((Object)TaggingPreset.PresetType.NODE) || ((RoleInfo)object).nodes <= 0) && (role.types.contains((Object)TaggingPreset.PresetType.RELATION) || ((RoleInfo)object).relations <= 0)) continue;
                    }
                    string = I18n.marktr("Member for role {0} of wrong type");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr(string, object2), MessageFormat.format(string, object2), WRONG_TYPE, relation));
                }
                for (String string : hashMap.keySet()) {
                    if (linkedList2.contains(string)) continue;
                    if (string.length() > 0) {
                        object2 = I18n.marktr("Role {0} unknown");
                        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr((String)object2, string), MessageFormat.format((String)object2, string), ROLE_UNKNOWN, relation));
                        continue;
                    }
                    object2 = I18n.marktr("Empty role found");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Role verification problem", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, ROLE_EMPTY, relation));
                }
            }
        }
    }

    public class RoleInfo {
        int total = 0;
        int nodes = 0;
        int ways = 0;
        int closedways = 0;
        int openways = 0;
        int relations = 0;
    }
}

