/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.NavigatableComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multipolygon {
    public static final String PREF_KEY_OUTER_ROLES = "mappaint.multipolygon.outer.roles";
    public static final String PREF_KEY_OUTER_ROLE_PREFIXES = "mappaint.multipolygon.outer.role-prefixes";
    public static final String PREF_KEY_INNER_ROLES = "mappaint.multipolygon.inner.roles";
    public static final String PREF_KEY_INNER_ROLE_PREFIXES = "mappaint.multipolygon.inner.role-prefixes";
    private static MultipolygonRoleMatcher roleMatcher;
    private final NavigatableComponent nc;
    private final List<Way> innerWays = new ArrayList<Way>();
    private final List<Way> outerWays = new ArrayList<Way>();
    private final List<PolyData> innerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> outerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> combinedPolygons = new ArrayList<PolyData>();

    private static MultipolygonRoleMatcher getMultipoloygonRoleMatcher() {
        if (roleMatcher == null) {
            roleMatcher = new MultipolygonRoleMatcher();
            if (Main.pref != null) {
                Multipolygon.roleMatcher.initFromPreferences();
                Main.pref.addPreferenceChangeListener(roleMatcher);
            }
        }
        return roleMatcher;
    }

    public Multipolygon(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
    }

    public void load(Relation relation) {
        MultipolygonRoleMatcher multipolygonRoleMatcher = Multipolygon.getMultipoloygonRoleMatcher();
        for (RelationMember relationMember : relation.getMembers()) {
            Way way;
            if (!relationMember.getMember().isDrawable() || !relationMember.isWay() || (way = relationMember.getWay()).getNodesCount() < 2) continue;
            if (multipolygonRoleMatcher.isInnerRole(relationMember.getRole())) {
                this.innerWays.add(way);
                continue;
            }
            if (multipolygonRoleMatcher.isOuterRole(relationMember.getRole())) {
                this.outerWays.add(way);
                continue;
            }
            if (relationMember.hasRole()) continue;
            this.outerWays.add(way);
        }
        this.createPolygons(this.innerWays, this.innerPolygons);
        this.createPolygons(this.outerWays, this.outerPolygons);
        if (!this.outerPolygons.isEmpty()) {
            this.addInnerToOuters();
        }
    }

    private void createPolygons(List<Way> list, List<PolyData> list2) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (Way object : list) {
            if (object.isClosed()) {
                list2.add(new PolyData(this.nc, object.getNodes(), object.isSelected()));
                continue;
            }
            arrayList.add(object);
        }
        for (JoinedWay joinedWay : Multipolygon.joinWays(arrayList)) {
            list2.add(new PolyData(this.nc, joinedWay));
        }
    }

    public static Collection<JoinedWay> joinWays(Collection<Way> collection) {
        ArrayList<JoinedWay> arrayList = new ArrayList<JoinedWay>();
        Way[] wayArray = collection.toArray(new Way[collection.size()]);
        int n = collection.size();
        while (n != 0) {
            Way way = null;
            boolean bl = false;
            List<Node> list = null;
            boolean bl2 = true;
            while (bl2 && n != 0) {
                bl2 = false;
                for (int i = 0; i < wayArray.length && n != 0; ++i) {
                    int n2;
                    if (wayArray[i] == null) continue;
                    Way way2 = wayArray[i];
                    if (way == null) {
                        way = way2;
                        bl = way.isSelected();
                        wayArray[i] = null;
                        --n;
                        continue;
                    }
                    int n3 = 0;
                    int n4 = way2.getNodesCount() - 1;
                    if (list == null) {
                        n2 = way.getNodesCount() - 1;
                        if (way.getNode(n2) == way2.getNode(0)) {
                            n3 = 21;
                        } else if (way.getNode(n2) == way2.getNode(n4)) {
                            n3 = 22;
                        } else if (way.getNode(0) == way2.getNode(0)) {
                            n3 = 11;
                        } else if (way.getNode(0) == way2.getNode(n4)) {
                            n3 = 12;
                        }
                    } else {
                        n2 = list.size() - 1;
                        if (list.get(n2) == way2.getNode(0)) {
                            n3 = 21;
                        } else if (list.get(0) == way2.getNode(n4)) {
                            n3 = 12;
                        } else if (list.get(0) == way2.getNode(0)) {
                            n3 = 11;
                        } else if (list.get(n2) == way2.getNode(n4)) {
                            n3 = 22;
                        }
                    }
                    if (n3 == 0) continue;
                    wayArray[i] = null;
                    bl2 = true;
                    if (way2.isSelected()) {
                        bl = true;
                    }
                    --n;
                    if (list == null) {
                        list = way.getNodes();
                    }
                    list.remove(n3 == 21 || n3 == 22 ? n2 : 0);
                    if (n3 == 21) {
                        list.addAll(way2.getNodes());
                        continue;
                    }
                    if (n3 == 12) {
                        list.addAll(0, way2.getNodes());
                        continue;
                    }
                    if (n3 == 22) {
                        for (Node node : way2.getNodes()) {
                            list.add(n2, node);
                        }
                        continue;
                    }
                    for (Node node : way2.getNodes()) {
                        list.add(0, node);
                    }
                }
            }
            if (list == null) {
                list = way.getNodes();
            }
            arrayList.add(new JoinedWay(list, bl));
        }
        return arrayList;
    }

    public PolyData findOuterPolygon(PolyData polyData, List<PolyData> list) {
        PolyData polyData2 = null;
        Rectangle rectangle = polyData.getBounds();
        PolyData polyData32 = null;
        Object object = null;
        int n = 0;
        int n2 = 0;
        for (PolyData polyData4 : list) {
            if (polyData4.getBounds().contains(rectangle)) {
                polyData32 = polyData4;
                ++n;
                continue;
            }
            if (!polyData4.getBounds().intersects(rectangle)) continue;
            object = polyData4;
            ++n2;
        }
        if (n == 1) {
            return polyData32;
        }
        if (n2 == 1) {
            return object;
        }
        for (PolyData polyData32 : list) {
            object = polyData32.contains(polyData.poly);
            if (object == PolyData.Intersection.OUTSIDE || polyData2 != null && polyData2.contains(polyData32.poly) == PolyData.Intersection.INSIDE) continue;
            polyData2 = polyData32;
        }
        return polyData2;
    }

    private void addInnerToOuters() {
        if (this.innerPolygons.isEmpty()) {
            this.combinedPolygons.addAll(this.outerPolygons);
        } else if (this.outerPolygons.size() == 1) {
            PolyData polyData = new PolyData(this.outerPolygons.get(0));
            for (PolyData polyData2 : this.innerPolygons) {
                polyData.addInner(polyData2.poly);
            }
            this.combinedPolygons.add(polyData);
        } else {
            for (PolyData polyData : this.outerPolygons) {
                this.combinedPolygons.add(new PolyData(polyData));
            }
            for (PolyData polyData : this.innerPolygons) {
                PolyData polyData3 = this.findOuterPolygon(polyData, this.combinedPolygons);
                if (polyData3 == null) {
                    polyData3 = this.outerPolygons.get(0);
                }
                polyData3.addInner(polyData.poly);
            }
        }
    }

    public List<Way> getOuterWays() {
        return this.outerWays;
    }

    public List<Way> getInnerWays() {
        return this.innerWays;
    }

    public List<PolyData> getInnerPolygons() {
        return this.innerPolygons;
    }

    public List<PolyData> getOuterPolygons() {
        return this.outerPolygons;
    }

    public List<PolyData> getCombinedPolygons() {
        return this.combinedPolygons;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PolyData {
        public Polygon poly = new Polygon();
        public final boolean selected;
        private Point lastP;
        private Rectangle bounds;

        public PolyData(NavigatableComponent navigatableComponent, JoinedWay joinedWay) {
            this(navigatableComponent, joinedWay.getNodes(), joinedWay.isSelected());
        }

        public PolyData(NavigatableComponent navigatableComponent, List<Node> list, boolean bl) {
            this.selected = bl;
            Point point = null;
            for (Node node : list) {
                point = navigatableComponent.getPoint(node);
                this.poly.addPoint(point.x, point.y);
            }
            if (!list.get(0).equals(list.get(list.size() - 1))) {
                point = navigatableComponent.getPoint(list.get(0));
                this.poly.addPoint(point.x, point.y);
            }
            this.lastP = point;
        }

        public PolyData(PolyData polyData) {
            this.poly = new Polygon(polyData.poly.xpoints, polyData.poly.ypoints, polyData.poly.npoints);
            this.selected = polyData.selected;
            this.lastP = polyData.lastP;
        }

        public Intersection contains(Polygon polygon) {
            int n = polygon.npoints;
            for (int i = 0; i < polygon.npoints; ++i) {
                if (!this.poly.contains(polygon.xpoints[i], polygon.ypoints[i])) continue;
                --n;
            }
            if (n == 0) {
                return Intersection.INSIDE;
            }
            if (n == polygon.npoints) {
                return Intersection.OUTSIDE;
            }
            return Intersection.CROSSING;
        }

        public void addInner(Polygon polygon) {
            for (int i = 0; i < polygon.npoints; ++i) {
                this.poly.addPoint(polygon.xpoints[i], polygon.ypoints[i]);
            }
            this.poly.addPoint(this.lastP.x, this.lastP.y);
        }

        public Polygon get() {
            return this.poly;
        }

        public Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = this.poly.getBounds();
            }
            return this.bounds;
        }

        public String toString() {
            return "Points: " + this.poly.npoints + " Selected: " + this.selected;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Intersection {
            INSIDE,
            OUTSIDE,
            CROSSING;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JoinedWay {
        private final List<Node> nodes;
        private final boolean selected;

        public JoinedWay(List<Node> list, boolean bl) {
            this.nodes = list;
            this.selected = bl;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isClosed() {
            return this.nodes.isEmpty() || this.nodes.get(this.nodes.size() - 1).equals(this.nodes.get(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultipolygonRoleMatcher
    implements Preferences.PreferenceChangedListener {
        private final List<String> outerExactRoles = new ArrayList<String>();
        private final List<String> outerRolePrefixes = new ArrayList<String>();
        private final List<String> innerExactRoles = new ArrayList<String>();
        private final List<String> innerRolePrefixes = new ArrayList<String>();

        private MultipolygonRoleMatcher() {
        }

        private void initDefaults() {
            this.outerExactRoles.clear();
            this.outerRolePrefixes.clear();
            this.innerExactRoles.clear();
            this.innerRolePrefixes.clear();
            this.outerExactRoles.add("outer");
            this.innerExactRoles.add("inner");
        }

        private void setNormalized(Collection<String> collection, List<String> list) {
            list.clear();
            for (String string : collection) {
                if (string == null || list.contains(string = string.trim())) continue;
                list.add(string);
            }
        }

        private void initFromPreferences() {
            this.initDefaults();
            if (Main.pref == null) {
                return;
            }
            Collection<String> collection = Main.pref.getCollection(Multipolygon.PREF_KEY_OUTER_ROLES);
            if (collection != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.outerExactRoles);
            }
            if ((collection = Main.pref.getCollection(Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES)) != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.outerRolePrefixes);
            }
            if ((collection = Main.pref.getCollection(Multipolygon.PREF_KEY_INNER_ROLES)) != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.innerExactRoles);
            }
            if ((collection = Main.pref.getCollection(Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES)) != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.innerRolePrefixes);
            }
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            if (Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES.equals(preferenceChangeEvent.getKey()) || Multipolygon.PREF_KEY_INNER_ROLES.equals(preferenceChangeEvent.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES.equals(preferenceChangeEvent.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLES.equals(preferenceChangeEvent.getKey())) {
                this.initFromPreferences();
            }
        }

        public boolean isOuterRole(String string) {
            if (string == null) {
                return false;
            }
            for (String string2 : this.outerExactRoles) {
                if (!string.equals(string2)) continue;
                return true;
            }
            for (String string2 : this.outerRolePrefixes) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
            return false;
        }

        public boolean isInnerRole(String string) {
            if (string == null) {
                return false;
            }
            for (String string2 : this.innerExactRoles) {
                if (!string.equals(string2)) continue;
                return true;
            }
            for (String string2 : this.innerRolePrefixes) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

