/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Property;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAction
extends JosmAction
implements ParameterizedAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;
    private static final String SEARCH_EXPRESSION = "searchExpression";
    private static LinkedList<SearchSetting> searchHistory = null;
    private static SearchSetting lastSearch = null;

    public static Collection<SearchSetting> getSearchHistory() {
        if (searchHistory == null) {
            searchHistory = new LinkedList();
            for (String string : Main.pref.getCollection("search.history", Collections.<String>emptyList())) {
                SearchSetting searchSetting = SearchSetting.readFromString(string);
                if (searchSetting == null) continue;
                searchHistory.add(searchSetting);
            }
        }
        return searchHistory;
    }

    public static void saveToHistory(SearchSetting searchSetting) {
        if (searchHistory.isEmpty() || !searchSetting.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(searchSetting));
        }
        int n = Main.pref.getInteger("search.history-size", 15);
        while (searchHistory.size() > n) {
            searchHistory.removeLast();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SearchSetting searchSetting2 : searchHistory) {
            arrayList.add(searchSetting2.writeToString());
        }
        Main.pref.putCollection("search.history", arrayList);
    }

    public static List<String> getSearchExpressionHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(SearchAction.getSearchHistory().size());
        for (SearchSetting searchSetting : SearchAction.getSearchHistory()) {
            arrayList.add(searchSetting.text);
        }
        return arrayList;
    }

    public SearchAction() {
        super(I18n.tr("Search...", new Object[0]), "dialogs/search", I18n.tr("Search for objects.", new Object[0]), Shortcut.registerShortcut("system:find", I18n.tr("Search...", new Object[0]), 70, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        SearchAction.search();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent, Map<String, Object> map) {
        if (map.get(SEARCH_EXPRESSION) == null) {
            this.actionPerformed(actionEvent);
        } else {
            SearchAction.searchWithoutHistory((SearchSetting)map.get(SEARCH_EXPRESSION));
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting searchSetting) {
        if (searchSetting == null) {
            searchSetting = new SearchSetting();
        }
        JLabel jLabel = new JLabel(searchSetting instanceof Filter ? I18n.tr("Filter string:", new Object[0]) : I18n.tr("Search string:", new Object[0]));
        final HistoryComboBox historyComboBox = new HistoryComboBox();
        historyComboBox.setText(searchSetting.text);
        historyComboBox.getEditor().selectAll();
        historyComboBox.getEditor().getEditorComponent().requestFocusInWindow();
        historyComboBox.setToolTipText(I18n.tr("Enter the search expression", new Object[0]));
        List<String> list = SearchAction.getSearchExpressionHistory();
        Collections.reverse(list);
        historyComboBox.setPossibleItems(list);
        historyComboBox.setPreferredSize(new Dimension(40, historyComboBox.getPreferredSize().height));
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("replace selection", new Object[0]), searchSetting.mode == SearchMode.replace);
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("add to selection", new Object[0]), searchSetting.mode == SearchMode.add);
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("remove from selection", new Object[0]), searchSetting.mode == SearchMode.remove);
        JRadioButton jRadioButton4 = new JRadioButton(I18n.tr("find in selection", new Object[0]), searchSetting.mode == SearchMode.in_selection);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        final JCheckBox jCheckBox = new JCheckBox(I18n.tr("case sensitive", new Object[0]), searchSetting.caseSensitive);
        JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("all objects", new Object[0]), searchSetting.allElements);
        jCheckBox2.setToolTipText(I18n.tr("Also include incomplete and deleted objects in search.", new Object[0]));
        final JCheckBox jCheckBox3 = new JCheckBox(I18n.tr("regular expression", new Object[0]), searchSetting.regexSearch);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.std().insets(0, 0, 5, 0));
        jPanel.add((Component)historyComboBox, GBC.eol().fill(2));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jRadioButton, GBC.eol());
        jPanel2.add((Component)jRadioButton2, GBC.eol());
        jPanel2.add((Component)jRadioButton3, GBC.eol());
        jPanel2.add((Component)jRadioButton4, GBC.eop());
        jPanel2.add((Component)jCheckBox, GBC.eol());
        if (Main.pref.getBoolean("expert", false)) {
            jPanel2.add((Component)jCheckBox2, GBC.eol());
            jPanel2.add((Component)jCheckBox3, GBC.eol());
        }
        JPanel jPanel3 = new JPanel();
        DescriptionTextBuilder descriptionTextBuilder = new DescriptionTextBuilder();
        descriptionTextBuilder.append("<html><style>li.header{font-size:110%; list-style-type:none; margin-top:5px;}</style><ul>");
        descriptionTextBuilder.appendItem(I18n.tr("<b>Baker Street</b> - ''Baker'' and ''Street'' in any key", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("<b>\"Baker Street\"</b> - ''Baker Street'' in any key", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("<b>key:Bak</b> - ''Bak'' anywhere in the key ''key''", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("<b>-key:Bak</b> - ''Bak'' nowhere in the key ''key''", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("<b>key=value</b> - key ''key'' with value exactly ''value''", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("<b>key=*</b> - key ''key'' with any value. Try also <b>*=value</b>, <b>key=</b>, <b>*=*</b>, <b>*=</b>", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("<b>key:</b> - key ''key'' set to any value", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("<b>key?</b> - key ''key'' with the value ''yes'', ''true'', ''1'' or ''on''", new Object[0]));
        if (Main.pref.getBoolean("expert", false)) {
            descriptionTextBuilder.appendItemHeader(I18n.tr("Special targets", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>type:</b>... - objects with corresponding type (<b>node</b>, <b>way</b>, <b>relation</b>)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>user:</b>... - objects changed by user", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>user:anonymous</b> - objects changed by anonymous users", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>id:</b>... - objects with given ID (0 for new objects)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>version:</b>... - objects with given version (0 objects without an assigned version)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>changeset:</b>... - objects with given changeset ID (0 objects without an assigned changeset)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>nodes:</b>... - objects with given number of nodes (<b>nodes:</b>count, <b>nodes:</b>min-max, <b>nodes:</b>min- or <b>nodes:</b>-max)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>tags:</b>... - objects with given number of tags (<b>tags:</b>count, <b>tags:</b>min-max, <b>tags:</b>min- or <b>tags:</b>-max)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>role:</b>... - objects with given role in a relation", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>timestamp:</b>... - objects with this timestamp (2009-11-12T14:51:09Z, 2009-11-12 or T14:51 ...)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>areasize:</b>... - closed ways with given area in m\u00b2 (<b>areasize:</b>min-max or <b>areasize:</b>max)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>modified</b> - all changed objects", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>selected</b> - all selected objects", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>incomplete</b> - all incomplete objects", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>untagged</b> - all untagged objects", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>closed</b> - all closed ways (a node is not considered closed)", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>child <i>expr</i></b> - all children of objects matching the expression", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>parent <i>expr</i></b> - all parents of objects matching the expression", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>(all)indownloadedarea</b> - objects (and all its way nodes / relation members) in downloaded area", new Object[0]));
            descriptionTextBuilder.appendItem(I18n.tr("<b>(all)inview</b> - objects (and all its way nodes / relation members) in current view", new Object[0]));
        }
        descriptionTextBuilder.appendItem(I18n.tr("Use <b>|</b> or <b>OR</b> to combine with logical or", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("Use <b>\"</b> to quote operators (e.g. if key contains <b>:</b>)", new Object[0]) + "<br/>" + I18n.tr("Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).", new Object[0]));
        descriptionTextBuilder.appendItem(I18n.tr("Use <b>(</b> and <b>)</b> to group expressions", new Object[0]));
        descriptionTextBuilder.append("</ul></html>");
        JLabel jLabel2 = new JLabel(descriptionTextBuilder.toString());
        jLabel2.setFont(jLabel2.getFont().deriveFont(0));
        jPanel3.add(jLabel2);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel, GBC.eol().fill(2).insets(5, 5, 5, 0));
        jPanel4.add((Component)jPanel2, GBC.std().anchor(11).insets(5, 10, 10, 0));
        jPanel4.add((Component)jPanel3, GBC.eol());
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, searchSetting instanceof Filter ? I18n.tr("Filter", new Object[0]) : I18n.tr("Search", new Object[0]), new String[]{searchSetting instanceof Filter ? I18n.tr("Submit filter", new Object[0]) : I18n.tr("Start Search", new Object[0]), I18n.tr("Cancel", new Object[0])}){

            protected void buttonAction(int n, ActionEvent actionEvent) {
                if (n == 0) {
                    try {
                        SearchCompiler.compile(historyComboBox.getText(), jCheckBox.isSelected(), jCheckBox3.isSelected());
                        super.buttonAction(n, actionEvent);
                    }
                    catch (SearchCompiler.ParseError parseError) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Search expression is not valid: \n\n {0}", parseError.getMessage()), I18n.tr("Invalid search expression", new Object[0]), 0);
                    }
                } else {
                    super.buttonAction(n, actionEvent);
                }
            }
        };
        extendedDialog.setButtonIcons(new String[]{"dialogs/search.png", "cancel.png"});
        extendedDialog.configureContextsensitiveHelp("/Action/Search", true);
        extendedDialog.setContent(jPanel4);
        extendedDialog.showDialog();
        int n = extendedDialog.getValue();
        if (n != 1) {
            return null;
        }
        SearchMode searchMode = jRadioButton.isSelected() ? SearchMode.replace : (jRadioButton2.isSelected() ? SearchMode.add : (jRadioButton3.isSelected() ? SearchMode.remove : SearchMode.in_selection));
        searchSetting.text = historyComboBox.getText();
        searchSetting.mode = searchMode;
        searchSetting.caseSensitive = jCheckBox.isSelected();
        searchSetting.allElements = jCheckBox2.isSelected();
        searchSetting.regexSearch = jCheckBox3.isSelected();
        return searchSetting;
    }

    public static void search() {
        SearchSetting searchSetting = SearchAction.showSearchDialog(lastSearch);
        if (searchSetting != null) {
            SearchAction.searchWithHistory(searchSetting);
        }
    }

    public static void searchWithHistory(SearchSetting searchSetting) {
        SearchAction.saveToHistory(searchSetting);
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static void searchWithoutHistory(SearchSetting searchSetting) {
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static int getSelection(SearchSetting searchSetting, Collection<OsmPrimitive> collection, Function function) {
        int n = 0;
        try {
            String string = searchSetting.text;
            SearchCompiler.Match match = SearchCompiler.compile(string, searchSetting.caseSensitive, searchSetting.regexSearch);
            if (searchSetting.mode == SearchMode.replace) {
                collection.clear();
            }
            Collection<OsmPrimitive> collection2 = searchSetting.allElements ? Main.main.getCurrentDataSet().allPrimitives() : Main.main.getCurrentDataSet().allNonDeletedCompletePrimitives();
            for (OsmPrimitive osmPrimitive : collection2) {
                if (searchSetting.mode == SearchMode.replace) {
                    if (!match.match(osmPrimitive)) continue;
                    collection.add(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode == SearchMode.add && !function.isSomething(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    collection.add(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode == SearchMode.remove && function.isSomething(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    collection.remove(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode != SearchMode.in_selection || !function.isSomething(osmPrimitive).booleanValue() || match.match(osmPrimitive)) continue;
                collection.remove(osmPrimitive);
                ++n;
            }
        }
        catch (SearchCompiler.ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
        return n;
    }

    public static void getSelection(SearchSetting searchSetting, Collection<OsmPrimitive> collection, Property<OsmPrimitive, Boolean> property) {
        try {
            String string = searchSetting.text;
            if (searchSetting instanceof Filter && ((Filter)searchSetting).inverted) {
                string = String.format("-(%s)", string);
            }
            SearchCompiler.Match match = SearchCompiler.compile(string, searchSetting.caseSensitive, searchSetting.regexSearch);
            for (OsmPrimitive osmPrimitive : collection) {
                if (searchSetting.mode == SearchMode.replace) {
                    if (match.match(osmPrimitive)) {
                        property.set(osmPrimitive, true);
                        continue;
                    }
                    property.set(osmPrimitive, false);
                    continue;
                }
                if (searchSetting.mode == SearchMode.add && !property.get(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    property.set(osmPrimitive, true);
                    continue;
                }
                if (searchSetting.mode == SearchMode.remove && property.get(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    property.set(osmPrimitive, false);
                    continue;
                }
                if (searchSetting.mode != SearchMode.in_selection || !property.get(osmPrimitive).booleanValue() || match.match(osmPrimitive)) continue;
                property.set(osmPrimitive, false);
            }
        }
        catch (SearchCompiler.ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    public static void search(String string, SearchMode searchMode) {
        SearchAction.search(new SearchSetting(string, searchMode, false, false, false));
    }

    public static void search(SearchSetting searchSetting) {
        final DataSet dataSet = Main.main.getCurrentDataSet();
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(dataSet.getSelected());
        int n = SearchAction.getSelection(searchSetting, hashSet, new Function(){

            public Boolean isSomething(OsmPrimitive osmPrimitive) {
                return dataSet.isSelected(osmPrimitive);
            }
        });
        dataSet.setSelected(hashSet);
        if (n == 0) {
            String string = null;
            if (searchSetting.mode == SearchMode.replace) {
                string = I18n.tr("No match found for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.add) {
                string = I18n.tr("Nothing added to selection by searching for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.remove) {
                string = I18n.tr("Nothing removed from selection by searching for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.in_selection) {
                string = I18n.tr("Nothing found in selection by searching for ''{0}''", searchSetting.text);
            }
            Main.map.statusLine.setHelpText(string);
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2);
        } else {
            Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", n));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(SearchAction.getEditLayer() != null);
    }

    @Override
    public List<ActionParameter<?>> getActionParameters() {
        return Collections.singletonList(new ActionParameter.SearchSettingsActionParameter(SEARCH_EXPRESSION));
    }

    public static String escapeStringForSearch(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static class SearchSetting {
        public String text;
        public SearchMode mode;
        public boolean caseSensitive;
        public boolean regexSearch;
        public boolean allElements;

        public SearchSetting() {
            this("", SearchMode.replace, false, false, false);
        }

        public SearchSetting(String string, SearchMode searchMode, boolean bl, boolean bl2, boolean bl3) {
            this.caseSensitive = bl;
            this.regexSearch = bl2;
            this.allElements = bl3;
            this.mode = searchMode;
            this.text = string;
        }

        public SearchSetting(SearchSetting searchSetting) {
            this(searchSetting.text, searchSetting.mode, searchSetting.caseSensitive, searchSetting.regexSearch, searchSetting.allElements);
        }

        public String toString() {
            String string = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
            String string2 = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
            String string3 = this.allElements ? ", " + I18n.trc("search", "A") : "";
            return "\"" + this.text + "\" (" + string + string2 + string3 + ", " + (Object)((Object)this.mode) + ")";
        }

        public boolean equals(Object object) {
            if (!(object instanceof SearchSetting)) {
                return false;
            }
            SearchSetting searchSetting = (SearchSetting)object;
            return searchSetting.caseSensitive == this.caseSensitive && searchSetting.regexSearch == this.regexSearch && searchSetting.allElements == this.allElements && searchSetting.mode.equals((Object)this.mode) && searchSetting.text.equals(this.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public static SearchSetting readFromString(String string) {
            if (string.length() == 0) {
                return null;
            }
            SearchSetting searchSetting = new SearchSetting();
            int n = 1;
            searchSetting.mode = SearchMode.fromCode(string.charAt(0));
            if (searchSetting.mode == null) {
                searchSetting.mode = SearchMode.replace;
                n = 0;
            }
            while (n < string.length()) {
                if (string.charAt(n) == 'C') {
                    searchSetting.caseSensitive = true;
                } else if (string.charAt(n) == 'R') {
                    searchSetting.regexSearch = true;
                } else if (string.charAt(n) == 'A') {
                    searchSetting.allElements = true;
                } else {
                    if (string.charAt(n) == ' ') break;
                    System.out.println("Unknown char in SearchSettings: " + string);
                    break;
                }
                ++n;
            }
            if (n < string.length() && string.charAt(n) == ' ') {
                ++n;
            }
            searchSetting.text = string.substring(n);
            return searchSetting;
        }

        public String writeToString() {
            if (this.text == null || this.text.length() == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.mode.getCode());
            if (this.caseSensitive) {
                stringBuilder.append('C');
            }
            if (this.regexSearch) {
                stringBuilder.append('R');
            }
            if (this.allElements) {
                stringBuilder.append('A');
            }
            stringBuilder.append(' ');
            stringBuilder.append(this.text);
            return stringBuilder.toString();
        }
    }

    public static interface Function {
        public Boolean isSomething(OsmPrimitive var1);
    }

    private static class DescriptionTextBuilder {
        StringBuilder s = new StringBuilder(4096);

        private DescriptionTextBuilder() {
        }

        public StringBuilder append(String string) {
            return this.s.append(string);
        }

        StringBuilder appendItem(String string) {
            return this.append("<li>").append(string).append("</li>\n");
        }

        StringBuilder appendItemHeader(String string) {
            return this.append("<li class=\"header\">").append(string).append("</li>\n");
        }

        public String toString() {
            return this.s.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        replace('R'),
        add('A'),
        remove('D'),
        in_selection('S');

        private final char code;

        private SearchMode(char c) {
            this.code = c;
        }

        public char getCode() {
            return this.code;
        }

        public static SearchMode fromCode(char c) {
            for (SearchMode searchMode : SearchMode.values()) {
                if (searchMode.getCode() != c) continue;
                return searchMode;
            }
            return null;
        }
    }
}

