/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.ScaleCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAction
extends MapMode
implements AWTEventListener,
SelectionManager.SelectionEnded {
    private MouseEvent oldEvent = null;
    private Mode mode = null;
    private SelectionManager selectionManager;
    private boolean cancelDrawMode = false;
    private boolean drawTargetHighlight;
    private boolean didMouseDrag = false;
    private final MapView mv;
    private Point startingDraggingPos;
    private Point lastMousePos;
    private long mouseDownTime = 0L;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded = false;
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private Node virtualNode = null;
    private Collection<WaySegment> virtualWays = new LinkedList<WaySegment>();
    private Collection<OsmPrimitive> cycleList = Collections.emptyList();
    private boolean cyclePrims = false;
    private OsmPrimitive cycleStart = null;

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select", new Object[0]), "move/move", I18n.tr("Select, move, scale and rotate objects", new Object[0]), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select", new Object[0])), 83, 3), mapFrame, ImageProvider.getCursor("normal", "selection"));
        this.mv = mapFrame.mapView;
        this.putValue("help", HelpUtil.ht("/Action/Move/Move"));
        this.selectionManager = new SelectionManager(this, false, this.mv);
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("edit.initial-move-threshold", 5);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(this.mv);
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(false);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.removeHighlighting();
    }

    private Cursor getCursor(Collection<OsmPrimitive> collection) {
        String string = "rect";
        switch (this.mode) {
            case move: {
                OsmPrimitive osmPrimitive;
                if (this.virtualNode != null) {
                    string = "virtual_node";
                    break;
                }
                Iterator<OsmPrimitive> iterator = collection.iterator();
                OsmPrimitive osmPrimitive2 = osmPrimitive = iterator.hasNext() ? iterator.next() : null;
                if (this.dragInProgress()) {
                    String string2 = string = this.ctrl ? "merge" : "move";
                    if (osmPrimitive == null || !(osmPrimitive instanceof Node) || !this.ctrl) break;
                    string = string + "_to_node";
                    break;
                }
                string = osmPrimitive instanceof Node ? "node" : string;
                String string3 = string = osmPrimitive instanceof Way ? "way" : string;
                if (this.shift) {
                    string = string + "_add";
                    break;
                }
                if (!this.ctrl) break;
                string = string + (osmPrimitive == null || osmPrimitive.isSelected() ? "_rm" : "_add");
                break;
            }
            case rotate: {
                string = "rotate";
                break;
            }
            case scale: {
                string = "scale";
                break;
            }
            case select: {
                string = "rect" + (this.shift ? "_add" : (this.ctrl ? "_rm" : ""));
            }
        }
        return SelectActionCursor.valueOf(string).cursor();
    }

    private boolean removeHighlighting() {
        boolean bl = false;
        DataSet dataSet = SelectAction.getCurrentDataSet();
        if (dataSet != null && !dataSet.getHighlightedVirtualNodes().isEmpty()) {
            bl = true;
            dataSet.clearHighlightedVirtualNodes();
        }
        if (this.oldHighlights.isEmpty()) {
            return bl;
        }
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.setHighlighted(false);
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
        return true;
    }

    private boolean giveUserFeedback(MouseEvent mouseEvent) {
        return this.giveUserFeedback(mouseEvent, mouseEvent.getModifiers());
    }

    private boolean giveUserFeedback(MouseEvent mouseEvent, int n) {
        boolean bl = false;
        Collection<OsmPrimitive> collection = MapView.asColl(this.mv.getNearestNodeOrWay(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate, true));
        this.updateKeyModifiers(n);
        this.determineMapMode(!collection.isEmpty());
        if (this.drawTargetHighlight) {
            bl = this.removeHighlighting();
        }
        this.virtualWays.clear();
        this.virtualNode = null;
        if (this.mode == Mode.move && this.setupVirtual(mouseEvent)) {
            DataSet dataSet = SelectAction.getCurrentDataSet();
            if (dataSet != null) {
                dataSet.setHighlightedVirtualNodes(this.virtualWays);
            }
            this.mv.setNewCursor(SelectActionCursor.virtual_node.cursor(), (Object)this);
            return true;
        }
        this.mv.setNewCursor(this.getCursor(collection), (Object)this);
        if (!this.drawTargetHighlight || this.mode != Mode.move || collection.isEmpty()) {
            return bl;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (!this.ctrl && osmPrimitive.isSelected()) continue;
            osmPrimitive.setHighlighted(true);
            this.oldHighlights.add(osmPrimitive);
        }
        return bl || !this.oldHighlights.isEmpty();
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (this.oldEvent == null) {
            return;
        }
        if (this.giveUserFeedback(this.oldEvent, ((InputEvent)aWTEvent).getModifiers())) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        Object object;
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.cancelDrawMode = true;
        if (this.mode == Mode.select) {
            return;
        }
        if (this.mode == Mode.move && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.rotate && this.mode != Mode.scale && (mouseEvent.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.move) {
            object = this.ctrl ? this.findNodeToMergeTo(mouseEvent) : null;
            n = this.removeHighlighting();
            if (object != null) {
                ((OsmPrimitive)object).setHighlighted(true);
                this.oldHighlights.add((OsmPrimitive)object);
                n = 1;
            }
            this.mv.setNewCursor(this.getCursor(MapView.asColl(object)), (Object)this);
            if (n != 0) {
                this.mv.repaint();
            }
        }
        if (this.startingDraggingPos == null) {
            this.startingDraggingPos = new Point(mouseEvent.getX(), mouseEvent.getY());
        }
        if (this.lastMousePos == null) {
            this.lastMousePos = mouseEvent.getPoint();
            return;
        }
        if (!this.initialMoveThresholdExceeded) {
            int n2 = this.lastMousePos.x - mouseEvent.getX();
            int n3 = (int)Math.sqrt(n2 * n2 + (n = this.lastMousePos.y - mouseEvent.getY()) * n);
            if (n3 < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        object = this.mv.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        EastNorth eastNorth = this.mv.getEastNorth(this.lastMousePos.x, this.lastMousePos.y);
        double d = ((EastNorth)object).east() - eastNorth.east();
        double d2 = ((EastNorth)object).north() - eastNorth.north();
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        if (this.virtualWays.size() > 0) {
            LinkedList<Command> linkedList = new LinkedList<Command>();
            linkedList.add(new AddCommand(this.virtualNode));
            for (WaySegment waySegment : this.virtualWays) {
                Way way = waySegment.way;
                Way way2 = new Way(way);
                way2.addNode(waySegment.lowerIndex + 1, this.virtualNode);
                linkedList.add(new ChangeCommand(way, way2));
            }
            linkedList.add(new MoveCommand(this.virtualNode, d, d2));
            String string = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            Main.main.undoRedo.add(new SequenceCommand(string, linkedList));
            SelectAction.getCurrentDataSet().setSelected(Collections.singleton(this.virtualNode));
            this.virtualWays.clear();
            this.virtualNode = null;
        } else {
            Command command;
            Collection<OsmPrimitive> collection = SelectAction.getCurrentDataSet().getSelectedNodesAndWays();
            Collection<Node> collection2 = AllNodesVisitor.getAllNodes(collection);
            if (collection2.size() < 2 && (this.mode == Mode.rotate || this.mode == Mode.scale)) {
                return;
            }
            Command command2 = command = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
            if (command instanceof SequenceCommand) {
                command = ((SequenceCommand)command).getLastCommand();
            }
            if (this.mode == Mode.move) {
                if (command instanceof MoveCommand && ((Object)collection2).equals(((MoveCommand)command).getParticipatingPrimitives())) {
                    ((MoveCommand)command).moveAgain(d, d2);
                } else {
                    command = new MoveCommand(collection, d, d2);
                    Main.main.undoRedo.add(command);
                }
                for (Node node : collection2) {
                    if (!node.getCoor().isOutSideWorld()) continue;
                    ((MoveCommand)command).moveAgain(-d, -d2);
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                    this.mv.setNewCursor(this.cursor, (Object)this);
                    return;
                }
            } else if (this.mode == Mode.rotate) {
                if (command instanceof RotateCommand && ((Object)collection2).equals(((RotateCommand)command).getTransformedNodes())) {
                    ((RotateCommand)command).handleEvent((EastNorth)object);
                } else {
                    Main.main.undoRedo.add(new RotateCommand(collection, (EastNorth)object));
                }
            } else if (this.mode == Mode.scale) {
                if (command instanceof ScaleCommand && ((Object)collection2).equals(((ScaleCommand)command).getTransformedNodes())) {
                    ((ScaleCommand)command).handleEvent((EastNorth)object);
                } else {
                    Main.main.undoRedo.add(new ScaleCommand(collection, (EastNorth)object));
                }
            }
        }
        this.mv.repaint();
        if (this.mode != Mode.scale) {
            this.lastMousePos = mouseEvent.getPoint();
        }
        this.didMouseDrag = true;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (Main.platform instanceof PlatformHookOsx && (this.mode == Mode.rotate || this.mode == Mode.scale)) {
            this.mouseDragged(mouseEvent);
            return;
        }
        this.oldEvent = mouseEvent;
        if (this.giveUserFeedback(mouseEvent)) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.removeHighlighting()) {
            this.mv.repaint();
        }
    }

    private final boolean dragInProgress() {
        return this.didMouseDrag && this.startingDraggingPos != null;
    }

    private boolean setupVirtual(MouseEvent mouseEvent) {
        if (Main.pref.getInteger("mappaint.node.virtual-size", 8) > 0) {
            int n = Main.pref.getInteger("mappaint.node.virtual-snap-distance", 8);
            int n2 = Main.pref.getInteger("mappaint.node.virtual-space", 70);
            n *= n;
            LinkedList<WaySegment> linkedList = new LinkedList<WaySegment>();
            Pair pair = null;
            Pair<Object, Object> pair2 = new Pair<Object, Object>(null, null);
            Point point = mouseEvent.getPoint();
            Way way = null;
            for (WaySegment waySegment : this.mv.getNearestWaySegments(point, OsmPrimitive.isSelectablePredicate)) {
                Point2D.Double double_;
                Point2D point2D;
                way = waySegment.way;
                pair2.a = way.getNode(waySegment.lowerIndex);
                Point2D point2D2 = this.mv.getPoint2D((Node)pair2.a);
                if (!WireframeMapRenderer.isLargeSegment(point2D2, point2D = this.mv.getPoint2D((Node)(pair2.b = way.getNode(waySegment.lowerIndex + 1))), n2) || !(point.distanceSq(double_ = new Point2D.Double((point2D2.getX() + point2D.getX()) / 2.0, (point2D2.getY() + point2D.getY()) / 2.0)) < (double)n)) continue;
                Pair.sort(pair2);
                if (pair == null) {
                    pair = new Pair(pair2.a, pair2.b);
                    this.virtualNode = new Node(this.mv.getLatLon(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                }
                if (!pair.equals(pair2)) continue;
                (way.isSelected() ? linkedList : this.virtualWays).add(waySegment);
            }
            if (!linkedList.isEmpty()) {
                this.virtualWays = linkedList;
            }
        }
        return !this.virtualWays.isEmpty();
    }

    private Collection<OsmPrimitive> cycleSetup(Collection<OsmPrimitive> collection, MouseEvent mouseEvent) {
        OsmPrimitive osmPrimitive = null;
        if (collection != null && !collection.isEmpty()) {
            osmPrimitive = collection.iterator().next();
            Point point = mouseEvent.getPoint();
            boolean bl = Main.pref.getBoolean("mappaint.select.waits-for-mouse-up", false);
            this.updateKeyModifiers(mouseEvent);
            boolean bl2 = this.alt = this.alt || Main.pref.getBoolean("selectaction.cycles.multiple.matches", false);
            if (!this.alt) {
                this.cycleList = MapView.asColl(osmPrimitive);
                if (bl) {
                    osmPrimitive = this.mv.getNearestNodeOrWay(point, OsmPrimitive.isSelectablePredicate, true);
                }
            } else {
                if (osmPrimitive instanceof Node) {
                    this.cycleList = new LinkedList<Node>(this.mv.getNearestNodes(point, OsmPrimitive.isSelectablePredicate));
                } else if (osmPrimitive instanceof Way) {
                    this.cycleList = new LinkedList<Way>(this.mv.getNearestWays(point, OsmPrimitive.isSelectablePredicate));
                }
                if (this.cycleList.size() > 1) {
                    this.cyclePrims = false;
                    OsmPrimitive osmPrimitive2 = osmPrimitive;
                    for (OsmPrimitive osmPrimitive3 : this.cycleList) {
                        if (!osmPrimitive3.isSelected()) continue;
                        this.cyclePrims = true;
                        osmPrimitive = osmPrimitive3;
                        break;
                    }
                    if (!(this.cycleList.size() != 2 || bl || osmPrimitive.equals(osmPrimitive2) || osmPrimitive.isNew() || this.ctrl)) {
                        this.cyclePrims = false;
                        osmPrimitive = osmPrimitive2;
                    }
                }
            }
        }
        return MapView.asColl(osmPrimitive);
    }

    private void determineMapMode(boolean bl) {
        this.mode = this.shift && this.ctrl ? Mode.rotate : (this.alt && this.ctrl ? Mode.scale : (bl || this.dragInProgress() ? Mode.move : Mode.select));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.mv.isActiveLayerVisible() || !((Boolean)this.getValue("active")).booleanValue() || mouseEvent.getButton() != 1) {
            return;
        }
        this.mv.requestFocus();
        this.updateKeyModifiers(mouseEvent);
        this.cancelDrawMode = this.shift || this.ctrl;
        this.didMouseDrag = false;
        this.initialMoveThresholdExceeded = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.lastMousePos = mouseEvent.getPoint();
        Collection<OsmPrimitive> collection = MapView.asColl(this.mv.getNearestNodeOrWay(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate, true));
        this.determineMapMode(!collection.isEmpty());
        switch (this.mode) {
            case rotate: 
            case scale: {
                if (!SelectAction.getCurrentDataSet().getSelected().isEmpty()) break;
                SelectAction.getCurrentDataSet().setSelected(collection);
                break;
            }
            case move: {
                if (!this.cancelDrawMode && collection.iterator().next() instanceof Way) {
                    this.setupVirtual(mouseEvent);
                }
                this.selectPrims(this.cycleSetup(collection, mouseEvent), mouseEvent, false, false);
                break;
            }
            default: {
                this.selectionManager.register(this.mv);
                this.selectionManager.mousePressed(mouseEvent);
            }
        }
        this.giveUserFeedback(mouseEvent);
        this.mv.repaint();
        this.updateStatusLine();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.startingDraggingPos = null;
        if (this.mode == Mode.select) {
            this.selectionManager.unregister(this.mv);
            if (SelectAction.getCurrentDataSet().getSelected().size() == 0 && !this.cancelDrawMode) {
                Main.map.selectDrawTool(true);
                return;
            }
        }
        if (this.mode == Mode.move && mouseEvent.getButton() == 1) {
            if (!this.didMouseDrag) {
                this.virtualWays.clear();
                this.virtualNode = null;
                if (this.lastMousePos == null || this.lastMousePos.distanceSq(mouseEvent.getPoint()) < 100.0) {
                    this.selectPrims(this.cyclePrims(this.cycleList, mouseEvent), mouseEvent, true, false);
                    Collection<OsmPrimitive> collection = SelectAction.getCurrentDataSet().getSelected();
                    if (mouseEvent.getClickCount() >= 2 && collection.size() == 1 && collection.iterator().next() instanceof Node) {
                        Main.worker.execute(new Runnable(){

                            public void run() {
                                Main.map.selectDrawTool(true);
                            }
                        });
                        return;
                    }
                }
            } else {
                int n;
                int n2 = n = Main.pref.getInteger("warn.move.maxelements", 20);
                for (OsmPrimitive osmPrimitive : SelectAction.getCurrentDataSet().getSelected()) {
                    if (osmPrimitive instanceof Way) {
                        n2 -= ((Way)osmPrimitive).getNodes().size();
                    }
                    if (--n2 >= 0) continue;
                    break;
                }
                if (n2 < 0) {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Move elements", new Object[0]), new String[]{I18n.tr("Move them", new Object[0]), I18n.tr("Undo move", new Object[0])});
                    extendedDialog.setButtonIcons(new String[]{"reorder.png", "cancel.png"});
                    extendedDialog.setContent(I18n.tr("You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", n));
                    extendedDialog.setCancelButton(2);
                    extendedDialog.toggleEnable("movedManyElements");
                    extendedDialog.showDialog();
                    if (extendedDialog.getValue() != 1) {
                        Main.main.undoRedo.undo();
                    }
                } else {
                    this.mergePrims(mouseEvent);
                }
                SelectAction.getCurrentDataSet().fireSelectionChanged();
            }
        }
        this.mode = null;
        if (mouseEvent.getButton() == 2) {
            this.removeHighlighting();
        } else {
            this.giveUserFeedback(mouseEvent);
        }
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle rectangle, MouseEvent mouseEvent) {
        this.updateKeyModifiers(mouseEvent);
        this.selectPrims(this.selectionManager.getObjectsInRectangle(rectangle, this.alt), mouseEvent, true, true);
    }

    private Collection<OsmPrimitive> cyclePrims(Collection<OsmPrimitive> collection, MouseEvent mouseEvent) {
        OsmPrimitive osmPrimitive = null;
        if (collection.size() > 1) {
            this.updateKeyModifiers(mouseEvent);
            DataSet dataSet = SelectAction.getCurrentDataSet();
            OsmPrimitive osmPrimitive2 = collection.iterator().next();
            OsmPrimitive osmPrimitive3 = null;
            osmPrimitive = osmPrimitive2;
            Iterator<OsmPrimitive> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.cyclePrims && this.shift) {
                    osmPrimitive = iterator.next();
                    if (osmPrimitive.isSelected()) continue;
                    break;
                }
                osmPrimitive = iterator.next();
                if (!osmPrimitive.isSelected()) continue;
                osmPrimitive3 = osmPrimitive;
                if (!this.cyclePrims && !this.ctrl) break;
                dataSet.clearSelection(osmPrimitive3);
                OsmPrimitive osmPrimitive4 = osmPrimitive = iterator.hasNext() ? iterator.next() : osmPrimitive2;
                break;
            }
            if (this.ctrl) {
                if (osmPrimitive3 != null) {
                    if (!collection.contains(this.cycleStart)) {
                        dataSet.clearSelection(collection);
                        this.cycleStart = osmPrimitive3;
                    } else if (this.cycleStart.equals(osmPrimitive)) {
                        dataSet.addSelected(osmPrimitive);
                    }
                } else {
                    this.cycleStart = osmPrimitive = collection.contains(this.cycleStart) ? this.cycleStart : osmPrimitive2;
                }
            } else {
                this.cycleStart = null;
            }
        }
        return osmPrimitive != null ? MapView.asColl(osmPrimitive) : collection;
    }

    private final void mergePrims(MouseEvent mouseEvent) {
        this.updateKeyModifiers(mouseEvent);
        Collection<Node> collection = SelectAction.getCurrentDataSet().getSelectedNodes();
        if (!this.ctrl || collection.isEmpty()) {
            return;
        }
        Node node = this.findNodeToMergeTo(mouseEvent);
        if (node == null) {
            return;
        }
        LinkedList<Node> linkedList = new LinkedList<Node>(collection);
        linkedList.add(node);
        Command command = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), linkedList, node);
        if (command != null) {
            Main.main.undoRedo.add(command);
            SelectAction.getCurrentDataSet().setSelected(node);
        }
    }

    private final Node findNodeToMergeTo(MouseEvent mouseEvent) {
        List<Node> list = this.mv.getNearestNodes(mouseEvent.getPoint(), SelectAction.getCurrentDataSet().getSelectedNodes(), OsmPrimitive.isSelectablePredicate);
        return list.isEmpty() ? null : (Node)list.iterator().next();
    }

    private void selectPrims(Collection<OsmPrimitive> collection, MouseEvent mouseEvent, boolean bl, boolean bl2) {
        this.updateKeyModifiers(mouseEvent);
        DataSet dataSet = SelectAction.getCurrentDataSet();
        if (this.shift && this.ctrl || this.ctrl && !bl || !this.virtualWays.isEmpty()) {
            return;
        }
        if (!bl) {
            this.shift |= SelectAction.getCurrentDataSet().getSelected().containsAll(collection);
        }
        if (this.ctrl) {
            if (bl2) {
                dataSet.clearSelection(collection);
            } else {
                dataSet.toggleSelected(collection);
            }
        } else if (this.shift) {
            dataSet.addSelected(collection);
        } else {
            dataSet.setSelected(collection);
        }
    }

    @Override
    public String getModeHelpText() {
        if (this.mode == Mode.select) {
            return I18n.tr("Release the mouse button to select the objects in the rectangle.", new Object[0]);
        }
        if (this.mode == Mode.move) {
            return I18n.tr("Release the mouse button to stop moving. Ctrl to merge with nearest node.", new Object[0]);
        }
        if (this.mode == Mode.rotate) {
            return I18n.tr("Release the mouse button to stop rotating.", new Object[0]);
        }
        if (this.mode == Mode.scale) {
            return I18n.tr("Release the mouse button to stop scaling.", new Object[0]);
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection (Ctrl to toggle); Shift-Ctrl to rotate selected; Alt-Ctrl to scale selected; or change selection", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectActionCursor {
        rect("normal", "selection"),
        rect_add("normal", "select_add"),
        rect_rm("normal", "select_remove"),
        way("normal", "select_way"),
        way_add("normal", "select_way_add"),
        way_rm("normal", "select_way_remove"),
        node("normal", "select_node"),
        node_add("normal", "select_node_add"),
        node_rm("normal", "select_node_remove"),
        virtual_node("normal", "addnode"),
        scale("scale", null),
        rotate("rotate", null),
        merge("crosshair", null),
        merge_to_node("crosshair", "joinnode"),
        move(13);

        private final Cursor c;

        private SelectActionCursor(String string2, String string3) {
            this.c = ImageProvider.getCursor(string2, string3);
        }

        private SelectActionCursor(int n2) {
            this.c = Cursor.getPredefinedCursor(n2);
        }

        public Cursor cursor() {
            return this.c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        move,
        rotate,
        scale,
        select;

    }
}

