/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.util.List;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPolygonImpl
implements MapPolygon {
    private List<Coordinate> points;
    private Color color;
    private Stroke stroke;

    public MapPolygonImpl(List<Coordinate> list) {
        this(list, Color.BLUE, new BasicStroke(2.0f));
    }

    public MapPolygonImpl(List<Coordinate> list, Color color, Stroke stroke) {
        this.points = list;
        this.color = color;
        this.stroke = stroke;
    }

    @Override
    public List<Coordinate> getPoints() {
        return this.points;
    }

    @Override
    public void paint(Graphics graphics, List<Point> list) {
        Polygon polygon = new Polygon();
        for (Point point : list) {
            polygon.addPoint(point.x, point.y);
        }
        this.paint(graphics, polygon);
    }

    @Override
    public void paint(Graphics graphics, Polygon polygon) {
        Color color = graphics.getColor();
        graphics.setColor(this.color);
        Stroke stroke = null;
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.stroke);
        }
        graphics.drawPolygon(polygon);
        graphics.setColor(color);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
    }

    public String toString() {
        return "MapPolygon [points=" + this.points + "]";
    }
}

