/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.tools.I18n;

public class JosmPreferencesCredentialAgent
extends AbstractCredentialsAgent {
    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        switch (requestorType) {
            case SERVER: {
                String string = Main.pref.get("osm-server.username", null);
                String string2 = Main.pref.get("osm-server.password", null);
                if (string == null) {
                    return null;
                }
                return new PasswordAuthentication(string, string2 == null ? new char[]{} : string2.toCharArray());
            }
            case PROXY: {
                String string = Main.pref.get("proxy.user", null);
                String string3 = Main.pref.get("proxy.pass", null);
                if (string == null) {
                    return null;
                }
                return new PasswordAuthentication(string, string3 == null ? new char[]{} : string3.toCharArray());
            }
        }
        return null;
    }

    public void store(Authenticator.RequestorType requestorType, PasswordAuthentication passwordAuthentication) throws CredentialsAgentException {
        if (requestorType == null) {
            return;
        }
        switch (requestorType) {
            case SERVER: {
                Main.pref.put("osm-server.username", passwordAuthentication.getUserName());
                if (passwordAuthentication.getPassword() == null) {
                    Main.pref.put("osm-server.password", null);
                    break;
                }
                Main.pref.put("osm-server.password", String.valueOf(passwordAuthentication.getPassword()));
                break;
            }
            case PROXY: {
                Main.pref.put("proxy.user", passwordAuthentication.getUserName());
                if (passwordAuthentication.getPassword() == null) {
                    Main.pref.put("proxy.pass", null);
                    break;
                }
                Main.pref.put("proxy.pass", String.valueOf(passwordAuthentication.getPassword()));
            }
        }
    }

    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        String string = Main.pref.get("oauth.access-token.key", null);
        String string2 = Main.pref.get("oauth.access-token.secret", null);
        if (string == null && string2 == null) {
            return null;
        }
        return new OAuthToken(string, string2);
    }

    public void storeOAuthAccessToken(OAuthToken oAuthToken) throws CredentialsAgentException {
        if (oAuthToken == null) {
            Main.pref.put("oauth.access-token.key", null);
            Main.pref.put("oauth.access-token.secret", null);
        } else {
            Main.pref.put("oauth.access-token.key", oAuthToken.getKey());
            Main.pref.put("oauth.access-token.secret", oAuthToken.getSecret());
        }
    }

    public Component getPreferencesDecorationPanel() {
        HtmlPanel htmlPanel = new HtmlPanel();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)htmlPanel.getEditorPane().getEditorKit();
        hTMLEditorKit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        htmlPanel.setText(I18n.tr("<html><body><p class=\"warning-body\"><strong>Warning:</strong> The password is stored in plain text in the JOSM preferences file. Furthermore, it is transferred <strong>unencrypted</strong> in every request sent to the OSM server. <strong>Do not use a valuable password.</strong></p></body></html>", new Object[0]));
        return htmlPanel;
    }

    public String getSaveUsernameAndPasswordCheckboxText() {
        return I18n.tr("Save user and password (unencrypted)", new Object[0]);
    }
}

