/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class OsmReader {
    private DataSet ds = new DataSet();
    private XMLStreamReader parser;
    private Map<PrimitiveId, OsmPrimitive> externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    private Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    private Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();
    private Changeset uploadChangeset;

    private OsmReader() {
        this.externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    }

    public void setParser(XMLStreamReader xMLStreamReader) {
        this.parser = xMLStreamReader;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    protected void throwException(String string) throws XMLStreamException {
        throw new OsmParsingException(string, this.parser.getLocation());
    }

    public void parse() throws XMLStreamException {
        int n = this.parser.getEventType();
        while (true) {
            if (n == 1) {
                if (this.parser.getLocalName().equals("osm") || this.parser.getLocalName().equals("osmChange")) {
                    this.parseOsm();
                } else {
                    this.parseUnkown();
                }
            } else if (n == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            n = this.parser.next();
        }
        this.parser.close();
    }

    private void parseOsm() throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "version");
        if (string == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
        }
        if (!string.equals("0.5") && !string.equals("0.6")) {
            this.throwException(I18n.tr("Unsupported version: {0}", string));
        }
        this.ds.setVersion(string);
        String string2 = this.parser.getAttributeValue(null, "generator");
        Long l = null;
        if (this.parser.getAttributeValue(null, "upload-changeset") != null) {
            l = this.getLong("upload-changeset");
        }
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("bounds")) {
                    this.parseBounds(string2);
                    continue;
                }
                if (this.parser.getLocalName().equals("node")) {
                    this.parseNode();
                    continue;
                }
                if (this.parser.getLocalName().equals("way")) {
                    this.parseWay();
                    continue;
                }
                if (this.parser.getLocalName().equals("relation")) {
                    this.parseRelation();
                    continue;
                }
                if (this.parser.getLocalName().equals("changeset")) {
                    this.parseChangeset(l);
                    continue;
                }
                this.parseUnkown();
                continue;
            }
            if (n == 2) break;
        }
    }

    private void parseBounds(String string) throws XMLStreamException {
        String string2 = this.parser.getAttributeValue(null, "minlon");
        String string3 = this.parser.getAttributeValue(null, "minlat");
        String string4 = this.parser.getAttributeValue(null, "maxlon");
        String string5 = this.parser.getAttributeValue(null, "maxlat");
        String string6 = this.parser.getAttributeValue(null, "origin");
        if (string2 != null && string4 != null && string3 != null && string5 != null) {
            Object object;
            Bounds bounds;
            if (string6 == null) {
                string6 = string;
            }
            if ((bounds = new Bounds(Double.parseDouble(string3), Double.parseDouble(string2), Double.parseDouble(string5), Double.parseDouble(string4))).isOutOfTheWorld()) {
                object = new Bounds(bounds);
                bounds.normalize();
                System.out.println("Bbox " + object + " is out of the world, normalized to " + bounds);
            }
            object = new DataSource(bounds, string6);
            this.ds.dataSources.add((DataSource)object);
        } else {
            this.throwException(I18n.tr("Missing mandatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{3}'',maxlat=''{4}'', origin=''{5}''.", string2, string3, string4, string5, string6));
        }
        this.jumpToEnd();
    }

    private void parseNode() throws XMLStreamException {
        NodeData nodeData = new NodeData();
        nodeData.setCoor(new LatLon(Double.parseDouble(this.parser.getAttributeValue(null, "lat")), Double.parseDouble(this.parser.getAttributeValue(null, "lon"))));
        this.readCommon(nodeData);
        Node node = new Node(nodeData.getId(), nodeData.getVersion());
        node.setVisible(nodeData.isVisible());
        node.load(nodeData);
        this.externalIdMap.put(nodeData.getPrimitiveId(), node);
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("tag")) {
                    this.parseTag(node);
                    continue;
                }
                this.parseUnkown();
                continue;
            }
            if (n == 2) break;
        }
    }

    private void parseWay() throws XMLStreamException {
        WayData wayData = new WayData();
        this.readCommon(wayData);
        Way way = new Way(wayData.getId(), wayData.getVersion());
        way.setVisible(wayData.isVisible());
        way.load(wayData);
        this.externalIdMap.put(wayData.getPrimitiveId(), way);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("nd")) {
                    arrayList.add(this.parseWayNode(way));
                    continue;
                }
                if (this.parser.getLocalName().equals("tag")) {
                    this.parseTag(way);
                    continue;
                }
                this.parseUnkown();
                continue;
            }
            if (n == 2) break;
        }
        if (way.isDeleted() && arrayList.size() > 0) {
            System.out.println(I18n.tr("Deleted way {0} contains nodes", way.getUniqueId()));
            arrayList = new ArrayList();
        }
        this.ways.put(wayData.getUniqueId(), arrayList);
    }

    private long parseWayNode(Way way) throws XMLStreamException {
        long l;
        if (this.parser.getAttributeValue(null, "ref") == null) {
            this.throwException(I18n.tr("Missing mandatory attribute ''{0}'' on <nd> of way {1}.", "ref", way.getUniqueId()));
        }
        if ((l = this.getLong("ref")) == 0L) {
            this.throwException(I18n.tr("Illegal value of attribute ''ref'' of element <nd>. Got {0}.", l));
        }
        this.jumpToEnd();
        return l;
    }

    private void parseRelation() throws XMLStreamException {
        RelationData relationData = new RelationData();
        this.readCommon(relationData);
        Relation relation = new Relation(relationData.getId(), relationData.getVersion());
        relation.setVisible(relationData.isVisible());
        relation.load(relationData);
        this.externalIdMap.put(relationData.getPrimitiveId(), relation);
        ArrayList<RelationMemberData> arrayList = new ArrayList<RelationMemberData>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("member")) {
                    arrayList.add(this.parseRelationMember(relation));
                    continue;
                }
                if (this.parser.getLocalName().equals("tag")) {
                    this.parseTag(relation);
                    continue;
                }
                this.parseUnkown();
                continue;
            }
            if (n == 2) break;
        }
        if (relation.isDeleted() && arrayList.size() > 0) {
            System.out.println(I18n.tr("Deleted relation {0} contains members", relation.getUniqueId()));
            arrayList = new ArrayList();
        }
        this.relations.put(relationData.getUniqueId(), arrayList);
    }

    private RelationMemberData parseRelationMember(Relation relation) throws XMLStreamException {
        RelationMemberData relationMemberData = new RelationMemberData();
        String string = this.parser.getAttributeValue(null, "ref");
        if (string == null) {
            this.throwException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", relation.getUniqueId()));
        }
        try {
            relationMemberData.id = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(relation.getUniqueId()), string));
        }
        string = this.parser.getAttributeValue(null, "type");
        if (string == null) {
            this.throwException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(relationMemberData.id), Long.toString(relation.getUniqueId())));
        }
        try {
            relationMemberData.type = OsmPrimitiveType.fromApiTypeName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(relationMemberData.id), Long.toString(relation.getUniqueId()), string));
        }
        relationMemberData.role = string = this.parser.getAttributeValue(null, "role");
        if (relationMemberData.id == 0L) {
            this.throwException(I18n.tr("Incomplete <member> specification with ref=0", new Object[0]));
        }
        this.jumpToEnd();
        return relationMemberData;
    }

    private void parseChangeset(Long l) throws XMLStreamException {
        long l2 = this.getLong("id");
        if (l2 == l) {
            this.uploadChangeset = new Changeset((int)this.getLong("id"));
            while (true) {
                int n;
                if ((n = this.parser.next()) == 1) {
                    if (this.parser.getLocalName().equals("tag")) {
                        this.parseTag(this.uploadChangeset);
                        continue;
                    }
                    this.parseUnkown();
                    continue;
                }
                if (n == 2) break;
            }
            return;
        }
        this.jumpToEnd(false);
    }

    private void parseTag(Tagged tagged) throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "k");
        String string2 = this.parser.getAttributeValue(null, "v");
        if (string == null || string2 == null) {
            this.throwException(I18n.tr("Missing key or value attribute in tag.", new Object[0]));
        }
        tagged.put(string.intern(), string2.intern());
        this.jumpToEnd();
    }

    private void parseUnkown(boolean bl) throws XMLStreamException {
        if (bl) {
            System.out.println(I18n.tr("Undefined element ''{0}'' found in input stream. Skipping.", this.parser.getLocalName()));
        }
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                this.parseUnkown(false);
                continue;
            }
            if (n == 2) break;
        }
    }

    private void parseUnkown() throws XMLStreamException {
        this.parseUnkown(true);
    }

    private void jumpToEnd(boolean bl) throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                this.parseUnkown(bl);
                continue;
            }
            if (n == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        this.jumpToEnd(true);
    }

    private User createUser(String string, String string2) throws XMLStreamException {
        if (string == null) {
            if (string2 == null) {
                return null;
            }
            return User.createLocalUser(string2);
        }
        try {
            long l = Long.parseLong(string);
            return User.createOsmUser(l, string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", string));
            return null;
        }
    }

    private void readCommon(PrimitiveData primitiveData) throws XMLStreamException {
        String string;
        String string2;
        primitiveData.setId(this.getLong("id"));
        if (primitiveData.getUniqueId() == 0L) {
            this.throwException(I18n.tr("Illegal object with ID=0.", new Object[0]));
        }
        if ((string2 = this.parser.getAttributeValue(null, "timestamp")) != null && string2.length() != 0) {
            primitiveData.setTimestamp(DateUtils.fromString(string2));
        }
        String string3 = this.parser.getAttributeValue(null, "user");
        String string4 = this.parser.getAttributeValue(null, "uid");
        primitiveData.setUser(this.createUser(string4, string3));
        String string5 = this.parser.getAttributeValue(null, "visible");
        if (string5 != null) {
            primitiveData.setVisible(Boolean.parseBoolean(string5));
        }
        String string6 = this.parser.getAttributeValue(null, "version");
        int n = 0;
        if (string6 != null) {
            try {
                n = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(primitiveData.getUniqueId()), string6));
            }
            if (this.ds.getVersion().equals("0.6")) {
                if (n <= 0 && primitiveData.getUniqueId() > 0L) {
                    this.throwException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(primitiveData.getUniqueId()), string6));
                } else if (n < 0 && primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 0, "0.6"));
                    n = 0;
                }
            } else if (this.ds.getVersion().equals("0.5")) {
                if (n <= 0 && primitiveData.getUniqueId() > 0L) {
                    System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 1, "0.5"));
                    n = 1;
                } else if (n < 0 && primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 0, "0.5"));
                    n = 0;
                }
            } else {
                this.throwException(I18n.tr("Unknown or unsupported API version. Got {0}.", this.ds.getVersion()));
            }
        } else if (primitiveData.getUniqueId() > 0L && this.ds.getVersion() != null && this.ds.getVersion().equals("0.6")) {
            this.throwException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(primitiveData.getUniqueId())));
        } else if (primitiveData.getUniqueId() > 0L && this.ds.getVersion() != null && this.ds.getVersion().equals("0.5")) {
            System.out.println(I18n.tr("WARNING: Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", primitiveData.getUniqueId(), n, 1, "0.5"));
            n = 1;
        } else if (primitiveData.getUniqueId() <= 0L && this.ds.getVersion() != null && this.ds.getVersion().equals("0.5")) {
            n = 0;
        }
        primitiveData.setVersion(n);
        String string7 = this.parser.getAttributeValue(null, "action");
        if (string7 != null) {
            if (string7.equals("delete")) {
                primitiveData.setDeleted(true);
                primitiveData.setModified(primitiveData.isVisible());
            } else if (string7.equals("modify")) {
                primitiveData.setModified(true);
            }
        }
        if ((string = this.parser.getAttributeValue(null, "changeset")) == null) {
            primitiveData.setChangesetId(0);
        } else {
            try {
                primitiveData.setChangesetId(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                if (primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", string, primitiveData.getUniqueId()));
                    primitiveData.setChangesetId(0);
                }
                this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", string));
            }
            if (primitiveData.getChangesetId() <= 0) {
                if (primitiveData.getUniqueId() <= 0L) {
                    System.out.println(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", string, primitiveData.getUniqueId()));
                    primitiveData.setChangesetId(0);
                } else {
                    this.throwException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", string));
                }
            }
        }
    }

    private long getLong(String string) throws XMLStreamException {
        String string2 = this.parser.getAttributeValue(null, string);
        if (string2 == null) {
            this.throwException(I18n.tr("Missing required attribute ''{0}''.", string));
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", string, string2));
            return 0L;
        }
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive osmPrimitive : this.externalIdMap.values()) {
            if (!(osmPrimitive instanceof Node)) continue;
            this.ds.addPrimitive(osmPrimitive);
        }
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Long l : this.ways.keySet()) {
            Way way = (Way)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.WAY));
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (long l2 : this.ways.get(l)) {
                Node node = (Node)this.externalIdMap.get(new SimplePrimitiveId(l2, OsmPrimitiveType.NODE));
                if (node == null) {
                    if (l2 <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", l, l2));
                    }
                    node = (Node)this.ds.getPrimitiveById(l2, OsmPrimitiveType.NODE);
                    if (node == null) {
                        node = new Node(l2);
                        this.ds.addPrimitive(node);
                    }
                }
                if (node.isDeleted()) {
                    System.out.println(I18n.tr("Deleted node {0} is part of way {1}", l2, way.getId()));
                    continue;
                }
                arrayList.add(node);
            }
            way.setNodes(arrayList);
            if (way.hasIncompleteNodes()) {
                System.out.println(I18n.tr("Way {0} with {1} nodes has incomplete nodes because at least one node was missing in the loaded data.", l, way.getNodesCount()));
            }
            this.ds.addPrimitive(way);
        }
    }

    private void processRelationsAfterParsing() throws IllegalDataException {
        Relation relation;
        for (Long l : this.relations.keySet()) {
            relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.RELATION));
            this.ds.addPrimitive(relation);
        }
        for (Long l : this.relations.keySet()) {
            relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.RELATION));
            ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
            for (RelationMemberData relationMemberData : this.relations.get(l)) {
                OsmPrimitive osmPrimitive = null;
                osmPrimitive = this.externalIdMap.get(new SimplePrimitiveId(relationMemberData.id, relationMemberData.type));
                if (osmPrimitive == null) {
                    if (relationMemberData.id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", l, relationMemberData.id));
                    }
                    osmPrimitive = this.ds.getPrimitiveById(relationMemberData.id, relationMemberData.type);
                    if (osmPrimitive == null) {
                        switch (relationMemberData.type) {
                            case NODE: {
                                osmPrimitive = new Node(relationMemberData.id);
                                break;
                            }
                            case WAY: {
                                osmPrimitive = new Way(relationMemberData.id);
                                break;
                            }
                            case RELATION: {
                                osmPrimitive = new Relation(relationMemberData.id);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        this.ds.addPrimitive(osmPrimitive);
                        this.externalIdMap.put(new SimplePrimitiveId(relationMemberData.id, relationMemberData.type), osmPrimitive);
                    }
                }
                if (osmPrimitive.isDeleted()) {
                    System.out.println(I18n.tr("Deleted member {0} is used by relation {1}", osmPrimitive.getId(), relation.getId()));
                    continue;
                }
                arrayList.add(new RelationMember(relationMemberData.role, osmPrimitive));
            }
            relation.setMembers(arrayList);
        }
    }

    private void processChangesetAfterParsing() {
        if (this.uploadChangeset != null) {
            for (Map.Entry<String, String> entry : this.uploadChangeset.getKeys().entrySet()) {
                this.ds.addChangeSetTag(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet parseDataSet(InputStream inputStream, ProgressMonitor progressMonitor) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        CheckParameterUtil.ensureParameterNotNull(inputStream, "source");
        OsmReader osmReader = new OsmReader();
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", 2));
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing OSM data...", new Object[0]));
            UTFInputStreamReader uTFInputStreamReader = UTFInputStreamReader.create(inputStream, "UTF-8");
            XMLStreamReader xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(uTFInputStreamReader);
            osmReader.setParser(xMLStreamReader);
            osmReader.parse();
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Preparing data set...", new Object[0]));
            osmReader.ds.beginUpdate();
            try {
                osmReader.processNodesAfterParsing();
                osmReader.processWaysAfterParsing();
                osmReader.processRelationsAfterParsing();
                osmReader.processChangesetAfterParsing();
            }
            finally {
                osmReader.ds.endUpdate();
            }
            progressMonitor.worked(1);
            DataSet dataSet = osmReader.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException illegalDataException) {
            throw illegalDataException;
        }
        catch (OsmParsingException osmParsingException) {
            throw new IllegalDataException(osmParsingException.getMessage(), osmParsingException);
        }
        catch (XMLStreamException xMLStreamException) {
            String string = xMLStreamException.getMessage();
            Pattern pattern = Pattern.compile("Message: (.+)");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                string = matcher.group(1);
            }
            if (xMLStreamException.getLocation() != null) {
                throw new IllegalDataException(I18n.tr("Line {0} column {1}: ", xMLStreamException.getLocation().getLineNumber(), xMLStreamException.getLocation().getColumnNumber()) + string, xMLStreamException);
            }
            throw new IllegalDataException(string, xMLStreamException);
        }
        catch (Exception exception) {
            throw new IllegalDataException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static class OsmParsingException
    extends XMLStreamException {
        public OsmParsingException() {
        }

        public OsmParsingException(String string) {
            super(string);
        }

        public OsmParsingException(String string, Location location) {
            super(string);
            this.location = location;
        }

        public OsmParsingException(String string, Location location, Throwable throwable) {
            super(string, throwable);
            this.location = location;
        }

        public OsmParsingException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public OsmParsingException(Throwable throwable) {
            super(throwable);
        }

        public String getMessage() {
            String string = super.getMessage();
            if (string == null) {
                string = this.getClass().getName();
            }
            if (this.getLocation() == null) {
                return string;
            }
            string = string + " " + I18n.tr("(at line {0}, column {1})", this.getLocation().getLineNumber(), this.getLocation().getColumnNumber());
            return string;
        }
    }

    private static class RelationMemberData {
        public OsmPrimitiveType type;
        public long id;
        public String role;

        private RelationMemberData() {
        }
    }
}

