/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GpxReader {
    public GpxData data;
    private InputSource inputSource;

    public GpxReader(InputStream inputStream) throws IOException {
        this.inputSource = new InputSource(UTFInputStreamReader.create(inputStream, "UTF-8"));
    }

    public boolean parse(boolean bl) throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.newSAXParser().parse(this.inputSource, (DefaultHandler)parser);
            return true;
        }
        catch (SAXException sAXException) {
            if (bl) {
                parser.tryToFinish();
                if (parser.currentData.isEmpty()) {
                    throw sAXException;
                }
                return false;
            }
            throw sAXException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SAXException(parserConfigurationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        private GpxData currentData;
        private Collection<Collection<WayPoint>> currentTrack;
        private Map<String, Object> currentTrackAttr;
        private Collection<WayPoint> currentTrackSeg;
        private GpxRoute currentRoute;
        private WayPoint currentWayPoint;
        private State currentState = State.init;
        private GpxLink currentLink;
        private Stack<State> states;
        private final Stack<String> elements = new Stack();
        private StringBuffer accumulator = new StringBuffer();
        private boolean nokiaSportsTrackerBug = false;

        private Parser() {
        }

        @Override
        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.states = new Stack();
            this.currentData = new GpxData();
        }

        private double parseCoord(String string) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.NaN;
            }
        }

        private LatLon parseLatLon(Attributes attributes) {
            return new LatLon(this.parseCoord(attributes.getValue("lat")), this.parseCoord(attributes.getValue("lon")));
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.elements.push(string2);
            switch (this.currentState) {
                case init: {
                    if (string2.equals("metadata")) {
                        this.states.push(this.currentState);
                        this.currentState = State.metadata;
                        break;
                    }
                    if (string2.equals("wpt")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (string2.equals("rte")) {
                        this.states.push(this.currentState);
                        this.currentState = State.rte;
                        this.currentRoute = new GpxRoute();
                        break;
                    }
                    if (string2.equals("trk")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trk;
                        this.currentTrack = new ArrayList<Collection<WayPoint>>();
                        this.currentTrackAttr = new HashMap<String, Object>();
                        break;
                    }
                    if (string2.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        break;
                    }
                    if (!string2.equals("gpx") || attributes.getValue("creator") == null || !attributes.getValue("creator").startsWith("Nokia Sports Tracker")) break;
                    this.nokiaSportsTrackerBug = true;
                    break;
                }
                case author: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("email")) break;
                    this.currentData.attr.put("meta.author.email", attributes.getValue("id") + "@" + attributes.getValue("domain"));
                    break;
                }
                case trk: {
                    if (string2.equals("trkseg")) {
                        this.states.push(this.currentState);
                        this.currentState = State.trkseg;
                        this.currentTrackSeg = new ArrayList<WayPoint>();
                        break;
                    }
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
                case metadata: {
                    if (string2.equals("author")) {
                        this.states.push(this.currentState);
                        this.currentState = State.author;
                        break;
                    }
                    if (string2.equals("extensions")) {
                        this.states.push(this.currentState);
                        this.currentState = State.ext;
                        break;
                    }
                    if (string2.equals("copyright")) {
                        this.states.push(this.currentState);
                        this.currentState = State.copyright;
                        this.currentData.attr.put("meta.copyright.author", attributes.getValue("author"));
                        break;
                    }
                    if (!string2.equals("link")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.link;
                    this.currentLink = new GpxLink(attributes.getValue("href"));
                    break;
                }
                case trkseg: {
                    if (!string2.equals("trkpt")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.wpt;
                    this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                    break;
                }
                case wpt: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
                case rte: {
                    if (string2.equals("link")) {
                        this.states.push(this.currentState);
                        this.currentState = State.link;
                        this.currentLink = new GpxLink(attributes.getValue("href"));
                        break;
                    }
                    if (string2.equals("rtept")) {
                        this.states.push(this.currentState);
                        this.currentState = State.wpt;
                        this.currentWayPoint = new WayPoint(this.parseLatLon(attributes));
                        break;
                    }
                    if (!string2.equals("extensions")) break;
                    this.states.push(this.currentState);
                    this.currentState = State.ext;
                    break;
                }
            }
            this.accumulator.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.nokiaSportsTrackerBug) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != '\u0001') continue;
                    cArray[i] = 32;
                }
                this.nokiaSportsTrackerBug = false;
            }
            this.accumulator.append(cArray, n, n2);
        }

        private Map<String, Object> getAttr() {
            switch (this.currentState) {
                case rte: {
                    return this.currentRoute.attr;
                }
                case metadata: {
                    return this.currentData.attr;
                }
                case wpt: {
                    return this.currentWayPoint.attr;
                }
                case trk: {
                    return this.currentTrackAttr;
                }
            }
            return null;
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.elements.pop();
            switch (this.currentState) {
                case metadata: {
                    if (string2.equals("name")) {
                        this.currentData.attr.put("meta.name", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("desc")) {
                        this.currentData.attr.put("meta.desc", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("time")) {
                        this.currentData.attr.put("meta.time", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("keywords")) {
                        this.currentData.attr.put("meta.keywords", this.accumulator.toString());
                        break;
                    }
                    if (!string2.equals("metadata")) break;
                    this.currentState = this.states.pop();
                    break;
                }
                case author: {
                    if (string2.equals("author")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (string2.equals("name")) {
                        this.currentData.attr.put("meta.author.name", this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("email") || !string2.equals("link")) break;
                    this.currentData.attr.put("meta.author.link", this.currentLink);
                    break;
                }
                case copyright: {
                    if (string2.equals("copyright")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (string2.equals("year")) {
                        this.currentData.attr.put("meta.copyright.year", this.accumulator.toString());
                        break;
                    }
                    if (!string2.equals("license")) break;
                    this.currentData.attr.put("meta.copyright.license", this.accumulator.toString());
                    break;
                }
                case link: {
                    if (string2.equals("text")) {
                        this.currentLink.text = this.accumulator.toString();
                    } else if (string2.equals("type")) {
                        this.currentLink.type = this.accumulator.toString();
                    } else if (string2.equals("link")) {
                        if (this.currentLink.uri == null && this.accumulator != null && this.accumulator.toString().length() != 0) {
                            this.currentLink = new GpxLink(this.accumulator.toString());
                        }
                        this.currentState = this.states.pop();
                    }
                    if (this.currentState == State.author) {
                        this.currentData.attr.put("meta.author.link", this.currentLink);
                        break;
                    }
                    if (this.currentState == State.link) break;
                    Map<String, Object> map = this.getAttr();
                    if (!map.containsKey("meta.links")) {
                        map.put("meta.links", new LinkedList());
                    }
                    ((Collection)map.get("meta.links")).add(this.currentLink);
                    break;
                }
                case wpt: {
                    if (string2.equals("ele") || string2.equals("magvar") || string2.equals("name") || string2.equals("geoidheight") || string2.equals("type") || string2.equals("sym")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("hdop")) {
                        try {
                            this.currentWayPoint.attr.put(string2, Float.valueOf(Float.parseFloat(this.accumulator.toString())));
                        }
                        catch (Exception exception) {
                            this.currentWayPoint.attr.put(string2, new Float(0.0f));
                        }
                        break;
                    }
                    if (string2.equals("time")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (string2.equals("cmt") || string2.equals("desc")) {
                        this.currentWayPoint.attr.put(string2, this.accumulator.toString());
                        this.currentWayPoint.setTime();
                        break;
                    }
                    if (string2.equals("rtept")) {
                        this.currentState = this.states.pop();
                        this.currentRoute.routePoints.add(this.currentWayPoint);
                        break;
                    }
                    if (string2.equals("trkpt")) {
                        this.currentState = this.states.pop();
                        this.currentTrackSeg.add(this.currentWayPoint);
                        break;
                    }
                    if (!string2.equals("wpt")) break;
                    this.currentState = this.states.pop();
                    this.currentData.waypoints.add(this.currentWayPoint);
                    break;
                }
                case trkseg: {
                    if (!string2.equals("trkseg")) break;
                    this.currentState = this.states.pop();
                    this.currentTrack.add(this.currentTrackSeg);
                    break;
                }
                case trk: {
                    if (string2.equals("trk")) {
                        this.currentState = this.states.pop();
                        this.currentData.tracks.add(new ImmutableGpxTrack(this.currentTrack, this.currentTrackAttr));
                        break;
                    }
                    if (!string2.equals("name") && !string2.equals("cmt") && !string2.equals("desc") && !string2.equals("src") && !string2.equals("type") && !string2.equals("number") && !string2.equals("url")) break;
                    this.currentTrackAttr.put(string2, this.accumulator.toString());
                    break;
                }
                case ext: {
                    if (!string2.equals("extensions")) break;
                    this.currentState = this.states.pop();
                    break;
                }
                default: {
                    if (string2.equals("wpt")) {
                        this.currentState = this.states.pop();
                        break;
                    }
                    if (!string2.equals("rte")) break;
                    this.currentState = this.states.pop();
                    this.currentData.routes.add(this.currentRoute);
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (!this.states.empty()) {
                throw new SAXException(I18n.tr("Parse error: invalid document structure for GPX document.", new Object[0]));
            }
            GpxReader.this.data = this.currentData;
        }

        public void tryToFinish() throws SAXException {
            ArrayList<String> arrayList = new ArrayList<String>(this.elements);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.endElement(null, (String)arrayList.get(i), null);
            }
            this.endDocument();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        init,
        metadata,
        wpt,
        rte,
        trk,
        ext,
        author,
        link,
        trkseg,
        copyright;

    }
}

