/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.VersionTableColumnModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VersionTable
extends JTable
implements Observer {
    private VersionTablePopupMenu popupMenu;

    protected void build() {
        this.setSelectionMode(0);
        this.addMouseListener(new MouseHandler());
        this.getSelectionModel().addListSelectionListener(new SelectionHandler());
        this.popupMenu = new VersionTablePopupMenu();
        this.addMouseListener(new PopupMenuTrigger());
    }

    public VersionTable(HistoryBrowserModel historyBrowserModel) {
        super(historyBrowserModel.getVersionTableModel(), new VersionTableColumnModel());
        historyBrowserModel.addObserver(this);
        this.build();
    }

    protected void handleSelectReferencePointInTime(int n) {
        this.getVersionTableModel().setReferencePointInTime(n);
    }

    protected void handleSelectCurrentPointInTime(int n) {
        this.getVersionTableModel().setCurrentPointInTime(n);
    }

    protected HistoryBrowserModel.VersionTableModel getVersionTableModel() {
        return (HistoryBrowserModel.VersionTableModel)this.getModel();
    }

    public void update(Observable observable, Object object) {
        this.repaint();
    }

    protected void showPopupMenu(MouseEvent mouseEvent) {
        HistoryBrowserModel.VersionTableModel versionTableModel = this.getVersionTableModel();
        int n = this.getSelectedRow();
        if (n == -1) {
            n = this.rowAtPoint(mouseEvent.getPoint());
        }
        if (!versionTableModel.isLatest(n)) {
            HistoryOsmPrimitive historyOsmPrimitive = versionTableModel.getPrimitive(n);
            this.popupMenu.prepare(historyOsmPrimitive);
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void updateSelection() {
        int n = this.getVersionTableModel().getRowCount() - 1;
        this.setRowSelectionInterval(n, n);
    }

    static class VersionTablePopupMenu
    extends JPopupMenu {
        private ChangesetInfoAction changesetInfoAction;

        protected void build() {
            this.changesetInfoAction = new ChangesetInfoAction();
            this.add(this.changesetInfoAction);
        }

        public VersionTablePopupMenu() {
            this.build();
        }

        public void prepare(HistoryOsmPrimitive historyOsmPrimitive) {
            this.changesetInfoAction.prepare(historyOsmPrimitive);
            this.invalidate();
        }
    }

    static class ChangesetInfoAction
    extends AbstractInfoAction {
        private HistoryOsmPrimitive primitive;

        public ChangesetInfoAction() {
            super(true);
            this.putValue("Name", I18n.tr("Changeset info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with information about the changeset", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("about"));
        }

        protected String createInfoUrl(Object object) {
            HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)object;
            return ChangesetInfoAction.getBaseBrowseUrl() + "/changeset/" + historyOsmPrimitive.getChangesetId();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            String string = this.createInfoUrl(this.primitive);
            this.launchBrowser(string);
        }

        public void prepare(HistoryOsmPrimitive historyOsmPrimitive) {
            this.putValue("Name", I18n.tr("Show changeset {0}", historyOsmPrimitive.getChangesetId()));
            this.primitive = historyOsmPrimitive;
        }
    }

    class PopupMenuTrigger
    extends MouseAdapter {
        PopupMenuTrigger() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                VersionTable.this.showPopupMenu(mouseEvent);
            }
        }
    }

    class SelectionHandler
    implements ListSelectionListener {
        SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (defaultListSelectionModel.getMinSelectionIndex() >= 0) {
                VersionTable.this.handleSelectCurrentPointInTime(defaultListSelectionModel.getMinSelectionIndex());
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        protected void handleDoubleClick(MouseEvent mouseEvent) {
            int n = VersionTable.this.rowAtPoint(mouseEvent.getPoint());
            VersionTable.this.handleSelectReferencePointInTime(n);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getClickCount()) {
                case 2: {
                    this.handleDoubleClick(mouseEvent);
                }
            }
        }
    }
}

