/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class TurnrestrictionTest
extends Test {
    protected static final int NO_VIA = 1801;
    protected static final int NO_FROM = 1802;
    protected static final int NO_TO = 1803;
    protected static final int MORE_VIA = 1804;
    protected static final int MORE_FROM = 1805;
    protected static final int MORE_TO = 1806;
    protected static final int UNKNOWN_ROLE = 1807;
    protected static final int UNKNOWN_TYPE = 1808;
    protected static final int FROM_VIA_NODE = 1809;
    protected static final int TO_VIA_NODE = 1810;
    protected static final int FROM_VIA_WAY = 1811;
    protected static final int TO_VIA_WAY = 1812;
    protected static final int MIX_VIA = 1813;
    protected static final int UNCONNECTED_VIA = 1814;

    public TurnrestrictionTest() {
        super(I18n.tr("Turnrestriction", new Object[0]), I18n.tr("This test checks if turnrestrictions are valid", new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    public void visit(Relation relation) {
        OsmPrimitive osmPrimitive;
        Object object;
        if (!"restriction".equals(relation.get("type"))) {
            return;
        }
        OsmPrimitive osmPrimitive2 = null;
        OsmPrimitive osmPrimitive3 = null;
        ArrayList<Way> arrayList = new ArrayList<Way>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (RelationMember primitiveId : relation.getMembers()) {
            if (primitiveId.getMember().isIncomplete()) {
                return;
            }
            object = new ArrayList<OsmPrimitive>();
            ((ArrayList)object).add(relation);
            ((ArrayList)object).add(primitiveId.getMember());
            if (primitiveId.isWay()) {
                osmPrimitive = primitiveId.getWay();
                if (osmPrimitive.getNodesCount() < 2) continue;
                if ("from".equals(primitiveId.getRole())) {
                    if (osmPrimitive2 != null) {
                        bl = true;
                        continue;
                    }
                    osmPrimitive2 = osmPrimitive;
                    continue;
                }
                if ("to".equals(primitiveId.getRole())) {
                    if (osmPrimitive3 != null) {
                        bl2 = true;
                        continue;
                    }
                    osmPrimitive3 = osmPrimitive;
                    continue;
                }
                if ("via".equals(primitiveId.getRole())) {
                    if (!arrayList.isEmpty() && arrayList.get(0) instanceof Node) {
                        bl4 = true;
                        continue;
                    }
                    arrayList.add((Way)osmPrimitive);
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown role", new Object[0]), 1807, (Collection<? extends OsmPrimitive>)object, Collections.singletonList(primitiveId)));
                continue;
            }
            if (primitiveId.isNode()) {
                osmPrimitive = primitiveId.getNode();
                if ("via".equals(primitiveId.getRole())) {
                    if (!arrayList.isEmpty()) {
                        if (arrayList.get(0) instanceof Node) {
                            bl3 = true;
                            continue;
                        }
                        bl4 = true;
                        continue;
                    }
                    arrayList.add((Way)osmPrimitive);
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown role", new Object[0]), 1807, (Collection<? extends OsmPrimitive>)object, (Collection<?>)Collections.singletonList(primitiveId)));
                continue;
            }
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown member type", new Object[0]), 1808, (Collection<? extends OsmPrimitive>)object, (Collection<?>)Collections.singletonList(primitiveId)));
        }
        if (bl) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"from\" way found", new Object[0]), 1805, relation));
        }
        if (bl2) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"to\" way found", new Object[0]), 1806, relation));
        }
        if (bl3) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"via\" node found", new Object[0]), 1804, relation));
        }
        if (bl4) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Cannot mix node and way for role \"via\"", new Object[0]), 1813, relation));
        }
        if (osmPrimitive2 == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"from\" way found", new Object[0]), 1802, relation));
            return;
        }
        if (osmPrimitive3 == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"to\" way found", new Object[0]), 1803, relation));
            return;
        }
        if (arrayList.isEmpty()) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"via\" node or way found", new Object[0]), 1801, relation));
            return;
        }
        if (arrayList.get(0) instanceof Node) {
            Node node = (Node)arrayList.get(0);
            Way i = new Way();
            i.addNode(node);
            this.checkIfConnected((Way)osmPrimitive2, i, I18n.tr("The \"from\" way does not start or end at a \"via\" node", new Object[0]), 1809);
            this.checkIfConnected(i, (Way)osmPrimitive3, I18n.tr("The \"to\" way does not start or end at a \"via\" node", new Object[0]), 1810);
        } else {
            this.checkIfConnected((Way)osmPrimitive2, (Way)arrayList.get(0), I18n.tr("The \"from\" and the first \"via\" way are not connected.", new Object[0]), 1811);
            if (arrayList.size() > 1) {
                void var10_13;
                boolean bl5 = true;
                while (var10_13 < arrayList.size()) {
                    object = (Way)arrayList.get((int)(var10_13 - true));
                    osmPrimitive = (Way)arrayList.get((int)var10_13);
                    this.checkIfConnected((Way)object, (Way)osmPrimitive, I18n.tr("The \"via\" ways are not connected.", new Object[0]), 1814);
                    ++var10_13;
                }
            }
            this.checkIfConnected((Way)arrayList.get(arrayList.size() - 1), (Way)osmPrimitive3, I18n.tr("The last \"via\" and the \"to\" way are not connected.", new Object[0]), 1812);
        }
    }

    private void checkIfConnected(Way way, Way way2, String string, int n) {
        boolean bl;
        Node node;
        int n2 = TurnrestrictionTest.isOneway(way);
        int n3 = TurnrestrictionTest.isOneway(way2);
        Node node2 = n2 != -1 ? way.lastNode() : way.firstNode();
        Node node3 = node = n3 != -1 ? way2.firstNode() : way2.lastNode();
        if (n2 != 0 && n3 != 0) {
            bl = node2.equals(node);
        } else if (n2 != 0) {
            bl = way2.isFirstLastNode(node2);
        } else if (n3 != 0) {
            bl = way.isFirstLastNode(node);
        } else {
            boolean bl2 = bl = way2.isFirstLastNode(way.firstNode()) || way2.isFirstLastNode(way.lastNode());
        }
        if (!bl) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, string, n, Arrays.asList(way, way2)));
        }
    }

    private static int isOneway(Way way) {
        String string = way.get("oneway");
        if (string != null) {
            if ("-1".equals(string)) {
                return -1;
            }
            Boolean bl = OsmUtils.getOsmBoolean(string);
            if (bl != null && bl.booleanValue()) {
                return 1;
            }
        }
        return 0;
    }
}

