/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;

public class ThreeParameterDatum
extends AbstractDatum {
    protected double dx;
    protected double dy;
    protected double dz;

    public ThreeParameterDatum(String string, String string2, Ellipsoid ellipsoid, double d, double d2, double d3) {
        super(string, string2, ellipsoid);
        this.dx = d;
        this.dy = d2;
        this.dz = d3;
    }

    public LatLon toWGS84(LatLon latLon) {
        double[] dArray = this.ellps.latLon2Cart(latLon);
        dArray[0] = dArray[0] + this.dx;
        dArray[1] = dArray[1] + this.dy;
        dArray[2] = dArray[2] + this.dz;
        return Ellipsoid.WGS84.cart2LatLon(dArray);
    }

    public LatLon fromWGS84(LatLon latLon) {
        double[] dArray = Ellipsoid.WGS84.latLon2Cart(latLon);
        dArray[0] = dArray[0] - this.dx;
        dArray[1] = dArray[1] - this.dy;
        dArray[2] = dArray[2] - this.dz;
        return this.ellps.cart2LatLon(dArray);
    }
}

