/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FillElement;
import com.kitfox.svg.Marker;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public abstract class ShapeElement
extends RenderableElement {
    protected float strokeWidthScalar = 1.0f;

    public abstract void render(Graphics2D var1) throws SVGException;

    void pick(Point2D point2D, boolean bl, List list) throws SVGException {
        StyleAttribute styleAttribute = new StyleAttribute();
        if ((bl ? this.getBoundingBox() : this.getShape()).contains(point2D)) {
            list.add(this.getPath(null));
        }
    }

    void pick(Rectangle2D rectangle2D, AffineTransform affineTransform, boolean bl, List list) throws SVGException {
        StyleAttribute styleAttribute = new StyleAttribute();
        if (affineTransform.createTransformedShape(bl ? this.getBoundingBox() : this.getShape()).intersects(rectangle2D)) {
            list.add(this.getPath(null));
        }
    }

    protected void renderShape(Graphics2D graphics2D, Shape shape) throws SVGException {
        Object object;
        Object object2;
        Serializable serializable;
        Serializable serializable2;
        Object object3;
        Object object4;
        Object object5;
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getStyle(styleAttribute.setName("visibility")) && !styleAttribute.getStringValue().equals("visible")) {
            return;
        }
        if (this.getStyle(styleAttribute.setName("display")) && styleAttribute.getStringValue().equals("none")) {
            return;
        }
        Paint paint = Color.black;
        if (this.getStyle(styleAttribute.setName("fill"))) {
            if (styleAttribute.getStringValue().equals("none")) {
                paint = null;
            } else {
                URI uRI;
                paint = styleAttribute.getColorValue();
                if (paint == null && (uRI = styleAttribute.getURIValue(this.getXMLBase())) != null) {
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    object5 = graphics2D.getTransform();
                    object4 = this.diagram.getUniverse().getElement(uRI);
                    paint = ((FillElement)object4).getPaint(rectangle2D, (AffineTransform)object5);
                }
            }
        }
        float f = 1.0f;
        if (this.getStyle(styleAttribute.setName("opacity"))) {
            f = styleAttribute.getRatioValue();
        }
        float f2 = f;
        if (this.getStyle(styleAttribute.setName("fill-opacity"))) {
            f2 *= styleAttribute.getRatioValue();
        }
        object5 = null;
        if (this.getStyle(styleAttribute.setName("stroke"))) {
            if (styleAttribute.getStringValue().equals("none")) {
                object5 = null;
            } else {
                object5 = styleAttribute.getColorValue();
                if (object5 == null && (object4 = styleAttribute.getURIValue(this.getXMLBase())) != null) {
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    AffineTransform affineTransform = graphics2D.getTransform();
                    object3 = this.diagram.getUniverse().getElement((URI)object4);
                    object5 = ((FillElement)object3).getPaint(rectangle2D, affineTransform);
                }
            }
        }
        object4 = null;
        if (this.getStyle(styleAttribute.setName("stroke-dasharray")) && ((Object)(object4 = (Object)styleAttribute.getFloatList())).length == 0) {
            object4 = null;
        }
        float f3 = 0.0f;
        if (this.getStyle(styleAttribute.setName("stroke-dashoffset"))) {
            f3 = styleAttribute.getFloatValueWithUnits();
        }
        int n = 0;
        if (this.getStyle(styleAttribute.setName("stroke-linecap"))) {
            object3 = styleAttribute.getStringValue();
            if (((String)object3).equals("round")) {
                n = 1;
            } else if (((String)object3).equals("square")) {
                n = 2;
            }
        }
        int n2 = 0;
        if (this.getStyle(styleAttribute.setName("stroke-linejoin"))) {
            String string = styleAttribute.getStringValue();
            if (string.equals("round")) {
                n2 = 1;
            } else if (string.equals("bevel")) {
                n2 = 2;
            }
        }
        float f4 = 4.0f;
        if (this.getStyle(styleAttribute.setName("stroke-miterlimit"))) {
            f4 = Math.max(styleAttribute.getFloatValueWithUnits(), 1.0f);
        }
        float f5 = f;
        if (this.getStyle(styleAttribute.setName("stroke-opacity"))) {
            f5 *= styleAttribute.getRatioValue();
        }
        float f6 = 1.0f;
        if (this.getStyle(styleAttribute.setName("stroke-width"))) {
            f6 = styleAttribute.getFloatValueWithUnits();
        }
        f6 *= this.strokeWidthScalar;
        Marker marker = null;
        if (this.getStyle(styleAttribute.setName("marker-start")) && !styleAttribute.getStringValue().equals("none")) {
            serializable2 = styleAttribute.getURIValue(this.getXMLBase());
            marker = (Marker)this.diagram.getUniverse().getElement((URI)serializable2);
        }
        serializable2 = null;
        if (this.getStyle(styleAttribute.setName("marker-mid")) && !styleAttribute.getStringValue().equals("none")) {
            serializable = styleAttribute.getURIValue(this.getXMLBase());
            serializable2 = (Marker)this.diagram.getUniverse().getElement((URI)serializable);
        }
        serializable = null;
        if (this.getStyle(styleAttribute.setName("marker-end")) && !styleAttribute.getStringValue().equals("none")) {
            object2 = styleAttribute.getURIValue(this.getXMLBase());
            serializable = (Marker)this.diagram.getUniverse().getElement((URI)object2);
        }
        if (paint != null && f2 != 0.0f && !(f2 <= 0.0f)) {
            if (f2 < 1.0f) {
                object2 = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                graphics2D.setPaint(paint);
                graphics2D.fill(shape);
                graphics2D.setComposite((Composite)object2);
            } else {
                graphics2D.setPaint(paint);
                graphics2D.fill(shape);
            }
        }
        if (object5 != null && f5 != 0.0f) {
            object2 = object4 == null ? new BasicStroke(f6, n, n2, f4) : new BasicStroke(f6, n, n2, f4, (float[])object4, f3);
            object = ((BasicStroke)object2).createStrokedShape(shape);
            if (!(f5 <= 0.0f)) {
                if (f5 < 1.0f) {
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f5));
                    graphics2D.setPaint((Paint)object5);
                    graphics2D.fill((Shape)object);
                    graphics2D.setComposite(composite);
                } else {
                    graphics2D.setPaint((Paint)object5);
                    graphics2D.fill((Shape)object);
                }
            }
        }
        if (marker != null || serializable2 != null || serializable != null) {
            object2 = new Marker.MarkerLayout();
            ((Marker.MarkerLayout)object2).layout(shape);
            object = ((Marker.MarkerLayout)object2).getMarkerList();
            block5: for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                Marker.MarkerPos markerPos = (Marker.MarkerPos)((ArrayList)object).get(i);
                switch (markerPos.type) {
                    case 0: {
                        if (marker == null) continue block5;
                        marker.render(graphics2D, markerPos, f6);
                        continue block5;
                    }
                    case 1: {
                        if (serializable2 == null) continue block5;
                        ((Marker)serializable2).render(graphics2D, markerPos, f6);
                        continue block5;
                    }
                    case 2: {
                        if (serializable == null) continue block5;
                        ((Marker)serializable).render(graphics2D, markerPos, f6);
                    }
                }
            }
        }
    }

    public abstract Shape getShape();

    protected Rectangle2D includeStrokeInBounds(Rectangle2D rectangle2D) throws SVGException {
        StyleAttribute styleAttribute = new StyleAttribute();
        if (!this.getStyle(styleAttribute.setName("stroke"))) {
            return rectangle2D;
        }
        double d = 1.0;
        if (this.getStyle(styleAttribute.setName("stroke-width"))) {
            d = styleAttribute.getDoubleValue();
        }
        rectangle2D.setRect(rectangle2D.getX() - d / 2.0, rectangle2D.getY() - d / 2.0, rectangle2D.getWidth() + d, rectangle2D.getHeight() + d);
        return rectangle2D;
    }
}

