/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMap<A, B> {
    private final Map<A, LinkedHashSet<B>> map;

    public MultiMap() {
        this.map = new HashMap<A, LinkedHashSet<B>>();
    }

    public MultiMap(int n) {
        this.map = new HashMap<A, LinkedHashSet<B>>(n);
    }

    public void put(A a, B b) {
        LinkedHashSet<Object> linkedHashSet = this.map.get(a);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
            this.map.put(a, linkedHashSet);
        }
        linkedHashSet.add(b);
    }

    public void putVoid(A a) {
        if (this.map.containsKey(a)) {
            return;
        }
        this.map.put(a, new LinkedHashSet());
    }

    public Set<A> keySet() {
        return this.map.keySet();
    }

    public Set<B> get(A a) {
        return this.map.get(a);
    }

    public LinkedHashSet<B> getValues(A a) {
        if (!this.map.containsKey(a)) {
            return new LinkedHashSet();
        }
        return this.map.get(a);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(A a) {
        return this.map.containsKey(a);
    }

    public boolean contains(A a, B b) {
        Set<B> set = this.get(a);
        return set == null ? false : set.contains(b);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<Map.Entry<A, LinkedHashSet<B>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public Collection<LinkedHashSet<B>> values() {
        return this.map.values();
    }
}

