/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

class ImageResource {
    private HashMap<Dimension, ImageWrapper> imgCache = new HashMap();
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);

    public ImageResource(Image image, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(image);
        this.imgCache.put(DEFAULT_DIMENSION, new ImageWrapper(image, bl));
    }

    public ImageResource(SVGDiagram sVGDiagram) {
        CheckParameterUtil.ensureParameterNotNull(sVGDiagram);
        this.svg = sVGDiagram;
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION, false);
    }

    public ImageIcon getImageIcon(Dimension dimension, boolean bl) {
        ImageWrapper imageWrapper = this.imgCache.get(dimension);
        if (imageWrapper != null) {
            if (bl && !imageWrapper.sanitized) {
                imageWrapper.img = ImageProvider.sanitize(imageWrapper.img);
                imageWrapper.sanitized = true;
            }
            return new ImageIcon(imageWrapper.img);
        }
        if (this.svg != null) {
            Image image = ImageProvider.createImageFromSvg(this.svg, dimension);
            this.imgCache.put(dimension, new ImageWrapper(image, true));
            return new ImageIcon(image);
        }
        ImageWrapper imageWrapper2 = this.imgCache.get(DEFAULT_DIMENSION);
        if (imageWrapper2 == null) {
            throw new AssertionError();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        ImageIcon imageIcon = new ImageIcon(imageWrapper2.img);
        if (n == -1) {
            n = imageIcon.getIconWidth() * n2 / imageIcon.getIconHeight();
        } else if (n2 == -1) {
            n2 = imageIcon.getIconHeight() * n / imageIcon.getIconWidth();
        }
        Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
        if (bl) {
            image = ImageProvider.sanitize(image);
        }
        this.imgCache.put(dimension, new ImageWrapper(image, bl));
        return new ImageIcon(image);
    }

    private static class ImageWrapper {
        Image img;
        boolean sanitized;

        public ImageWrapper(Image image, boolean bl) {
            CheckParameterUtil.ensureParameterNotNull(image);
            this.img = image;
            this.sanitized = bl;
        }
    }
}

