/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openstreetmap.josm.io.remotecontrol.handler.AddNodeHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImageryHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.ImportHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.LoadAndZoomHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.io.remotecontrol.handler.VersionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestProcessor
extends Thread {
    public static final String PROTOCOLVERSION = "{\"protocolversion\": {\"major\": 1, \"minor\": 2}, \"application\": \"JOSM RemoteControl\"}";
    private Socket request;
    private static HashMap<String, Class<? extends RequestHandler>> handlers = new HashMap();

    public RequestProcessor(Socket socket) {
        super("RemoteControl request processor");
        this.setDaemon(true);
        this.request = socket;
    }

    public static void processRequest(Socket socket) {
        RequestProcessor requestProcessor = new RequestProcessor(socket);
        requestProcessor.start();
    }

    static void addRequestHandlerClass(String string, Class<? extends RequestHandler> clazz) {
        RequestProcessor.addRequestHandlerClass(string, clazz, false);
    }

    private static void addRequestHandlerClass(String string, Class<? extends RequestHandler> clazz, boolean bl) {
        String string2;
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (handlers.get(string2 = "/" + string) != null) {
            System.out.println("RemoteControl: ignoring duplicate command " + string + " with handler " + clazz.getName());
        } else {
            if (!bl) {
                System.out.println("RemoteControl: adding command \"" + string + "\" (handled by " + clazz.getSimpleName() + ")");
            }
            handlers.put(string2, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            int n;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.request.getOutputStream());
            outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(this.request.getInputStream()), "ASCII");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringBuffer.length() < 1024 && (n = ((Reader)inputStreamReader).read()) != 13 && n != 10) {
                stringBuffer.append((char)n);
            }
            System.out.println("RemoteControl received: " + stringBuffer);
            String string = stringBuffer.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError(outputStreamWriter);
                return;
            }
            String string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                this.sendError(outputStreamWriter);
                return;
            }
            String string3 = stringTokenizer.nextToken();
            if (!string2.equals("GET")) {
                this.sendNotImplemented(outputStreamWriter);
                return;
            }
            String string4 = null;
            int n2 = string3.indexOf(63);
            string4 = n2 < 0 ? string3 : string3.substring(0, n2);
            Class<? extends RequestHandler> clazz = handlers.get(string4);
            if (clazz == null) {
                this.sendBadRequest(outputStreamWriter);
                return;
            }
            RequestHandler requestHandler = clazz.newInstance();
            try {
                requestHandler.setCommand(string4);
                requestHandler.setUrl(string3);
                requestHandler.checkPermission();
                requestHandler.handle();
                this.sendHeader(outputStreamWriter, "200 OK", requestHandler.getContentType(), false);
                outputStreamWriter.write("Content-length: " + requestHandler.getContent().length() + "\r\n");
                outputStreamWriter.write("\r\n");
                outputStreamWriter.write(requestHandler.getContent());
                ((Writer)outputStreamWriter).flush();
                return;
            }
            catch (RequestHandler.RequestHandlerErrorException requestHandlerErrorException) {
                this.sendError(outputStreamWriter);
                return;
            }
            catch (RequestHandler.RequestHandlerBadRequestException requestHandlerBadRequestException) {
                this.sendBadRequest(outputStreamWriter);
                return;
            }
            catch (RequestHandler.RequestHandlerForbiddenException requestHandlerForbiddenException) {
                this.sendForbidden(outputStreamWriter);
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                this.sendError(outputStreamWriter);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                this.request.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendError(Writer writer) throws IOException {
        this.sendHeader(writer, "500 Internal Server Error", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Internal Error</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 500: Internal Server Error</h2>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendNotImplemented(Writer writer) throws IOException {
        this.sendHeader(writer, "501 Not Implemented", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Not Implemented</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 501: Not Implemented</h2>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendForbidden(Writer writer) throws IOException {
        this.sendHeader(writer, "403 Forbidden", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Forbidden</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 403: Forbidden</h2>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendBadRequest(Writer writer) throws IOException {
        this.sendHeader(writer, "400 Bad Request", "text/html", true);
        writer.write("<HTML>\r\n");
        writer.write("<HEAD><TITLE>Bad Request</TITLE>\r\n");
        writer.write("</HEAD>\r\n");
        writer.write("<BODY>");
        writer.write("<H1>HTTP Error 400: Bad Request</h2>\r\n");
        writer.write("</BODY></HTML>\r\n");
        writer.flush();
    }

    private void sendHeader(Writer writer, String string, String string2, boolean bl) throws IOException {
        writer.write("HTTP/1.1 " + string + "\r\n");
        Date date = new Date();
        writer.write("Date: " + date + "\r\n");
        writer.write("Server: JOSM RemoteControl\r\n");
        writer.write("Content-type: " + string2 + "\r\n");
        writer.write("Access-Control-Allow-Origin: *\r\n");
        if (bl) {
            writer.write("\r\n");
        }
    }

    static {
        RequestProcessor.addRequestHandlerClass("load_and_zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("zoom", LoadAndZoomHandler.class, true);
        RequestProcessor.addRequestHandlerClass("imagery", ImageryHandler.class, true);
        RequestProcessor.addRequestHandlerClass("add_node", AddNodeHandler.class, true);
        RequestProcessor.addRequestHandlerClass("import", ImportHandler.class, true);
        RequestProcessor.addRequestHandlerClass("version", VersionHandler.class, true);
    }
}

