/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialAgent;
import org.openstreetmap.josm.tools.Utils;

public class CredentialsManager
implements CredentialsAgent {
    private static CredentialsManager instance;
    private static CredentialsAgentFactory agentFactory;
    private CredentialsAgent delegate;

    public static CredentialsManager getInstance() {
        if (instance == null) {
            CredentialsAgent credentialsAgent = agentFactory == null ? new JosmPreferencesCredentialAgent() : agentFactory.getCredentialsAgent();
            instance = new CredentialsManager(credentialsAgent);
        }
        return instance;
    }

    public static void registerCredentialsAgentFactory(CredentialsAgentFactory credentialsAgentFactory) {
        agentFactory = credentialsAgentFactory;
        instance = null;
    }

    public CredentialsManager(CredentialsAgent credentialsAgent) {
        this.delegate = credentialsAgent;
    }

    public String getUsername() {
        String string = null;
        try {
            PasswordAuthentication passwordAuthentication = this.lookup(Authenticator.RequestorType.SERVER);
            if (passwordAuthentication != null) {
                string = passwordAuthentication.getUserName();
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            return null;
        }
        if (string == null) {
            return null;
        }
        return Utils.equal(string = string.trim(), "") ? null : string;
    }

    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType) throws CredentialsAgentException {
        return this.delegate.lookup(requestorType);
    }

    public void store(Authenticator.RequestorType requestorType, PasswordAuthentication passwordAuthentication) throws CredentialsAgentException {
        if (requestorType == Authenticator.RequestorType.SERVER && passwordAuthentication.getUserName() != null && !passwordAuthentication.getUserName().trim().isEmpty()) {
            JosmUserIdentityManager.getInstance().setPartiallyIdentified(passwordAuthentication.getUserName());
        }
        this.delegate.store(requestorType, passwordAuthentication);
    }

    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, boolean bl) throws CredentialsAgentException {
        return this.delegate.getCredentials(requestorType, bl);
    }

    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        return this.delegate.lookupOAuthAccessToken();
    }

    public void storeOAuthAccessToken(OAuthToken oAuthToken) throws CredentialsAgentException {
        this.delegate.storeOAuthAccessToken(oAuthToken);
    }

    public Component getPreferencesDecorationPanel() {
        return this.delegate.getPreferencesDecorationPanel();
    }

    public static interface CredentialsAgentFactory {
        public CredentialsAgent getCredentialsAgent();
    }
}

