/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;

public class GPXSettingsPanel
extends JPanel
implements PreferenceTabbedPane.ValidationListener {
    private static final int WAYPOINT_LABEL_CUSTOM = 6;
    private static final String[] LABEL_PATTERN_TEMPLATE = new String[]{"?{ '{name} - {desc}' | '{name}' | '{desc}' }", "{name}", "{desc}", "{*}", "?{ '{name}' | '{desc}' | '{formattedWaypointOffset}' }", ""};
    private static final String[] LABEL_PATTERN_DESC = new String[]{I18n.tr("Auto", new Object[0]), I18n.trc("gpx_field", "Name"), I18n.trc("gpx_field", "Desc(ription)"), I18n.tr("Everything", new Object[0]), I18n.tr("Name or offset", new Object[0]), I18n.tr("None", new Object[0]), I18n.tr("Custom", new Object[0])};
    private JRadioButton drawRawGpsLinesGlobal = new JRadioButton(I18n.tr("Use global settings.", new Object[0]));
    private JRadioButton drawRawGpsLinesAll = new JRadioButton(I18n.tr("All", new Object[0]));
    private JRadioButton drawRawGpsLinesLocal = new JRadioButton(I18n.tr("Local files", new Object[0]));
    private JRadioButton drawRawGpsLinesNone = new JRadioButton(I18n.tr("None", new Object[0]));
    private ActionListener drawRawGpsLinesActionListener;
    private JTextField drawRawGpsMaxLineLength = new JTextField(8);
    private JTextField drawRawGpsMaxLineLengthLocal = new JTextField(8);
    private JCheckBox forceRawGpsLines = new JCheckBox(I18n.tr("Force lines if no segments imported.", new Object[0]));
    private JCheckBox largeGpsPoints = new JCheckBox(I18n.tr("Draw large GPS points.", new Object[0]));
    private JCheckBox hdopCircleGpsPoints = new JCheckBox(I18n.tr("Draw a circle form HDOP value.", new Object[0]));
    private ButtonGroup colorGroup;
    private JRadioButton colorTypeVelocity = new JRadioButton(I18n.tr("Velocity (red = slow, green = fast)", new Object[0]));
    private JRadioButton colorTypeDirection = new JRadioButton(I18n.tr("Direction (red = west, yellow = north, green = east, blue = south)", new Object[0]));
    private JRadioButton colorTypeDilution = new JRadioButton(I18n.tr("Dilution of Position (red = high, green = low, if available)", new Object[0]));
    private JRadioButton colorTypeTime = new JRadioButton(I18n.tr("Track date", new Object[0]));
    private JRadioButton colorTypeNone = new JRadioButton(I18n.tr("Single Color (can be customized for named layers)", new Object[0]));
    private JRadioButton colorTypeGlobal = new JRadioButton(I18n.tr("Use global settings.", new Object[0]));
    private JComboBox colorTypeVelocityTune = new JComboBox<String>(new String[]{I18n.tr("Car", new Object[0]), I18n.tr("Bicycle", new Object[0]), I18n.tr("Foot", new Object[0])});
    private JCheckBox makeAutoMarkers = new JCheckBox(I18n.tr("Create markers when reading GPX.", new Object[0]));
    private JCheckBox drawGpsArrows = new JCheckBox(I18n.tr("Draw Direction Arrows", new Object[0]));
    private JCheckBox drawGpsArrowsFast = new JCheckBox(I18n.tr("Fast drawing (looks uglier)", new Object[0]));
    private JTextField drawGpsArrowsMinDist = new JTextField(8);
    private JCheckBox colorDynamic = new JCheckBox(I18n.tr("Dynamic color range based on data limits", new Object[0]));
    private JComboBox waypointLabel = new JComboBox<String>(LABEL_PATTERN_DESC);
    private JTextField waypointLabelPattern = new JTextField();
    private JComboBox audioWaypointLabel = new JComboBox<String>(LABEL_PATTERN_DESC);
    private JTextField audioWaypointLabelPattern = new JTextField();
    private String layerName;
    private boolean local;
    private boolean nonlocal;

    public GPXSettingsPanel(String string, boolean bl, boolean bl2) {
        super(new GridBagLayout());
        this.local = bl;
        this.nonlocal = bl2;
        this.layerName = "layer " + string;
        this.initComponents();
        this.loadPreferences();
    }

    public GPXSettingsPanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.local = false;
        this.nonlocal = false;
        this.loadPreferences();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.makeAutoMarkers.setToolTipText(I18n.tr("Automatically make a marker layer from any waypoints when opening a GPX layer.", new Object[0]));
        this.add((Component)this.makeAutoMarkers, GBC.eol().insets(20, 0, 0, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.layerName != null) {
            buttonGroup.add(this.drawRawGpsLinesGlobal);
        }
        buttonGroup.add(this.drawRawGpsLinesNone);
        buttonGroup.add(this.drawRawGpsLinesLocal);
        buttonGroup.add(this.drawRawGpsLinesAll);
        this.add((Component)new JLabel(I18n.tr("Draw lines between raw GPS points", new Object[0])), GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.drawRawGpsLinesGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.drawRawGpsLinesNone, GBC.eol().insets(40, 0, 0, 0));
        if (this.layerName == null || this.local) {
            this.add((Component)this.drawRawGpsLinesLocal, GBC.eol().insets(40, 0, 0, 0));
        }
        if (this.layerName == null || this.nonlocal) {
            this.add((Component)this.drawRawGpsLinesAll, GBC.eol().insets(40, 0, 0, 0));
        }
        this.drawRawGpsLinesActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GPXSettingsPanel.this.drawRawGpsLinesNone.isSelected() || GPXSettingsPanel.this.drawRawGpsLinesGlobal.isSelected();
                GPXSettingsPanel.this.forceRawGpsLines.setEnabled(!bl);
                GPXSettingsPanel.this.drawRawGpsMaxLineLength.setEnabled(!bl && !GPXSettingsPanel.this.drawRawGpsLinesLocal.isSelected());
                GPXSettingsPanel.this.drawRawGpsMaxLineLengthLocal.setEnabled(!bl);
                GPXSettingsPanel.this.drawGpsArrows.setEnabled(!bl);
                GPXSettingsPanel.this.drawGpsArrowsFast.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
                GPXSettingsPanel.this.drawGpsArrowsMinDist.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
            }
        };
        this.drawRawGpsLinesGlobal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesNone.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesLocal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesAll.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsMaxLineLengthLocal.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines for local files. Set to ''-1'' to draw all lines.", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Maximum length for local files (meters)", new Object[0])), GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLengthLocal, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.drawRawGpsMaxLineLength.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines. Set to ''-1'' to draw all lines.", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Maximum length (meters)", new Object[0])), GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLength, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.forceRawGpsLines.setToolTipText(I18n.tr("Force drawing of lines if the imported data contain no line information.", new Object[0]));
        this.add((Component)this.forceRawGpsLines, GBC.eop().insets(40, 0, 0, 0));
        this.drawGpsArrows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GPXSettingsPanel.this.drawGpsArrowsFast.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
                GPXSettingsPanel.this.drawGpsArrowsMinDist.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
            }
        });
        this.drawGpsArrows.setToolTipText(I18n.tr("Draw direction arrows for lines, connecting GPS points.", new Object[0]));
        this.add((Component)this.drawGpsArrows, GBC.eop().insets(40, 0, 0, 0));
        this.drawGpsArrowsFast.setToolTipText(I18n.tr("Draw the direction arrows using table lookups instead of complex math.", new Object[0]));
        this.add((Component)this.drawGpsArrowsFast, GBC.eop().insets(60, 0, 0, 0));
        this.drawGpsArrowsMinDist.setToolTipText(I18n.tr("Do not draw arrows if they are not at least this distance away from the last one.", new Object[0]));
        this.add((Component)new JLabel(I18n.tr("Minimum distance (pixels)", new Object[0])), GBC.std().insets(60, 0, 0, 0));
        this.add((Component)this.drawGpsArrowsMinDist, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.hdopCircleGpsPoints.setToolTipText(I18n.tr("Draw a circle form HDOP value.", new Object[0]));
        this.add((Component)this.hdopCircleGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.largeGpsPoints.setToolTipText(I18n.tr("Draw larger dots for the GPS points.", new Object[0]));
        this.add((Component)this.largeGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.colorGroup = new ButtonGroup();
        if (this.layerName != null) {
            this.colorGroup.add(this.colorTypeGlobal);
        }
        this.colorGroup.add(this.colorTypeNone);
        this.colorGroup.add(this.colorTypeVelocity);
        this.colorGroup.add(this.colorTypeDirection);
        this.colorGroup.add(this.colorTypeDilution);
        this.colorGroup.add(this.colorTypeTime);
        this.colorTypeVelocity.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GPXSettingsPanel.this.colorTypeVelocityTune.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected());
                GPXSettingsPanel.this.colorDynamic.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected() || GPXSettingsPanel.this.colorTypeDilution.isSelected());
            }
        });
        this.colorTypeDilution.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GPXSettingsPanel.this.colorDynamic.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected() || GPXSettingsPanel.this.colorTypeDilution.isSelected());
            }
        });
        this.colorTypeNone.setToolTipText(I18n.tr("All points and track segments will have the same color. Can be customized in Layer Manager.", new Object[0]));
        this.colorTypeVelocity.setToolTipText(I18n.tr("Colors points and track segments by velocity.", new Object[0]));
        this.colorTypeDirection.setToolTipText(I18n.tr("Colors points and track segments by direction.", new Object[0]));
        this.colorTypeDilution.setToolTipText(I18n.tr("Colors points and track segments by dilution of position (HDOP). Your capture device needs to log that information.", new Object[0]));
        this.colorTypeTime.setToolTipText(I18n.tr("Colors points and track segments by its timestamp.", new Object[0]));
        this.colorTypeVelocityTune.setToolTipText(I18n.tr("Allows to tune the track coloring for different average speeds.", new Object[0]));
        this.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Track and Point Coloring", new Object[0])), GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.colorTypeGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.colorTypeNone, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeVelocity, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeVelocityTune, GBC.eop().insets(5, 0, 0, 5));
        this.add((Component)this.colorTypeDirection, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeDilution, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeTime, GBC.eol().insets(40, 0, 0, 0));
        this.colorDynamic.setToolTipText(I18n.tr("Colors points and track segments by data limits.", new Object[0]));
        this.add((Component)this.colorDynamic, GBC.eop().insets(40, 0, 0, 0));
        if (this.layerName == null) {
            this.add((Component)new JLabel(I18n.tr("Waypoint labelling", new Object[0])), GBC.std().insets(20, 0, 0, 0));
            this.add((Component)this.waypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.waypointLabel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GPXSettingsPanel.this.updateWaypointPattern(GPXSettingsPanel.this.waypointLabel, GPXSettingsPanel.this.waypointLabelPattern);
                }
            });
            this.updateWaypointLabelCombobox(this.waypointLabel, this.waypointLabelPattern, Marker.TemplateEntryProperty.forMarker(this.layerName));
            this.add((Component)this.waypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
            this.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
            this.add((Component)new JLabel(I18n.tr("Audio waypoint labelling", new Object[0])), GBC.std().insets(20, 0, 0, 0));
            this.add((Component)this.audioWaypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
            this.audioWaypointLabel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GPXSettingsPanel.this.updateWaypointPattern(GPXSettingsPanel.this.audioWaypointLabel, GPXSettingsPanel.this.audioWaypointLabelPattern);
                }
            });
            this.updateWaypointLabelCombobox(this.audioWaypointLabel, this.audioWaypointLabelPattern, Marker.TemplateEntryProperty.forAudioMarker(this.layerName));
            this.add((Component)this.audioWaypointLabelPattern, GBC.eol().fill(2).insets(20, 0, 0, 5));
        }
        this.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public void loadPreferences() {
        this.makeAutoMarkers.setSelected(Main.pref.getBoolean("marker.makeautomarkers", true));
        if (this.layerName != null && !Main.pref.hasKey("draw.rawgps.lines." + this.layerName) && !Main.pref.hasKey("draw.rawgps.lines.local." + this.layerName)) {
            this.drawRawGpsLinesGlobal.setSelected(true);
        } else {
            Boolean bl = Main.pref.getBoolean("draw.rawgps.lines.local", this.layerName, true);
            if (Main.pref.getBoolean("draw.rawgps.lines", this.layerName, true)) {
                this.drawRawGpsLinesAll.setSelected(true);
            } else if (bl.booleanValue()) {
                this.drawRawGpsLinesLocal.setSelected(true);
            } else {
                this.drawRawGpsLinesNone.setSelected(true);
            }
        }
        this.drawRawGpsMaxLineLengthLocal.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length.local", this.layerName, -1)));
        this.drawRawGpsMaxLineLength.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length", this.layerName, 200)));
        this.forceRawGpsLines.setSelected(Main.pref.getBoolean("draw.rawgps.lines.force", this.layerName, false));
        this.drawGpsArrows.setSelected(Main.pref.getBoolean("draw.rawgps.direction", this.layerName, false));
        this.drawGpsArrowsFast.setSelected(Main.pref.getBoolean("draw.rawgps.alternatedirection", this.layerName, false));
        this.drawGpsArrowsMinDist.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.min-arrow-distance", this.layerName, 40)));
        this.hdopCircleGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.hdopcircle", this.layerName, false));
        this.largeGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.large", this.layerName, false));
        this.drawRawGpsLinesActionListener.actionPerformed(null);
        if (this.layerName != null && !Main.pref.hasKey("draw.rawgps.colors." + this.layerName)) {
            this.colorTypeGlobal.setSelected(true);
            this.colorDynamic.setSelected(false);
            this.colorDynamic.setEnabled(false);
        } else {
            switch (Main.pref.getInteger("draw.rawgps.colors", this.layerName, 0)) {
                case 0: {
                    this.colorTypeNone.setSelected(true);
                    break;
                }
                case 1: {
                    this.colorTypeVelocity.setSelected(true);
                    break;
                }
                case 2: {
                    this.colorTypeDilution.setSelected(true);
                    break;
                }
                case 3: {
                    this.colorTypeDirection.setSelected(true);
                    break;
                }
                case 4: {
                    this.colorTypeTime.setSelected(true);
                }
            }
            int n = Main.pref.getInteger("draw.rawgps.colorTracksTune", this.layerName, 45);
            this.colorTypeVelocityTune.setSelectedIndex(n == 10 ? 2 : (n == 20 ? 1 : 0));
            this.colorTypeVelocityTune.setEnabled(this.colorTypeVelocity.isSelected() && this.colorTypeVelocity.isEnabled());
            this.colorDynamic.setSelected(Main.pref.getBoolean("draw.rawgps.colors.dynamic", this.layerName, false));
            this.colorDynamic.setEnabled(this.colorTypeVelocity.isSelected() || this.colorTypeDilution.isSelected());
        }
    }

    public boolean savePreferences(String string, boolean bl) {
        String string2 = ".layer " + string;
        if (string == null) {
            string2 = "";
        }
        Main.pref.put("marker.makeautomarkers" + string2, this.makeAutoMarkers.isSelected());
        if (this.drawRawGpsLinesGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.lines" + string2, null);
            Main.pref.put("draw.rawgps.max-line-length" + string2, null);
            Main.pref.put("draw.rawgps.lines.local" + string2, null);
            Main.pref.put("draw.rawgps.max-line-length.local" + string2, null);
            Main.pref.put("draw.rawgps.lines.force" + string2, null);
            Main.pref.put("draw.rawgps.direction" + string2, null);
            Main.pref.put("draw.rawgps.alternatedirection" + string2, null);
            Main.pref.put("draw.rawgps.min-arrow-distance" + string2, null);
        } else {
            if (string == null || !bl) {
                Main.pref.put("draw.rawgps.lines" + string2, this.drawRawGpsLinesAll.isSelected());
                Main.pref.put("draw.rawgps.max-line-length" + string2, this.drawRawGpsMaxLineLength.getText());
            }
            if (string == null || bl) {
                Main.pref.put("draw.rawgps.lines.local" + string2, this.drawRawGpsLinesAll.isSelected() || this.drawRawGpsLinesLocal.isSelected());
                Main.pref.put("draw.rawgps.max-line-length.local" + string2, this.drawRawGpsMaxLineLengthLocal.getText());
            }
            Main.pref.put("draw.rawgps.lines.force" + string2, this.forceRawGpsLines.isSelected());
            Main.pref.put("draw.rawgps.direction" + string2, this.drawGpsArrows.isSelected());
            Main.pref.put("draw.rawgps.alternatedirection" + string2, this.drawGpsArrowsFast.isSelected());
            Main.pref.put("draw.rawgps.min-arrow-distance" + string2, this.drawGpsArrowsMinDist.getText());
        }
        Main.pref.put("draw.rawgps.hdopcircle" + string2, this.hdopCircleGpsPoints.isSelected());
        Main.pref.put("draw.rawgps.large" + string2, this.largeGpsPoints.isSelected());
        Marker.TemplateEntryProperty.forMarker(string).put(this.waypointLabelPattern.getText());
        Marker.TemplateEntryProperty.forAudioMarker(string).put(this.audioWaypointLabelPattern.getText());
        if (this.colorTypeGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.colors" + string2, null);
            Main.pref.put("draw.rawgps.colors.dynamic" + string2, null);
            Main.pref.put("draw.rawgps.colorTracksTunec" + string2, null);
            return false;
        }
        if (this.colorTypeVelocity.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 1);
        } else if (this.colorTypeDilution.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 2);
        } else if (this.colorTypeDirection.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 3);
        } else if (this.colorTypeTime.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 4);
        } else {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 0);
        }
        Main.pref.put("draw.rawgps.colors.dynamic" + string2, this.colorDynamic.isSelected());
        int n = this.colorTypeVelocityTune.getSelectedIndex();
        Main.pref.putInteger("draw.rawgps.colorTracksTune" + string2, n == 2 ? 10 : (n == 1 ? 20 : 45));
        return false;
    }

    public void savePreferences() {
        this.savePreferences(null, false);
    }

    private void updateWaypointLabelCombobox(JComboBox jComboBox, JTextField jTextField, Marker.TemplateEntryProperty templateEntryProperty) {
        String string = templateEntryProperty.getAsString();
        boolean bl = false;
        for (int i = 0; i < LABEL_PATTERN_TEMPLATE.length; ++i) {
            if (!LABEL_PATTERN_TEMPLATE[i].equals(string)) continue;
            jComboBox.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            jComboBox.setSelectedIndex(6);
            jTextField.setEnabled(true);
            jTextField.setText(string);
        }
    }

    private void updateWaypointPattern(JComboBox jComboBox, JTextField jTextField) {
        if (jComboBox.getSelectedIndex() == 6) {
            jTextField.setEnabled(true);
        } else {
            jTextField.setEnabled(false);
            jTextField.setText(LABEL_PATTERN_TEMPLATE[jComboBox.getSelectedIndex()]);
        }
    }

    public boolean validatePreferences() {
        TemplateParser templateParser = new TemplateParser(this.waypointLabelPattern.getText());
        try {
            templateParser.parse();
        }
        catch (ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Incorrect waypoint label pattern: {0}", parseError.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.waypointLabelPattern.requestFocus();
            return false;
        }
        templateParser = new TemplateParser(this.audioWaypointLabelPattern.getText());
        try {
            templateParser.parse();
        }
        catch (ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Incorrect audio waypoint label pattern: {0}", parseError.getMessage()), I18n.tr("Incorrect pattern", new Object[0]), 0);
            this.audioWaypointLabelPattern.requestFocus();
            return false;
        }
        return true;
    }
}

