/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Rectangle;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class BoxTextElemStyle
extends ElemStyle {
    public static Rectangle ZERO_BOX = new Rectangle(0, 0, 0, 0);
    public TextElement text;
    public Rectangle box;
    public HorizontalTextAlignment hAlign;
    public VerticalTextAlignment vAlign;
    public static final BoxTextElemStyle SIMPLE_NODE_TEXT_ELEMSTYLE;
    private static Color DEFAULT_TEXT_COLOR;

    public BoxTextElemStyle(Cascade cascade, TextElement textElement, Rectangle rectangle, HorizontalTextAlignment horizontalTextAlignment, VerticalTextAlignment verticalTextAlignment) {
        super(cascade, 2000.0f);
        CheckParameterUtil.ensureParameterNotNull(textElement);
        CheckParameterUtil.ensureParameterNotNull((Object)horizontalTextAlignment);
        CheckParameterUtil.ensureParameterNotNull((Object)verticalTextAlignment);
        this.text = textElement;
        this.box = rectangle == null ? ZERO_BOX : rectangle;
        this.hAlign = horizontalTextAlignment;
        this.vAlign = verticalTextAlignment;
    }

    public static BoxTextElemStyle create(Environment environment, Rectangle rectangle) {
        BoxTextElemStyle.initDefaultParameters();
        Cascade cascade = environment.mc.getCascade(environment.layer);
        TextElement textElement = TextElement.create(cascade, DEFAULT_TEXT_COLOR, false);
        if (textElement == null) {
            return null;
        }
        if (textElement.labelCompositionStrategy.compose(environment.osm) == null) {
            return null;
        }
        HorizontalTextAlignment horizontalTextAlignment = HorizontalTextAlignment.RIGHT;
        Keyword keyword = cascade.get("text-anchor-horizontal", Keyword.RIGHT, Keyword.class);
        if (Utils.equal(keyword.val, "left")) {
            horizontalTextAlignment = HorizontalTextAlignment.LEFT;
        } else if (Utils.equal(keyword.val, "center")) {
            horizontalTextAlignment = HorizontalTextAlignment.CENTER;
        } else if (Utils.equal(keyword.val, "right")) {
            horizontalTextAlignment = HorizontalTextAlignment.RIGHT;
        }
        VerticalTextAlignment verticalTextAlignment = VerticalTextAlignment.BOTTOM;
        String string = cascade.get((String)"text-anchor-vertical", Keyword.BOTTOM, Keyword.class).val;
        if (Utils.equal(string, "above")) {
            verticalTextAlignment = VerticalTextAlignment.ABOVE;
        } else if (Utils.equal(string, "top")) {
            verticalTextAlignment = VerticalTextAlignment.TOP;
        } else if (Utils.equal(string, "center")) {
            verticalTextAlignment = VerticalTextAlignment.CENTER;
        } else if (Utils.equal(string, "bottom")) {
            verticalTextAlignment = VerticalTextAlignment.BOTTOM;
        } else if (Utils.equal(string, "below")) {
            verticalTextAlignment = VerticalTextAlignment.BELOW;
        }
        return new BoxTextElemStyle(cascade, textElement, rectangle, horizontalTextAlignment, verticalTextAlignment);
    }

    private static void initDefaultParameters() {
        if (DEFAULT_TEXT_COLOR != null) {
            return;
        }
        DEFAULT_TEXT_COLOR = PaintColors.TEXT.get();
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        if (osmPrimitive instanceof Node) {
            mapPainter.drawBoxText((Node)osmPrimitive, this);
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BoxTextElemStyle boxTextElemStyle = (BoxTextElemStyle)object;
        return this.text.equals(boxTextElemStyle.text) && this.box.equals(boxTextElemStyle.box) && this.hAlign == boxTextElemStyle.hAlign && this.vAlign == boxTextElemStyle.vAlign;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 97 * n + this.text.hashCode();
        n = 97 * n + this.box.hashCode();
        n = 97 * n + this.hAlign.hashCode();
        n = 97 * n + this.vAlign.hashCode();
        return n;
    }

    public String toString() {
        return "BoxTextElemStyle{" + super.toString() + " " + this.text.toStringImpl() + " box=" + this.box + " hAlign=" + (Object)((Object)this.hAlign) + " vAlign=" + (Object)((Object)this.vAlign) + '}';
    }

    static {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        cascade.put("text", Keyword.AUTO);
        Node node = new Node();
        node.put("name", "dummy");
        SIMPLE_NODE_TEXT_ELEMSTYLE = BoxTextElemStyle.create(new Environment(node, multiCascade, "default", null), NodeElemStyle.SIMPLE_NODE_ELEMSTYLE.getBox());
        if (SIMPLE_NODE_TEXT_ELEMSTYLE == null) {
            throw new AssertionError();
        }
        DEFAULT_TEXT_COLOR = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalTextAlignment {
        ABOVE,
        TOP,
        CENTER,
        BOTTOM,
        BELOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HorizontalTextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

