/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.ServerSidePreferences;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainApplet
extends JApplet {
    static final JFrame frame = new JFrame("Java OpenStreetMap Editor");
    private static final String[][] paramInfo = new String[][]{{"username", I18n.tr("string", new Object[0]), I18n.tr("Name of the user.", new Object[0])}, {"password", I18n.tr("string", new Object[0]), I18n.tr("OSM Password.", new Object[0])}, {"geometry", I18n.tr("string", new Object[0]), I18n.tr("Resize the applet to the given geometry (format: WIDTHxHEIGHT)", new Object[0])}, {"download", I18n.tr("string;string;...", new Object[0]), I18n.tr("Download each. Can be x1,y1,x2,y2 an URL containing lat=y&lon=x&zoom=z or a filename", new Object[0])}, {"downloadgps", I18n.tr("string;string;...", new Object[0]), I18n.tr("Download each as raw gps. Can be x1,y1,x2,y2 an URL containing lat=y&lon=x&zoom=z or a filename", new Object[0])}, {"selection", I18n.tr("string;string;...", new Object[0]), I18n.tr("Add each to the initial selection. Can be a google-like search string or an URL which returns osm-xml", new Object[0])}, {"reset-preferences", I18n.tr("any", new Object[0]), I18n.tr("If specified, reset the configuration instead of reading it.", new Object[0])}};
    private Map<String, Collection<String>> args = new HashMap<String, Collection<String>>();

    @Override
    public String[][] getParameterInfo() {
        return paramInfo;
    }

    @Override
    public void init() {
        for (String[] stringArray : paramInfo) {
            Collection<String> collection = this.readParameter(stringArray[0], this.args.get(stringArray[0]));
            if (collection == null) continue;
            this.args.put(stringArray[0], collection);
        }
        if (!this.args.containsKey("geometry") && this.getParameter("width") != null && this.getParameter("height") != null) {
            this.args.put("geometry", Arrays.asList(this.getParameter("width") + "x" + this.getParameter("height")));
        }
    }

    @Override
    public void start() {
        block6: {
            I18n.init();
            Main.checkJava6();
            String string = this.getParameter("load_url");
            if (string != null) {
                this.args.put("download", Arrays.asList(string));
            }
            Main.determinePlatformHook();
            Main.platform.preStartupHook();
            Main.pref = new ServerSidePreferences(this.getCodeBase());
            String string2 = this.getParameter("language");
            I18n.set(string2 != null ? string2 : Main.pref.get("language", null));
            try {
                ((ServerSidePreferences)Main.pref).download();
            }
            catch (ServerSidePreferences.MissingPassword missingPassword) {
                String string3;
                String string4 = this.args.containsKey("username") ? this.args.get("username").iterator().next() : null;
                String string5 = string3 = this.args.containsKey("password") ? this.args.get("password").iterator().next() : null;
                if (string4 == null || string3 == null) {
                    JPanel jPanel = new JPanel(new GridBagLayout());
                    jPanel.add((Component)new JLabel(I18n.tr(missingPassword.realm, new Object[0])), GBC.eol().fill(2));
                    jPanel.add((Component)new JLabel(I18n.tr("Username", new Object[0])), GBC.std().insets(0, 0, 20, 0));
                    JTextField jTextField = new JTextField(string4 == null ? "" : string4);
                    jPanel.add((Component)jTextField, GBC.eol().fill(2));
                    jPanel.add((Component)new JLabel(I18n.tr("Password", new Object[0])), GBC.std().insets(0, 0, 20, 0));
                    JPasswordField jPasswordField = new JPasswordField(string3 == null ? "" : string3);
                    jPanel.add((Component)jPasswordField, GBC.eol().fill(2));
                    JOptionPane.showMessageDialog(null, jPanel);
                    string4 = jTextField.getText();
                    if ("".equals(string4)) {
                        string4 = null;
                    }
                    if ("".equals(string3 = new String(jPasswordField.getPassword()))) {
                        string3 = null;
                    }
                }
                if (string4 == null || string3 == null) break block6;
                ((ServerSidePreferences)Main.pref).download(string4, string3);
            }
        }
        Main.preConstructorInit(this.args);
        Main.parent = frame;
        Main.addListener();
        new MainCaller().postConstructorProcessCmdLine(this.args);
        MainMenu mainMenu = Main.main.menu;
        mainMenu.editMenu.add(new UploadPreferencesAction());
        mainMenu.openFile.setEnabled(false);
        mainMenu.exit.setEnabled(false);
        mainMenu.save.setEnabled(false);
        mainMenu.saveAs.setEnabled(false);
        mainMenu.gpxExport.setEnabled(false);
    }

    private Collection<String> readParameter(String string, Collection<String> collection) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            if (collection == null) {
                collection = new LinkedList<String>();
            }
            collection.addAll(Arrays.asList(string2.split(";")));
        }
        return collection;
    }

    public static void main(String[] stringArray) {
        Main.applet = true;
        MainApplet mainApplet = new MainApplet();
        Main.pref = new ServerSidePreferences(mainApplet.getCodeBase());
        mainApplet.setStub(new AppletStub(){

            public void appletResize(int n, int n2) {
                frame.setSize(n, n2);
            }

            public AppletContext getAppletContext() {
                return null;
            }

            public URL getCodeBase() {
                try {
                    return new File(".").toURI().toURL();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
            }

            public URL getDocumentBase() {
                return this.getCodeBase();
            }

            public String getParameter(String string) {
                return null;
            }

            public boolean isActive() {
                return true;
            }
        });
        mainApplet.init();
        mainApplet.start();
        frame.setContentPane(mainApplet);
        frame.setVisible(true);
    }

    private final class MainCaller
    extends Main {
        private MainCaller() {
            MainApplet.this.setContentPane(contentPanePrivate);
            MainApplet.this.setJMenuBar(this.menu);
            MainApplet.this.setBounds(bounds);
        }
    }

    public static final class UploadPreferencesAction
    extends JosmAction {
        public UploadPreferencesAction() {
            super(I18n.tr("Upload Preferences", new Object[0]), "upload-preferences", I18n.tr("Upload the current preferences to the server", new Object[0]), Shortcut.registerShortcut("applet:uploadprefs", I18n.tr("Upload Preferences", new Object[0]), 85, 1), true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((ServerSidePreferences)Main.pref).upload();
        }
    }
}

