/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class UnclosedWays
extends Test {
    private String type;
    private String etype;
    private int mode;

    public UnclosedWays() {
        super(I18n.tr("Unclosed Ways.", new Object[0]), I18n.tr("This tests if ways which should be circular are closed.", new Object[0]));
    }

    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
    }

    public void endTest() {
        super.endTest();
    }

    public void set(int n, String string, String string2) {
        this.etype = MessageFormat.format(string, string2);
        this.type = I18n.tr(string, I18n.tr(string2, new Object[0]));
        this.mode = n;
    }

    public void set(int n, String string) {
        this.etype = string;
        this.type = I18n.tr(string, new Object[0]);
        this.mode = n;
    }

    public void visit(Way way) {
        Boolean bl;
        this.etype = null;
        this.type = null;
        this.mode = 0;
        if (!way.isUsable()) {
            return;
        }
        String string = way.get("natural");
        if (!(string == null || "coastline".equals(string) || "cliff".equals(string) || "tree_row".equals(string))) {
            this.set(1101, I18n.marktr("natural type {0}"), string);
        }
        if ((string = way.get("landuse")) != null) {
            this.set(1102, I18n.marktr("landuse type {0}"), string);
        }
        if ((string = way.get("amenities")) != null) {
            this.set(1103, I18n.marktr("amenities type {0}"), string);
        }
        if ((string = way.get("sport")) != null && !string.equals("water_slide")) {
            this.set(1104, I18n.marktr("sport type {0}"), string);
        }
        if ((string = way.get("tourism")) != null) {
            this.set(1105, I18n.marktr("tourism type {0}"), string);
        }
        if ((string = way.get("shop")) != null) {
            this.set(1106, I18n.marktr("shop type {0}"), string);
        }
        if ((string = way.get("leisure")) != null && !"track".contains(string)) {
            this.set(1107, I18n.marktr("leisure type {0}"), string);
        }
        if ((string = way.get("waterway")) != null && string.equals("riverbank")) {
            this.set(1108, I18n.marktr("waterway type {0}"), string);
        }
        if ((bl = OsmUtils.getOsmBoolean(way.get("building"))) != null && bl.booleanValue()) {
            this.set(1120, I18n.marktr("building"));
        }
        if ((bl = OsmUtils.getOsmBoolean(way.get("area"))) != null && bl.booleanValue()) {
            this.set(1130, I18n.marktr("area"));
        }
        if (this.type != null && !way.isClosed()) {
            OsmPrimitive osmPrimitive2;
            for (OsmPrimitive osmPrimitive2 : way.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || !((Relation)osmPrimitive2).isMultipolygon()) continue;
                return;
            }
            Node node = way.firstNode();
            osmPrimitive2 = way.lastNode();
            ArrayList<Way> arrayList = new ArrayList<Way>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList.add(way);
            arrayList2.add(node);
            arrayList2.add(osmPrimitive2);
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unclosed way", new Object[0]), this.type, this.etype, this.mode, arrayList, arrayList2));
        }
    }
}

