/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationData
extends PrimitiveData
implements IRelation {
    private List<RelationMemberData> members = new ArrayList<RelationMemberData>();

    public RelationData() {
    }

    public RelationData(RelationData relationData) {
        super(relationData);
        this.members.addAll(relationData.members);
    }

    public List<RelationMemberData> getMembers() {
        return this.members;
    }

    public void setMembers(List<RelationMemberData> list) {
        this.members = new ArrayList<RelationMemberData>(list);
    }

    @Override
    public int getMembersCount() {
        return this.members.size();
    }

    @Override
    public long getMemberId(int n) {
        return this.members.get(n).getMemberId();
    }

    @Override
    public String getRole(int n) {
        return this.members.get(n).getRole();
    }

    @Override
    public OsmPrimitiveType getMemberType(int n) {
        return this.members.get(n).getMemberType();
    }

    @Override
    public RelationData makeCopy() {
        return new RelationData(this);
    }

    @Override
    public String toString() {
        return super.toString() + " REL " + this.members;
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    @Override
    public void visit(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }
}

