/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.projection.Projections;

public class NodeData
extends PrimitiveData
implements INode {
    private double lat = Double.NaN;
    private double lon = Double.NaN;

    public NodeData() {
    }

    public NodeData(NodeData nodeData) {
        super(nodeData);
        this.setCoor(nodeData.getCoor());
    }

    private boolean isLatLonKnown() {
        return this.lat != Double.NaN && this.lon != Double.NaN;
    }

    public LatLon getCoor() {
        return this.isLatLonKnown() ? new LatLon(this.lat, this.lon) : null;
    }

    public void setCoor(LatLon latLon) {
        if (latLon == null) {
            this.lat = Double.NaN;
            this.lon = Double.NaN;
        } else {
            this.lat = latLon.lat();
            this.lon = latLon.lon();
        }
    }

    public EastNorth getEastNorth() {
        return Projections.project(this.getCoor());
    }

    public void setEastNorth(EastNorth eastNorth) {
        LatLon latLon = Projections.inverseProject(eastNorth);
        this.setCoor(latLon);
    }

    public NodeData makeCopy() {
        return new NodeData(this);
    }

    public String toString() {
        return super.toString() + " NODE " + this.getCoor();
    }

    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    public void visit(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }
}

