/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaleCommand
extends TransformNodesCommand {
    private EastNorth pivot = this.getNodesCenter();
    private double scalingFactor;
    EastNorth startEN = null;

    public ScaleCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth) {
        super(collection);
        this.startEN = eastNorth;
        this.handleEvent(eastNorth);
    }

    @Override
    public void handleEvent(EastNorth eastNorth) {
        double d = Math.atan2(this.startEN.east() - this.pivot.east(), this.startEN.north() - this.pivot.north());
        double d2 = Math.atan2(eastNorth.east() - this.pivot.east(), eastNorth.north() - this.pivot.north());
        double d3 = this.pivot.distance(this.startEN);
        double d4 = this.pivot.distance(eastNorth);
        this.scalingFactor = Math.cos(d - d2) * d4 / d3;
        this.transformNodes();
    }

    @Override
    protected void transformNodes() {
        for (Node node : this.nodes) {
            EastNorth eastNorth = ((TransformNodesCommand.OldState)this.oldStates.get((Object)node)).eastNorth;
            double d = eastNorth.east() - this.pivot.east();
            double d2 = eastNorth.north() - this.pivot.north();
            double d3 = this.pivot.east() + this.scalingFactor * d;
            double d4 = this.pivot.north() + this.scalingFactor * d2;
            node.setEastNorth(new EastNorth(d3, d4));
        }
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.trn("Scale {0} node", "Scale {0} nodes", this.nodes.size(), this.nodes.size()), ImageProvider.get("data", "node"), 0);
    }
}

