/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DuplicateLayerAction
extends JosmAction {
    public DuplicateLayerAction() {
        super(I18n.tr("Duplicate Layer", new Object[0]), "dialogs/duplicatelayer", I18n.tr("Make a duplicate of the currently selected layer.", new Object[0]), Shortcut.registerShortcut("layer:duplicate", I18n.tr("Layer: {0}", I18n.tr("Duplicate", new Object[0])), 78, 0), true);
        this.putValue("help", HelpUtil.ht("/Action/DuplicateLayer"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        this.duplicate(osmDataLayer);
    }

    /*
     * WARNING - void declaration
     */
    public void duplicate(Layer layer) {
        if (Main.map == null || Main.map.mapView == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Layer object : Main.map.mapView.getAllLayers()) {
            arrayList.add(object.getName());
        }
        if (layer instanceof OsmDataLayer) {
            void var4_6;
            OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
            String string = I18n.tr("Copy of {0}", osmDataLayer.getName());
            int n = 2;
            while (arrayList.contains(var4_6)) {
                String string2 = I18n.tr("Copy {1} of {0}", osmDataLayer.getName(), n);
                ++n;
            }
            Main.main.addLayer(new OsmDataLayer(osmDataLayer.data.clone(), (String)var4_6, null));
        }
    }

    public static boolean canDuplicate(Layer layer) {
        return layer instanceof OsmDataLayer;
    }
}

