/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadAction
extends JosmAction {
    public DownloadAction() {
        super(I18n.tr("Download from OSM...", new Object[0]), "download", I18n.tr("Download map data from the OSM server.", new Object[0]), Shortcut.registerShortcut("file:download", I18n.tr("File: {0}", I18n.tr("Download from OSM...", new Object[0])), 68, 8), true);
        this.putValue("help", HelpUtil.ht("/Action/Download"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DownloadDialog downloadDialog = DownloadDialog.getInstance();
        downloadDialog.restoreSettings();
        downloadDialog.setVisible(true);
        if (!downloadDialog.isCanceled()) {
            Future<?> future;
            AbstractDownloadTask abstractDownloadTask;
            downloadDialog.rememberSettings();
            Bounds bounds = downloadDialog.getSelectedDownloadArea();
            if (downloadDialog.isDownloadOsmData()) {
                abstractDownloadTask = new DownloadOsmTask();
                future = ((DownloadOsmTask)abstractDownloadTask).download(downloadDialog.isNewLayerRequired(), bounds, null);
                Main.worker.submit(new PostDownloadHandler((DownloadTask)abstractDownloadTask, future));
            }
            if (downloadDialog.isDownloadGpxData()) {
                abstractDownloadTask = new DownloadGpsTask();
                future = ((DownloadGpsTask)abstractDownloadTask).download(downloadDialog.isNewLayerRequired(), bounds, null);
                Main.worker.submit(new PostDownloadHandler((DownloadTask)abstractDownloadTask, future));
            }
        }
    }
}

