/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.OAuthProviderListener;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.http.HttpRequest;
import oauth.signpost.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuthProvider
implements OAuthProvider {
    private static final long serialVersionUID = 1L;
    private String requestTokenEndpointUrl;
    private String accessTokenEndpointUrl;
    private String authorizationWebsiteUrl;
    private HttpParameters responseParameters;
    private Map<String, String> defaultHeaders;
    private boolean isOAuth10a;
    private transient OAuthProviderListener listener;

    public AbstractOAuthProvider(String string, String string2, String string3) {
        this.requestTokenEndpointUrl = string;
        this.accessTokenEndpointUrl = string2;
        this.authorizationWebsiteUrl = string3;
        this.responseParameters = new HttpParameters();
        this.defaultHeaders = new HashMap<String, String>();
    }

    @Override
    public String retrieveRequestToken(OAuthConsumer oAuthConsumer, String string) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        oAuthConsumer.setTokenWithSecret(null, null);
        this.retrieveToken(oAuthConsumer, this.requestTokenEndpointUrl, "oauth_callback", string);
        String string2 = this.responseParameters.getFirst("oauth_callback_confirmed");
        this.responseParameters.remove("oauth_callback_confirmed");
        this.isOAuth10a = Boolean.TRUE.toString().equals(string2);
        if (this.isOAuth10a) {
            return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", oAuthConsumer.getToken());
        }
        return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", oAuthConsumer.getToken(), "oauth_callback", string);
    }

    @Override
    public void retrieveAccessToken(OAuthConsumer oAuthConsumer, String string) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (oAuthConsumer.getToken() == null || oAuthConsumer.getTokenSecret() == null) {
            throw new OAuthExpectationFailedException("Authorized request token or token secret not set. Did you retrieve an authorized request token before?");
        }
        if (this.isOAuth10a && string != null) {
            this.retrieveToken(oAuthConsumer, this.accessTokenEndpointUrl, "oauth_verifier", string);
        } else {
            this.retrieveToken(oAuthConsumer, this.accessTokenEndpointUrl, new String[0]);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void retrieveToken(OAuthConsumer oAuthConsumer, String string, String ... stringArray) throws OAuthMessageSignerException, OAuthCommunicationException, OAuthNotAuthorizedException, OAuthExpectationFailedException {
        int n;
        HttpResponse httpResponse;
        HttpRequest httpRequest;
        block21: {
            Map<String, String> map = this.getRequestHeaders();
            if (oAuthConsumer.getConsumerKey() == null) throw new OAuthExpectationFailedException("Consumer key or secret not set");
            if (oAuthConsumer.getConsumerSecret() == null) {
                throw new OAuthExpectationFailedException("Consumer key or secret not set");
            }
            httpRequest = null;
            httpResponse = null;
            httpRequest = this.createRequest(string);
            for (String string2 : map.keySet()) {
                httpRequest.setHeader(string2, map.get(string2));
            }
            if (stringArray != null) {
                HttpParameters httpParameters = new HttpParameters();
                httpParameters.putAll(stringArray, true);
                oAuthConsumer.setAdditionalParameters(httpParameters);
            }
            if (this.listener != null) {
                this.listener.prepareRequest(httpRequest);
            }
            oAuthConsumer.sign(httpRequest);
            if (this.listener != null) {
                this.listener.prepareSubmission(httpRequest);
            }
            httpResponse = this.sendRequest(httpRequest);
            n = httpResponse.getStatusCode();
            boolean bl = false;
            if (this.listener != null) {
                bl = this.listener.onResponseReceived(httpRequest, httpResponse);
            }
            if (!bl) break block21;
            try {
                this.closeConnection(httpRequest, httpResponse);
                return;
            }
            catch (Exception exception) {
                throw new OAuthCommunicationException(exception);
            }
        }
        if (n >= 300) {
            this.handleUnexpectedResponse(n, httpResponse);
        }
        HttpParameters httpParameters = OAuth.decodeForm(httpResponse.getContent());
        String string3 = httpParameters.getFirst("oauth_token");
        String string4 = httpParameters.getFirst("oauth_token_secret");
        httpParameters.remove("oauth_token");
        httpParameters.remove("oauth_token_secret");
        this.setResponseParameters(httpParameters);
        if (string3 == null) throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
        if (string4 == null) {
            throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
        }
        oAuthConsumer.setTokenWithSecret(string3, string4);
        try {
            this.closeConnection(httpRequest, httpResponse);
            return;
        }
        catch (Exception exception) {
            throw new OAuthCommunicationException(exception);
        }
        catch (OAuthNotAuthorizedException oAuthNotAuthorizedException) {
            try {
                throw oAuthNotAuthorizedException;
                catch (OAuthExpectationFailedException oAuthExpectationFailedException) {
                    throw oAuthExpectationFailedException;
                }
                catch (Exception exception) {
                    throw new OAuthCommunicationException(exception);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeConnection(httpRequest, httpResponse);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new OAuthCommunicationException(exception);
                }
            }
        }
    }

    protected void handleUnexpectedResponse(int n, HttpResponse httpResponse) throws Exception {
        if (httpResponse == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getContent()));
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(string);
            string = bufferedReader.readLine();
        }
        switch (n) {
            case 401: {
                throw new OAuthNotAuthorizedException(stringBuilder.toString());
            }
        }
        throw new OAuthCommunicationException("Service provider responded in error: " + n + " (" + httpResponse.getReasonPhrase() + ")", stringBuilder.toString());
    }

    protected abstract HttpRequest createRequest(String var1) throws Exception;

    protected abstract HttpResponse sendRequest(HttpRequest var1) throws Exception;

    protected void closeConnection(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
    }

    @Override
    public HttpParameters getResponseParameters() {
        return this.responseParameters;
    }

    protected String getResponseParameter(String string) {
        return this.responseParameters.getFirst(string);
    }

    @Override
    public void setResponseParameters(HttpParameters httpParameters) {
        this.responseParameters = httpParameters;
    }

    @Override
    public void setOAuth10a(boolean bl) {
        this.isOAuth10a = bl;
    }

    @Override
    public boolean isOAuth10a() {
        return this.isOAuth10a;
    }

    @Override
    public String getRequestTokenEndpointUrl() {
        return this.requestTokenEndpointUrl;
    }

    @Override
    public String getAccessTokenEndpointUrl() {
        return this.accessTokenEndpointUrl;
    }

    @Override
    public String getAuthorizationWebsiteUrl() {
        return this.authorizationWebsiteUrl;
    }

    @Override
    public void setRequestHeader(String string, String string2) {
        this.defaultHeaders.put(string, string2);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.defaultHeaders;
    }

    @Override
    public void setListener(OAuthProviderListener oAuthProviderListener) {
        this.listener = oAuthProviderListener;
    }

    @Override
    public void removeListener(OAuthProviderListener oAuthProviderListener) {
        this.listener = null;
    }
}

