/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;

public class RemoteControlHttpServer
extends Thread {
    public static final int DEFAULT_PORT = 8111;
    private ServerSocket server;
    private static RemoteControlHttpServer instance;

    public static void restartRemoteControlHttpServer() {
        try {
            if (instance != null) {
                instance.stopServer();
            }
            int n = 8111;
            instance = new RemoteControlHttpServer(n);
            instance.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public RemoteControlHttpServer(int n) throws IOException {
        super("RemoteControl HTTP Server");
        this.setDaemon(true);
        this.server = new ServerSocket(n, 1, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
    }

    public void run() {
        System.out.println("RemoteControl::Accepting connections on port " + this.server.getLocalPort());
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    RequestProcessor.processRequest(socket);
                }
            }
            catch (SocketException socketException) {
                if (this.server.isClosed()) continue;
                socketException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void stopServer() throws IOException {
        this.server.close();
    }
}

