/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmIdTextField
extends JTextField {
    private OsmIdValidator validator = OsmIdValidator.decorate(this);

    public void setType(OsmPrimitiveType osmPrimitiveType) {
        this.validator.type = osmPrimitiveType;
    }

    public long getOsmId() {
        return this.validator.getOsmId();
    }

    public List<PrimitiveId> getIds() {
        return this.validator.ids;
    }

    public boolean readOsmIds() {
        return this.validator.readOsmIds();
    }

    private static class OsmIdValidator
    extends AbstractTextComponentValidator {
        private List<PrimitiveId> ids = new ArrayList<PrimitiveId>();
        private OsmPrimitiveType type;

        public static OsmIdValidator decorate(JTextComponent jTextComponent) {
            return new OsmIdValidator(jTextComponent);
        }

        public OsmIdValidator(JTextComponent jTextComponent) {
            super(jTextComponent, false);
        }

        public boolean isValid() {
            return this.getOsmId() > 0L || this.readOsmIds();
        }

        public void validate() {
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid OSM ID. Please enter an integer value > 0"));
            } else {
                this.feedbackValid(I18n.tr("Please enter an integer value > 0"));
            }
        }

        public long getOsmId() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().length() == 0) {
                return 0L;
            }
            try {
                long l = Long.parseLong(string.trim());
                if (l > 0L) {
                    return l;
                }
                return 0L;
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }

        public boolean readOsmIds() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            try {
                this.ids.clear();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",.+/ \t\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    char c = string2.charAt(0);
                    if (c == 'v') continue;
                    if (c == 'n') {
                        this.ids.add(new SimplePrimitiveId(Long.parseLong(string2.substring(1)), OsmPrimitiveType.NODE));
                        continue;
                    }
                    if (c == 'w') {
                        this.ids.add(new SimplePrimitiveId(Long.parseLong(string2.substring(1)), OsmPrimitiveType.WAY));
                        continue;
                    }
                    if (c == 'r') {
                        this.ids.add(new SimplePrimitiveId(Long.parseLong(string2.substring(1)), OsmPrimitiveType.RELATION));
                        continue;
                    }
                    if (this.type == OsmPrimitiveType.NODE) {
                        this.ids.add(new SimplePrimitiveId(Long.parseLong(string2), OsmPrimitiveType.NODE));
                        continue;
                    }
                    if (this.type == OsmPrimitiveType.WAY) {
                        this.ids.add(new SimplePrimitiveId(Long.parseLong(string2), OsmPrimitiveType.WAY));
                        continue;
                    }
                    if (this.type != OsmPrimitiveType.RELATION) continue;
                    this.ids.add(new SimplePrimitiveId(Long.parseLong(string2), OsmPrimitiveType.RELATION));
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }
}

