/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.I18n;

public class TagCellRenderer
extends JLabel
implements TableCellRenderer {
    private Font fontStandard = UIManager.getFont("Table.font");
    private Font fontItalic = this.fontStandard.deriveFont(2);

    public TagCellRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void renderTagName(TagModel tagModel) {
        this.setText(tagModel.getName());
    }

    protected void renderTagValue(TagModel tagModel) {
        if (tagModel.getValueCount() == 0) {
            this.setText("");
        } else if (tagModel.getValueCount() == 1) {
            this.setText(tagModel.getValues().get(0));
        } else if (tagModel.getValueCount() > 1) {
            this.setText(I18n.tr("multiple"));
            this.setFont(this.fontItalic);
        }
    }

    protected void resetRenderer() {
        this.setText("");
        this.setIcon(null);
        this.setFont(this.fontStandard);
    }

    protected TagEditorModel getModel(JTable jTable) {
        return (TagEditorModel)jTable.getModel();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.resetRenderer();
        if (object == null) {
            return this;
        }
        if (bl) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
        switch (n2) {
            case 0: {
                this.renderTagName((TagModel)object);
                break;
            }
            case 1: {
                this.renderTagValue((TagModel)object);
                break;
            }
            default: {
                throw new RuntimeException("unexpected index in switch statement");
            }
        }
        if (bl2 && bl && jTable.getSelectedColumnCount() == 1 && jTable.getSelectedRowCount() == 1 && jTable.getEditorComponent() != null) {
            jTable.getEditorComponent().requestFocusInWindow();
        }
        return this;
    }
}

