/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AccessTokenInfoPanel;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationClient;
import org.openstreetmap.josm.gui.oauth.RetrieveAccessTokenTask;
import org.openstreetmap.josm.gui.oauth.RetrieveRequestTokenTask;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class SemiAutomaticAuthorizationUI
extends AbstractAuthorizationUI {
    private AccessTokenInfoPanel pnlAccessTokenInfo;
    private OAuthToken requestToken;
    private RetrieveRequestTokenPanel pnlRetrieveRequestToken;
    private RetrieveAccessTokenPanel pnlRetrieveAccessToken;
    private ShowAccessTokenPanel pnlShowAccessToken;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlRetrieveRequestToken = new RetrieveRequestTokenPanel();
        this.pnlRetrieveAccessToken = new RetrieveAccessTokenPanel();
        this.pnlShowAccessToken = new ShowAccessTokenPanel();
        this.add((Component)this.pnlRetrieveRequestToken, "Center");
    }

    public SemiAutomaticAuthorizationUI() {
        this.build();
    }

    public boolean isSaveAccessTokenToPreferences() {
        return this.pnlAccessTokenInfo.isSaveToPreferences();
    }

    protected void transitionToRetrieveAccessToken() {
        OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = new OsmOAuthAuthorizationClient(this.getAdvancedPropertiesPanel().getAdvancedParameters());
        String string = osmOAuthAuthorizationClient.getAuthoriseUrl(this.requestToken);
        OpenBrowser.displayUrl(string);
        this.removeAll();
        this.pnlRetrieveAccessToken.setAuthoriseUrl(string);
        this.add((Component)this.pnlRetrieveAccessToken, "Center");
        this.pnlRetrieveAccessToken.invalidate();
        this.validate();
        this.repaint();
    }

    protected void transitionToRetrieveRequestToken() {
        this.requestToken = null;
        this.setAccessToken(null);
        this.removeAll();
        this.add((Component)this.pnlRetrieveRequestToken, "Center");
        this.pnlRetrieveRequestToken.invalidate();
        this.validate();
        this.repaint();
    }

    protected void transitionToShowAccessToken() {
        this.removeAll();
        this.add((Component)this.pnlShowAccessToken, "Center");
        this.pnlShowAccessToken.invalidate();
        this.validate();
        this.repaint();
        this.pnlShowAccessToken.setAccessToken(this.getAccessToken());
    }

    class TestAccessTokenAction
    extends AbstractAction {
        public TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to test the Access Token"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TestAccessTokenTask testAccessTokenTask = new TestAccessTokenTask(SemiAutomaticAuthorizationUI.this, SemiAutomaticAuthorizationUI.this.getApiUrl(), SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), SemiAutomaticAuthorizationUI.this.getAccessToken());
            Main.worker.submit(testAccessTokenTask);
        }
    }

    class RetrieveAccessTokenAction
    extends AbstractAction {
        public RetrieveAccessTokenAction() {
            this.putValue("Name", I18n.tr("Retrieve Access Token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to retrieve an Access Token"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final RetrieveAccessTokenTask retrieveAccessTokenTask = new RetrieveAccessTokenTask((Component)SemiAutomaticAuthorizationUI.this, SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters(), SemiAutomaticAuthorizationUI.this.requestToken);
            Main.worker.submit(retrieveAccessTokenTask);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (retrieveAccessTokenTask.isCanceled()) {
                        return;
                    }
                    if (retrieveAccessTokenTask.getAccessToken() == null) {
                        return;
                    }
                    SemiAutomaticAuthorizationUI.this.setAccessToken(retrieveAccessTokenTask.getAccessToken());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SemiAutomaticAuthorizationUI.this.transitionToShowAccessToken();
                        }
                    });
                }
            };
            Main.worker.submit(runnable);
        }
    }

    class RetrieveRequestTokenAction
    extends AbstractAction {
        public RetrieveRequestTokenAction() {
            this.putValue("Name", I18n.tr("Retrieve Request Token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
            this.putValue("ShortDescription", I18n.tr("Click to retrieve a Request Token"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final RetrieveRequestTokenTask retrieveRequestTokenTask = new RetrieveRequestTokenTask(SemiAutomaticAuthorizationUI.this, SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters());
            Main.worker.submit(retrieveRequestTokenTask);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (retrieveRequestTokenTask.isCanceled()) {
                        return;
                    }
                    if (retrieveRequestTokenTask.getRequestToken() == null) {
                        return;
                    }
                    SemiAutomaticAuthorizationUI.this.requestToken = retrieveRequestTokenTask.getRequestToken();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SemiAutomaticAuthorizationUI.this.transitionToRetrieveAccessToken();
                        }
                    });
                }
            };
            Main.worker.submit(runnable);
        }
    }

    class ShowAccessTokenPanel
    extends JPanel {
        protected JPanel buildTitlePanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(I18n.tr("<html>Step 3/3: Successfully retrieved an Access Token</html>"));
            jLabel.setFont(jLabel.getFont().deriveFont(16.0f));
            jPanel.add((Component)jLabel, "Center");
            return jPanel;
        }

        protected JPanel buildContentPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(I18n.tr("<html>JOSM has successfully retrieved an Access Token. You can now accept this token. JOSM will use it in the future for authentication and authorization to the OSM server.<br><br>The access token is: </html>"));
            jPanel.add((Component)htmlPanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)(SemiAutomaticAuthorizationUI.this.pnlAccessTokenInfo = new AccessTokenInfoPanel()), gridBagConstraints);
            SemiAutomaticAuthorizationUI.this.pnlAccessTokenInfo.setSaveToPreferences(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
            return jPanel;
        }

        protected JPanel buildActionPanel() {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new SideButton(new RestartAction()));
            jPanel.add(new SideButton(new TestAccessTokenAction()));
            return jPanel;
        }

        protected void build() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.buildTitlePanel(), "North");
            this.add((Component)this.buildContentPanel(), "Center");
            this.add((Component)this.buildActionPanel(), "South");
        }

        public ShowAccessTokenPanel() {
            this.build();
        }

        public void setAccessToken(OAuthToken oAuthToken) {
            SemiAutomaticAuthorizationUI.this.pnlAccessTokenInfo.setAccessToken(oAuthToken);
        }

        class RestartAction
        extends AbstractAction {
            public RestartAction() {
                this.putValue("Name", I18n.tr("Restart"));
                this.putValue("ShortDescription", I18n.tr("Go back to step 1/3"));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "previous"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SemiAutomaticAuthorizationUI.this.transitionToRetrieveRequestToken();
            }
        }
    }

    private class RetrieveAccessTokenPanel
    extends JPanel {
        private JTextField tfAuthoriseUrl;

        protected JPanel buildTitlePanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(I18n.tr("<html>Step 2/3: Authorize and retrieve an Access Token</html>"));
            jLabel.setFont(jLabel.getFont().deriveFont(16.0f));
            jPanel.add((Component)jLabel, "Center");
            return jPanel;
        }

        protected JPanel buildContentPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(I18n.tr("<html>JOSM successfully retrieved a Request Token. JOSM is now launching an authorization page in an external browser. Please login with your OSM username and password and follow the instructions to authorize the Request Token. Then switch back to this dialog and click on <strong>{0}</strong><br><br>If launching the external browser fails you can copy the following authorize URL and paste it into the address field of your browser.</html>", I18n.tr("Request Access Token")));
            jPanel.add((Component)htmlPanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)new JLabel(I18n.tr("Authorize URL:")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.tfAuthoriseUrl = new JTextField();
            jPanel.add((Component)this.tfAuthoriseUrl, gridBagConstraints);
            this.tfAuthoriseUrl.setEditable(false);
            return jPanel;
        }

        protected JPanel buildActionPanel() {
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new SideButton(new BackAction()));
            jPanel.add(new SideButton(new RetrieveAccessTokenAction()));
            return jPanel;
        }

        protected void build() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.buildTitlePanel(), "North");
            this.add((Component)this.buildContentPanel(), "Center");
            this.add((Component)this.buildActionPanel(), "South");
        }

        public RetrieveAccessTokenPanel() {
            this.build();
        }

        public void setAuthoriseUrl(String string) {
            this.tfAuthoriseUrl.setText(string);
        }

        class BackAction
        extends AbstractAction {
            public BackAction() {
                this.putValue("Name", I18n.tr("Back"));
                this.putValue("ShortDescription", I18n.tr("Go back to step 1/3"));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "previous"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SemiAutomaticAuthorizationUI.this.transitionToRetrieveRequestToken();
            }
        }
    }

    private class RetrieveRequestTokenPanel
    extends JPanel {
        private JCheckBox cbShowAdvancedParameters;

        protected JPanel buildAdvancedParametersPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            this.cbShowAdvancedParameters = new JCheckBox();
            jPanel.add((Component)this.cbShowAdvancedParameters, gridBagConstraints);
            this.cbShowAdvancedParameters.setSelected(false);
            this.cbShowAdvancedParameters.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().setVisible(itemEvent.getStateChange() == 1);
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("Display Advanced OAuth Parameters"));
            jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
            jPanel.add((Component)jMultilineLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(3, 0, 3, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel(), gridBagConstraints);
            SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().setVisible(false);
            return jPanel;
        }

        protected JPanel buildCommandPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(I18n.tr("<html>Please click on <strong>{0}</strong> to retrieve an OAuth Request Token from ''{1}''.</html>", I18n.tr("Retrieve Request Token"), SemiAutomaticAuthorizationUI.this.getAdvancedPropertiesPanel().getAdvancedParameters().getRequestTokenUrl()));
            jPanel.add((Component)htmlPanel, gridBagConstraints);
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            jPanel2.add(new SideButton(new RetrieveRequestTokenAction()));
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)jPanel2, gridBagConstraints);
            return jPanel;
        }

        protected void build() {
            this.setLayout(new BorderLayout(0, 5));
            JLabel jLabel = new JLabel(I18n.tr("<html>Step 1/3: Retrieve an OAuth Request Token</html>"));
            jLabel.setFont(jLabel.getFont().deriveFont(16.0f));
            this.add((Component)jLabel, "North");
            this.add((Component)this.buildAdvancedParametersPanel(), "Center");
            this.add((Component)this.buildCommandPanel(), "South");
        }

        public RetrieveRequestTokenPanel() {
            this.build();
        }
    }
}

