/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public interface Expression {
    public Object evaluate(Environment var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionExpression
    implements Expression {
        String name;
        List<Expression> args;

        public FunctionExpression(String string, List<Expression> list) {
            this.name = string;
            this.args = list;
        }

        @Override
        public Object evaluate(Environment environment) {
            if (Utils.equal(this.name, "cond")) {
                if (this.args.size() != 3) {
                    return null;
                }
                Boolean bl = Cascade.convertTo(this.args.get(0).evaluate(environment), Boolean.TYPE);
                if (bl == null) {
                    return null;
                }
                return this.args.get(bl != false ? 1 : 2).evaluate(environment);
            }
            if (Utils.equal(this.name, "and")) {
                for (Expression expression : this.args) {
                    Boolean bl = Cascade.convertTo(expression.evaluate(environment), Boolean.TYPE);
                    if (bl != null && bl.booleanValue()) continue;
                    return false;
                }
                return true;
            }
            if (Utils.equal(this.name, "or")) {
                for (Expression expression : this.args) {
                    Boolean bl = Cascade.convertTo(expression.evaluate(environment), Boolean.TYPE);
                    if (bl == null || !bl.booleanValue()) continue;
                    return true;
                }
                return false;
            }
            EvalFunctions evalFunctions = new EvalFunctions();
            evalFunctions.env = environment;
            Method[] methodArray = EvalFunctions.class.getDeclaredMethods();
            ArrayList<Method> arrayList = new ArrayList<Method>();
            arrayList.addAll(Arrays.asList(methodArray));
            try {
                arrayList.add(Math.class.getMethod("abs", Float.TYPE));
                arrayList.add(Math.class.getMethod("acos", Double.TYPE));
                arrayList.add(Math.class.getMethod("asin", Double.TYPE));
                arrayList.add(Math.class.getMethod("atan", Double.TYPE));
                arrayList.add(Math.class.getMethod("atan2", Double.TYPE, Double.TYPE));
                arrayList.add(Math.class.getMethod("ceil", Double.TYPE));
                arrayList.add(Math.class.getMethod("cos", Double.TYPE));
                arrayList.add(Math.class.getMethod("cosh", Double.TYPE));
                arrayList.add(Math.class.getMethod("exp", Double.TYPE));
                arrayList.add(Math.class.getMethod("floor", Double.TYPE));
                arrayList.add(Math.class.getMethod("log", Double.TYPE));
                arrayList.add(Math.class.getMethod("max", Float.TYPE, Float.TYPE));
                arrayList.add(Math.class.getMethod("min", Float.TYPE, Float.TYPE));
                arrayList.add(Math.class.getMethod("random", new Class[0]));
                arrayList.add(Math.class.getMethod("round", Float.TYPE));
                arrayList.add(Math.class.getMethod("signum", Double.TYPE));
                arrayList.add(Math.class.getMethod("sin", Double.TYPE));
                arrayList.add(Math.class.getMethod("sinh", Double.TYPE));
                arrayList.add(Math.class.getMethod("sqrt", Double.TYPE));
                arrayList.add(Math.class.getMethod("tan", Double.TYPE));
                arrayList.add(Math.class.getMethod("tanh", Double.TYPE));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
            for (Method method : arrayList) {
                Object object;
                if (!method.getName().equals(this.name)) continue;
                Class<?>[] classArray = method.getParameterTypes();
                Object[] objectArray = new Object[classArray.length];
                if (classArray.length == 1 && classArray[0].isArray()) {
                    object = classArray[0].getComponentType();
                    Object object2 = Array.newInstance(object, this.args.size());
                    for (int i = 0; i < this.args.size(); ++i) {
                        Object t = Cascade.convertTo(this.args.get(i).evaluate(environment), object);
                        if (t == null) {
                            return null;
                        }
                        Array.set(object2, i, t);
                    }
                    objectArray[0] = object2;
                } else {
                    if (this.args.size() != classArray.length) continue;
                    for (int i = 0; i < this.args.size(); ++i) {
                        objectArray[i] = Cascade.convertTo(this.args.get(i).evaluate(environment), classArray[i]);
                        if (objectArray[i] != null) continue;
                        return null;
                    }
                }
                object = null;
                try {
                    object = method.invoke((Object)evalFunctions, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(invocationTargetException);
                    return null;
                }
                return object;
            }
            return null;
        }

        public String toString() {
            return this.name + "(" + Utils.join(", ", this.args) + ")";
        }

        public static class EvalFunctions {
            Environment env;

            public Object eval(Object object) {
                return object;
            }

            public static float plus(float ... fArray) {
                float f = 0.0f;
                for (float f2 : fArray) {
                    f += f2;
                }
                return f;
            }

            public Float minus(float ... fArray) {
                if (fArray.length == 0) {
                    return Float.valueOf(0.0f);
                }
                if (fArray.length == 1) {
                    return Float.valueOf(-fArray[0]);
                }
                float f = fArray[0];
                for (int i = 1; i < fArray.length; ++i) {
                    f -= fArray[i];
                }
                return Float.valueOf(f);
            }

            public static float times(float ... fArray) {
                float f = 1.0f;
                for (float f2 : fArray) {
                    f *= f2;
                }
                return f;
            }

            public Float devided_by(float ... fArray) {
                if (fArray.length == 0) {
                    return Float.valueOf(1.0f);
                }
                float f = fArray[0];
                for (int i = 1; i < fArray.length; ++i) {
                    if (fArray[i] == 0.0f) {
                        return null;
                    }
                    f /= fArray[i];
                }
                return Float.valueOf(f);
            }

            public static List list(Object ... objectArray) {
                return Arrays.asList(objectArray);
            }

            public Color rgb(float f, float f2, float f3) {
                Color color = null;
                try {
                    color = new Color(f, f2, f3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                return color;
            }

            public float red(Color color) {
                return Utils.color_int2float(color.getRed()).floatValue();
            }

            public float green(Color color) {
                return Utils.color_int2float(color.getGreen()).floatValue();
            }

            public float blue(Color color) {
                return Utils.color_int2float(color.getBlue()).floatValue();
            }

            public String concat(Object ... objectArray) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object : objectArray) {
                    stringBuilder.append(object.toString());
                }
                return stringBuilder.toString();
            }

            public Object prop(String string) {
                return this.prop(string, null);
            }

            public Object prop(String string, String string2) {
                Cascade cascade = string2 == null ? this.env.mc.getCascade(this.env.layer) : this.env.mc.getCascade(string2);
                return cascade.get(string);
            }

            public Boolean is_prop_set(String string) {
                return this.is_prop_set(string, null);
            }

            public Boolean is_prop_set(String string, String string2) {
                Cascade cascade = string2 == null ? this.env.mc.getCascade(this.env.layer) : this.env.mc.getCascade(string2);
                return cascade.containsKey(string);
            }

            public String tag(String string) {
                return this.env.osm.get(string);
            }

            public String parent_tag(String string) {
                if (this.env.parent == null) {
                    for (OsmPrimitive osmPrimitive : this.env.osm.getReferrers()) {
                        String string2 = osmPrimitive.get(string);
                        if (string2 == null) continue;
                        return string2;
                    }
                    return null;
                }
                return this.env.parent.get(string);
            }

            public boolean has_tag_key(String string) {
                return this.env.osm.hasKey(string);
            }

            public Float index() {
                if (this.env.index == null) {
                    return null;
                }
                return new Float(this.env.index + 1);
            }

            public String role() {
                return this.env.getRole();
            }

            public boolean not(boolean bl) {
                return !bl;
            }

            public boolean greater_equal(float f, float f2) {
                return f >= f2;
            }

            public boolean less_equal(float f, float f2) {
                return f <= f2;
            }

            public boolean greater(float f, float f2) {
                return f > f2;
            }

            public boolean less(float f, float f2) {
                return f < f2;
            }

            public int length(String string) {
                return string.length();
            }

            public boolean equal(Object object, Object object2) {
                for (Class clazz : new Class[]{Float.class, Boolean.class, Color.class, float[].class, String.class}) {
                    Object t = Cascade.convertTo(object, clazz);
                    Object t2 = Cascade.convertTo(object2, clazz);
                    if (t == null || t2 == null || !t.equals(t2)) continue;
                    return true;
                }
                return false;
            }

            public Boolean JOSM_search(String string) {
                SearchCompiler.Match match;
                try {
                    match = SearchCompiler.compile(string, false, false);
                }
                catch (SearchCompiler.ParseError parseError) {
                    return null;
                }
                return match.match(this.env.osm);
            }

            public String JOSM_pref(String string, String string2) {
                String string3 = Main.pref.get(string, null);
                return string3 != null ? string3 : string2;
            }

            public Color JOSM_pref_color(String string, Color color) {
                Color color2 = Main.pref.getColor(string, null);
                return color2 != null ? color2 : color;
            }
        }
    }

    public static class LiteralExpression
    implements Expression {
        Object literal;

        public LiteralExpression(Object object) {
            CheckParameterUtil.ensureParameterNotNull(object);
            this.literal = object;
        }

        public Object evaluate(Environment environment) {
            return this.literal;
        }

        public String toString() {
            if (this.literal instanceof float[]) {
                return Arrays.toString((float[])this.literal);
            }
            return "<" + this.literal.toString() + ">";
        }
    }
}

