/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;

public class LinePatternElemStyle
extends ElemStyle {
    public ImageIcon pattern;

    public LinePatternElemStyle(Cascade cascade, ImageIcon imageIcon) {
        super(cascade, -1.0f);
        this.pattern = imageIcon;
    }

    public static LinePatternElemStyle create(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapPaintStyles.IconReference iconReference = cascade.get("pattern-image", null, MapPaintStyles.IconReference.class);
        if (iconReference == null) {
            return null;
        }
        ImageIcon imageIcon = MapPaintStyles.getIcon(iconReference, -1, -1, false);
        if (imageIcon == null) {
            return null;
        }
        return new LinePatternElemStyle(cascade, imageIcon);
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        Way way = (Way)osmPrimitive;
        mapPainter.drawLinePattern(way, this.pattern);
    }

    public boolean isProperLineStyle() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LinePatternElemStyle linePatternElemStyle = (LinePatternElemStyle)object;
        return this.pattern.getImage() == linePatternElemStyle.pattern.getImage();
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String toString() {
        return "LinePatternElemStyle{" + super.toString() + "pattern=" + this.pattern + '}';
    }
}

