/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.JpegFileFilter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PrimaryDateParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelateGpxWithImages
extends AbstractAction {
    private static List<GpxData> loadedGpxData = new ArrayList<GpxData>();
    GeoImageLayer yLayer = null;
    double timezone;
    long delta;
    ExtendedDialog syncDialog;
    Vector<GpxDataWrapper> gpxLst = new Vector();
    JPanel outerPanel;
    JComboBox cbGpx;
    JTextField tfTimezone;
    JTextField tfOffset;
    JCheckBox cbExifImg;
    JCheckBox cbTaggedImg;
    JCheckBox cbShowThumbs;
    JLabel statusBarText;
    int lastNumMatched = 0;
    StatusBarUpdater statusBarUpdater = new StatusBarUpdater(false);
    StatusBarUpdater statusBarUpdaterWithRepaint = new StatusBarUpdater(true);
    RepaintTheMapListener repaintTheMap = new RepaintTheMapListener();

    public CorrelateGpxWithImages(GeoImageLayer geoImageLayer) {
        super(I18n.tr("Correlate to GPX"), ImageProvider.get("dialogs/geoimage/gpx2img"));
        this.yLayer = geoImageLayer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Collection<Layer> collection = Main.map.mapView.getAllLayers();
        GpxDataWrapper gpxDataWrapper = null;
        for (Layer object32 : collection) {
            if (!(object32 instanceof GpxLayer)) continue;
            GpxLayer gpxLayer = (GpxLayer)object32;
            object = new GpxDataWrapper(gpxLayer.getName(), gpxLayer.data, gpxLayer.data.storageFile);
            this.gpxLst.add((GpxDataWrapper)object);
            if (object32 != this.yLayer.gpxLayer) continue;
            gpxDataWrapper = object;
        }
        for (GpxData gpxData : loadedGpxData) {
            this.gpxLst.add(new GpxDataWrapper(gpxData.storageFile.getName(), gpxData, gpxData.storageFile));
        }
        if (this.gpxLst.size() == 0) {
            this.gpxLst.add(new GpxDataWrapper(I18n.tr("<No GPX track loaded yet>"), null, null));
        }
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(I18n.tr("GPX track: ")));
        this.cbGpx = new JComboBox<GpxDataWrapper>(this.gpxLst);
        if (gpxDataWrapper != null) {
            this.cbGpx.setSelectedItem(gpxDataWrapper);
        }
        this.cbGpx.addActionListener(this.statusBarUpdaterWithRepaint);
        jPanel.add(this.cbGpx);
        JButton jButton = new JButton(I18n.tr("Open another GPX trace"));
        jButton.addActionListener(new LoadGpxDataActionListener());
        jPanel.add(jButton);
        object = new JPanel();
        ((Container)object).setLayout(new GridBagLayout());
        String string = Main.pref.get("geoimage.timezone", "0:00");
        if (string == null) {
            string = "0:00";
        }
        try {
            this.timezone = this.parseTimezone(string);
        }
        catch (ParseException parseException) {
            this.timezone = 0.0;
        }
        this.tfTimezone = new JTextField(10);
        this.tfTimezone.setText(this.formatTimezone(this.timezone));
        try {
            this.delta = this.parseOffset(Main.pref.get("geoimage.delta", "0"));
        }
        catch (ParseException parseException) {
            this.delta = 0L;
        }
        this.delta /= 1000L;
        this.tfOffset = new JTextField(10);
        this.tfOffset.setText(Long.toString(this.delta));
        JButton jButton2 = new JButton(I18n.tr("<html>Use photo of an accurate clock,<br>e.g. GPS receiver display</html>"));
        jButton2.setIcon(ImageProvider.get("clock"));
        jButton2.addActionListener(new SetOffsetActionListener());
        JButton jButton3 = new JButton(I18n.tr("Auto-Guess"));
        jButton3.setToolTipText(I18n.tr("Matches first photo with first gpx point"));
        jButton3.addActionListener(new AutoGuessActionListener());
        JButton jButton4 = new JButton(I18n.tr("Manual adjust"));
        jButton4.addActionListener(new AdjustActionListener());
        JLabel jLabel = new JLabel(I18n.tr("Override position for: "));
        int n = this.getSortedImgList(true, true).size();
        int n2 = n - this.getSortedImgList(false, true).size();
        int n3 = n - this.getSortedImgList(true, false).size();
        this.cbExifImg = new JCheckBox(I18n.tr("Images with geo location in exif data ({0}/{1})", n2, n));
        this.cbExifImg.setEnabled(n2 != 0);
        this.cbTaggedImg = new JCheckBox(I18n.tr("Images that are already tagged ({0}/{1})", n3, n), true);
        this.cbTaggedImg.setEnabled(n3 != 0);
        jLabel.setEnabled(this.cbExifImg.isEnabled() || this.cbTaggedImg.isEnabled());
        boolean bl = this.yLayer.thumbsLoaded || Main.pref.getBoolean("geoimage.showThumbs", false);
        this.cbShowThumbs = new JCheckBox(I18n.tr("Show Thumbnail images on the map"), bl);
        this.cbShowThumbs.setEnabled(!this.yLayer.thumbsLoaded);
        int n4 = 0;
        GBC gBC = GBC.eol();
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object).add((Component)jPanel, gBC);
        gBC = GBC.eol().fill(2).insets(0, 0, 0, 12);
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object).add((Component)new JSeparator(0), gBC);
        gBC = GBC.std();
        gBC.gridx = 0;
        gBC.gridy = n4;
        ((Container)object).add((Component)new JLabel(I18n.tr("Timezone: ")), gBC);
        gBC = GBC.std().fill(2);
        gBC.gridx = 1;
        gBC.gridy = n4++;
        gBC.weightx = 1.0;
        ((Container)object).add((Component)this.tfTimezone, gBC);
        gBC = GBC.std();
        gBC.gridx = 0;
        gBC.gridy = n4;
        ((Container)object).add((Component)new JLabel(I18n.tr("Offset:")), gBC);
        gBC = GBC.std().fill(2);
        gBC.gridx = 1;
        gBC.gridy = n4++;
        gBC.weightx = 1.0;
        ((Container)object).add((Component)this.tfOffset, gBC);
        gBC = GBC.std().insets(5, 5, 5, 5);
        gBC.gridx = 2;
        gBC.gridy = n4 - 2;
        gBC.gridheight = 2;
        gBC.gridwidth = 2;
        gBC.fill = 1;
        gBC.weightx = 0.5;
        ((Container)object).add((Component)jButton2, gBC);
        gBC = GBC.std().fill(1).insets(5, 5, 5, 5);
        gBC.gridx = 2;
        gBC.gridy = n4++;
        gBC.weightx = 0.5;
        ((Container)object).add((Component)jButton3, gBC);
        gBC.gridx = 3;
        ((Container)object).add((Component)jButton4, gBC);
        gBC = GBC.eol().fill(2).insets(0, 12, 0, 0);
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object).add((Component)new JSeparator(0), gBC);
        gBC = GBC.eol();
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object).add((Component)jLabel, gBC);
        gBC = GBC.eol();
        gBC.gridx = 1;
        gBC.gridy = n4++;
        ((Container)object).add((Component)this.cbExifImg, gBC);
        gBC = GBC.eol();
        gBC.gridx = 1;
        gBC.gridy = n4++;
        ((Container)object).add((Component)this.cbTaggedImg, gBC);
        gBC = GBC.eol();
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object).add((Component)this.cbShowThumbs, gBC);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBarText = new JLabel(" ");
        this.statusBarText.setFont(this.statusBarText.getFont().deriveFont(8));
        jPanel2.add(this.statusBarText);
        this.tfTimezone.addFocusListener(this.repaintTheMap);
        this.tfOffset.addFocusListener(this.repaintTheMap);
        this.tfTimezone.getDocument().addDocumentListener(this.statusBarUpdater);
        this.tfOffset.getDocument().addDocumentListener(this.statusBarUpdater);
        this.cbExifImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.cbTaggedImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.statusBarUpdater.updateStatusBar();
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout());
        this.outerPanel.add((Component)jPanel2, "Last");
        this.syncDialog = new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track"), new String[]{I18n.tr("Correlate"), I18n.tr("Cancel")}, false);
        this.syncDialog.setContent((Component)object, false);
        this.syncDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.syncDialog.setupDialog();
        this.outerPanel.add((Component)this.syncDialog.getContentPane(), "First");
        this.syncDialog.setContentPane(this.outerPanel);
        this.syncDialog.pack();
        this.syncDialog.addWindowListener(new WindowAdapter(){
            static final int CANCEL = -1;
            static final int DONE = 0;
            static final int AGAIN = 1;
            static final int NOTHING = 2;

            private int checkAndSave() {
                if (CorrelateGpxWithImages.this.syncDialog.isVisible()) {
                    return 2;
                }
                int n = CorrelateGpxWithImages.this.syncDialog.getValue();
                if (n != 1) {
                    return -1;
                }
                try {
                    CorrelateGpxWithImages.this.timezone = CorrelateGpxWithImages.this.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(Main.parent, parseException.getMessage(), I18n.tr("Invalid timezone"), 0);
                    return 1;
                }
                try {
                    CorrelateGpxWithImages.this.delta = CorrelateGpxWithImages.this.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(Main.parent, parseException.getMessage(), I18n.tr("Invalid offset"), 0);
                    return 1;
                }
                if (CorrelateGpxWithImages.this.lastNumMatched == 0 && new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track"), new String[]{I18n.tr("OK"), I18n.tr("Try Again")}).setContent(I18n.tr("No images could be matched!")).setButtonIcons(new String[]{"ok.png", "dialogs/refresh.png"}).showDialog().getValue() == 2) {
                    return 1;
                }
                return 0;
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                int n = this.checkAndSave();
                switch (n) {
                    case 2: {
                        break;
                    }
                    case -1: {
                        for (ImageEntry imageEntry : CorrelateGpxWithImages.this.yLayer.data) {
                            imageEntry.tmp = null;
                        }
                        CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                        break;
                    }
                    case 1: {
                        CorrelateGpxWithImages.this.actionPerformed(null);
                        break;
                    }
                    case 0: {
                        Main.pref.put("geoimage.timezone", CorrelateGpxWithImages.this.formatTimezone(CorrelateGpxWithImages.this.timezone));
                        Main.pref.put("geoimage.delta", Long.toString(CorrelateGpxWithImages.this.delta * 1000L));
                        Main.pref.put("geoimage.showThumbs", CorrelateGpxWithImages.this.yLayer.useThumbs);
                        CorrelateGpxWithImages.this.yLayer.useThumbs = CorrelateGpxWithImages.this.cbShowThumbs.isSelected();
                        CorrelateGpxWithImages.this.yLayer.loadThumbs();
                        boolean bl = false;
                        for (Layer object : Main.map.mapView.getAllLayers()) {
                            if (object == CorrelateGpxWithImages.this.yLayer) continue;
                            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                            object.visitBoundingBox(boundingXYVisitor);
                            if (boundingXYVisitor.getBounds() == null) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            Iterator<ImageEntry> iterator = new BoundingXYVisitor();
                            CorrelateGpxWithImages.this.yLayer.visitBoundingBox((BoundingXYVisitor)((Object)iterator));
                            Main.map.mapView.recalculateCenterScale((BoundingXYVisitor)((Object)iterator));
                        }
                        for (ImageEntry imageEntry : CorrelateGpxWithImages.this.yLayer.data) {
                            imageEntry.applyTmp();
                        }
                        CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        this.syncDialog.showDialog();
    }

    private ArrayList<ImageEntry> getSortedImgList() {
        return this.getSortedImgList(this.cbExifImg.isSelected(), this.cbTaggedImg.isSelected());
    }

    private ArrayList<ImageEntry> getSortedImgList(boolean bl, boolean bl2) {
        ArrayList<ImageEntry> arrayList = new ArrayList<ImageEntry>(this.yLayer.data.size());
        for (ImageEntry imageEntry : this.yLayer.data) {
            if (imageEntry.getExifTime() == null || imageEntry.getExifCoor() != null && !bl || imageEntry.isTagged() && imageEntry.getExifCoor() == null && !bl2) continue;
            arrayList.add(imageEntry);
        }
        Collections.sort(arrayList, new Comparator<ImageEntry>(){

            @Override
            public int compare(ImageEntry imageEntry, ImageEntry imageEntry2) {
                return imageEntry.getExifTime().compareTo(imageEntry2.getExifTime());
            }
        });
        return arrayList;
    }

    private GpxDataWrapper selectedGPX(boolean bl) {
        Object object = this.cbGpx.getSelectedItem();
        if (object == null || ((GpxDataWrapper)object).file == null) {
            if (bl) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You should select a GPX track"), I18n.tr("No selected GPX track"), 0);
            }
            return null;
        }
        return (GpxDataWrapper)object;
    }

    private int matchGpxTrack(ArrayList<ImageEntry> arrayList, GpxData gpxData, long l) {
        int n = 0;
        PrimaryDateParser primaryDateParser = new PrimaryDateParser();
        for (GpxTrack gpxTrack : gpxData.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                long l2 = 0L;
                WayPoint wayPoint = null;
                for (WayPoint wayPoint2 : gpxTrackSegment.getWayPoints()) {
                    String string = (String)wayPoint2.attr.get("time");
                    if (string != null) {
                        try {
                            long l3 = primaryDateParser.parse(string).getTime() + l;
                            n += this.matchPoints(arrayList, wayPoint, l2, wayPoint2, l3, l);
                            wayPoint = wayPoint2;
                            l2 = l3;
                        }
                        catch (ParseException parseException) {
                            System.err.println("Error while parsing date \"" + string + '\"');
                            parseException.printStackTrace();
                            wayPoint = null;
                            l2 = 0L;
                        }
                        continue;
                    }
                    wayPoint = null;
                    l2 = 0L;
                }
            }
        }
        return n;
    }

    private int matchPoints(ArrayList<ImageEntry> arrayList, WayPoint wayPoint, long l, WayPoint wayPoint2, long l2, long l3) {
        ImageEntry imageEntry;
        long l4;
        long l5 = l > 0L ? Math.abs(l2 - l) : 5000L;
        int n = 0;
        int n2 = this.getLastIndexOfListBefore(arrayList, l2);
        if (n2 < 0) {
            return 0;
        }
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        if (wayPoint != null) {
            double d4 = wayPoint.getCoor().greatCircleDistance(wayPoint2.getCoor());
            if (l2 > l) {
                d = 3600.0 * d4 / (double)(l2 - l);
            }
            try {
                d2 = new Double((String)wayPoint.attr.get("ele"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            d3 = new Double((String)wayPoint2.attr.get("ele"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == 0L || l2 <= l) {
            ImageEntry imageEntry2;
            while (n2 >= 0 && (imageEntry2 = arrayList.get(n2)).getExifTime().getTime() <= l2 && imageEntry2.getExifTime().getTime() >= l2 - l5) {
                if (imageEntry2.tmp.getPos() == null) {
                    imageEntry2.tmp.setPos(wayPoint2.getCoor());
                    imageEntry2.tmp.setSpeed(d);
                    imageEntry2.tmp.setElevation(d3);
                    imageEntry2.tmp.setGpsTime(new Date(imageEntry2.getExifTime().getTime() - l3));
                    ++n;
                }
                --n2;
            }
            return n;
        }
        while (n2 >= 0 && (l4 = (imageEntry = arrayList.get(n2)).getExifTime().getTime()) >= l) {
            if (imageEntry.tmp.getPos() == null) {
                double d5 = (double)(l4 - l) / (double)l5;
                imageEntry.tmp.setPos(wayPoint.getCoor().interpolate(wayPoint2.getCoor(), d5));
                imageEntry.tmp.setSpeed(d);
                if (d3 != null && d2 != null) {
                    imageEntry.setElevation(d2 + (d3 - d2) * d5);
                }
                imageEntry.tmp.setGpsTime(new Date(imageEntry.getExifTime().getTime() - l3));
                ++n;
            }
            --n2;
        }
        return n;
    }

    private int getLastIndexOfListBefore(ArrayList<ImageEntry> arrayList, long l) {
        int n = arrayList.size();
        if (n == 0 || l < arrayList.get(0).getExifTime().getTime()) {
            return -1;
        }
        if (l > arrayList.get(n - 1).getExifTime().getTime()) {
            return n - 1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (n4 - n3 > 1) {
            n2 = (n4 + n3) / 2;
            if (l > arrayList.get(n2).getExifTime().getTime()) {
                n3 = n2;
                continue;
            }
            n4 = n2;
        }
        if (l < arrayList.get(n4).getExifTime().getTime()) {
            return n3;
        }
        while (n4 < n - 1 && arrayList.get(n4).getExifTime().getTime() == arrayList.get(n4 + 1).getExifTime().getTime()) {
            ++n4;
        }
        return n4;
    }

    private String formatTimezone(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        if (d < 0.0) {
            stringBuffer.append('-');
            d = -d;
        } else {
            stringBuffer.append('+');
        }
        stringBuffer.append((long)d).append(':');
        int n = (int)(d % 1.0 * 60.0);
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    private double parseTimezone(String string) throws ParseException {
        int n;
        int n2;
        String string2 = I18n.tr("Error while parsing timezone.\nExpected format: {0}", "+H:MM");
        if (string.length() == 0) {
            return 0.0;
        }
        int n3 = 43;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n4 = 1;
        block12: for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            switch (n) {
                case 32: {
                    if (n4 == 2 && stringBuffer.length() == 0) continue block12;
                    throw new ParseException(string2, 0);
                }
                case 43: 
                case 45: {
                    if (n4 == 1) {
                        n3 = n;
                        n4 = 2;
                        continue block12;
                    }
                    throw new ParseException(string2, 0);
                }
                case 46: 
                case 58: {
                    if (n4 == 2) {
                        n4 = 3;
                        continue block12;
                    }
                    throw new ParseException(string2, 0);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    switch (n4) {
                        case 1: 
                        case 2: {
                            n4 = 2;
                            stringBuffer.append((char)n);
                            continue block12;
                        }
                        case 3: {
                            stringBuffer2.append((char)n);
                            continue block12;
                        }
                    }
                    throw new ParseException(string2, 0);
                }
                default: {
                    throw new ParseException(string2, 0);
                }
            }
        }
        n2 = 0;
        n = 0;
        try {
            n2 = Integer.parseInt(stringBuffer.toString());
            if (stringBuffer2.length() > 0) {
                n = Integer.parseInt(stringBuffer2.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(string2, 0);
        }
        if (n2 > 12 || n > 59) {
            throw new ParseException(string2, 0);
        }
        return ((double)n2 + (double)n / 60.0) * (double)(n3 == 45 ? -1 : 1);
    }

    private long parseOffset(String string) throws ParseException {
        String string2 = I18n.tr("Error while parsing offset.\nExpected format: {0}", "number");
        if (string.length() > 0) {
            try {
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(string2, 0);
            }
        }
        return 0L;
    }

    private class AutoGuessActionListener
    implements ActionListener {
        private AutoGuessActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GpxDataWrapper gpxDataWrapper = CorrelateGpxWithImages.this.selectedGPX(true);
            if (gpxDataWrapper == null) {
                return;
            }
            GpxData gpxData = gpxDataWrapper.data;
            ArrayList arrayList = CorrelateGpxWithImages.this.getSortedImgList();
            PrimaryDateParser primaryDateParser = new PrimaryDateParser();
            if (arrayList.size() <= 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected photos do not contain time information."), I18n.tr("Photos do not contain time information"), 2);
                return;
            }
            long l = ((ImageEntry)arrayList.get(0)).getExifTime().getTime() / 1000L;
            long l2 = -1L;
            block2: for (GpxTrack gpxTrack : gpxData.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                        String string = (String)wayPoint.attr.get("time");
                        if (string == null) continue;
                        try {
                            l2 = primaryDateParser.parse(string).getTime() / 1000L;
                            break block2;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            if (l2 < 0L) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected GPX track does not contain timestamps. Please select another one."), I18n.tr("GPX Track has no time information"), 2);
                return;
            }
            long l3 = l - l2;
            double d = (double)l3 / 3600.0;
            int n = (int)Math.round(d / 24.0);
            double d2 = l3 - (long)(n * 24 * 60) * 60L;
            d2 = (double)Math.round(d2 * 100.0 / 3600.0) / 100.0;
            CorrelateGpxWithImages.this.timezone = (double)Math.round(d2 * 2.0) / 2.0;
            CorrelateGpxWithImages.this.delta = Math.round((double)l3 - CorrelateGpxWithImages.this.timezone * 60.0 * 60.0);
            CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.formatTimezone(CorrelateGpxWithImages.this.timezone));
            CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(CorrelateGpxWithImages.this.delta));
            CorrelateGpxWithImages.this.tfOffset.requestFocus();
            CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class AdjustActionListener
    implements ActionListener {
        private AdjustActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l = CorrelateGpxWithImages.this.delta + Math.round(CorrelateGpxWithImages.this.timezone * 60.0 * 60.0);
            double d = (double)l / 3600.0;
            final int n = (int)Math.round(d / 24.0);
            double d2 = l - (long)(n * 24 * 60) * 60L;
            d2 = (double)Math.round(d2 * 100.0 / 3600.0) / 100.0;
            double d3 = (double)Math.round(d2 * 2.0) / 2.0;
            int n2 = (int)Math.round((double)l - d3 * 60.0 * 60.0) - n * 24 * 60 * 60;
            final JLabel jLabel = new JLabel();
            final JLabel jLabel2 = new JLabel();
            final JSlider jSlider = new JSlider(-24, 24, 0);
            jSlider.setPaintLabels(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(-24, new JLabel("-12:00"));
            hashtable.put(-12, new JLabel("-6:00"));
            hashtable.put(0, new JLabel("0:00"));
            hashtable.put(12, new JLabel("6:00"));
            hashtable.put(24, new JLabel("12:00"));
            jSlider.setLabelTable(hashtable);
            final JLabel jLabel3 = new JLabel();
            final JSlider jSlider2 = new JSlider(-15, 15, 0);
            jSlider2.setPaintLabels(true);
            jSlider2.setMajorTickSpacing(5);
            final JLabel jLabel4 = new JLabel();
            final JSlider jSlider3 = new JSlider(-60, 60, 0);
            jSlider3.setPaintLabels(true);
            jSlider3.setMajorTickSpacing(30);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setPreferredSize(new Dimension(400, 230));
            jPanel.add((Component)jLabel, GBC.eol().fill());
            jPanel.add((Component)jLabel2, GBC.eol().fill());
            jPanel.add((Component)jSlider, GBC.eol().fill().insets(0, 0, 0, 10));
            jPanel.add((Component)jLabel3, GBC.eol().fill());
            jPanel.add((Component)jSlider2, GBC.eol().fill().insets(0, 0, 0, 10));
            jPanel.add((Component)jLabel4, GBC.eol().fill());
            jPanel.add((Component)jSlider3, GBC.eol().fill());
            try {
                jSlider.setValue((int)(d3 * 2.0));
                jSlider2.setValue(n2 / 60);
                jSlider3.setValue(n2 % 60);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while trying to match the photos to the GPX track. You can adjust the sliders to manually match the photos."), I18n.tr("Matching photos to track failed"), 2);
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SliderListener
            implements ChangeListener {
                SliderListener() {
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    String string;
                    double d = Math.abs(jSlider.getValue());
                    String string2 = string = d % 2.0 == 0.0 ? (int)Math.floor(d / 2.0) + ":00" : (int)Math.floor(d / 2.0) + ":30";
                    if (jSlider.getValue() < 0) {
                        string = "-" + string;
                    }
                    jLabel2.setText(I18n.tr("Timezone: {0}", string));
                    jLabel3.setText(I18n.tr("Minutes: {0}", jSlider2.getValue()));
                    jLabel4.setText(I18n.tr("Seconds: {0}", jSlider3.getValue()));
                    try {
                        CorrelateGpxWithImages.this.timezone = CorrelateGpxWithImages.this.parseTimezone(string);
                    }
                    catch (ParseException parseException) {
                        throw new RuntimeException();
                    }
                    CorrelateGpxWithImages.this.delta = jSlider2.getValue() * 60 + jSlider3.getValue();
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.formatTimezone(CorrelateGpxWithImages.this.timezone));
                    CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(CorrelateGpxWithImages.this.delta + 86400L * (long)n));
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    jLabel.setText(CorrelateGpxWithImages.this.statusBarText.getText() + "<br>" + I18n.trn("(Time difference of {0} day)", "Time difference of {0} days", Math.abs(n), Math.abs(n)));
                    CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                }
            }
            new SliderListener().stateChanged(null);
            jSlider.addChangeListener(new SliderListener());
            jSlider2.addChangeListener(new SliderListener());
            jSlider3.addChangeListener(new SliderListener());
            new ExtendedDialog(Main.parent, I18n.tr("Adjust timezone and offset"), new String[]{I18n.tr("Close")}).setContent(jPanel).setButtonIcons(new String[]{"ok.png"}).showDialog();
        }
    }

    private class RepaintTheMapListener
    implements FocusListener {
        private RepaintTheMapListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class StatusBarUpdater
    implements DocumentListener,
    ItemListener,
    ActionListener {
        private boolean doRepaint;

        public StatusBarUpdater(boolean bl) {
            this.doRepaint = bl;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateStatusBar();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateStatusBar();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateStatusBar();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateStatusBar();
        }

        public void updateStatusBar() {
            CorrelateGpxWithImages.this.statusBarText.setText(this.statusText());
            if (this.doRepaint) {
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
            }
        }

        private String statusText() {
            try {
                CorrelateGpxWithImages.this.timezone = CorrelateGpxWithImages.this.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                CorrelateGpxWithImages.this.delta = CorrelateGpxWithImages.this.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException parseException) {
                return parseException.getMessage();
            }
            for (ImageEntry object2 : CorrelateGpxWithImages.this.yLayer.data) {
                object2.tmp = null;
            }
            ArrayList arrayList = CorrelateGpxWithImages.this.getSortedImgList();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ImageEntry imageEntry = (ImageEntry)iterator.next();
                imageEntry.cleanTmp();
            }
            GpxDataWrapper gpxDataWrapper = CorrelateGpxWithImages.this.selectedGPX(false);
            if (gpxDataWrapper == null) {
                return I18n.tr("No gpx selected");
            }
            long l = ((long)(CorrelateGpxWithImages.this.timezone * 3600.0) + CorrelateGpxWithImages.this.delta) * 1000L;
            CorrelateGpxWithImages.this.lastNumMatched = CorrelateGpxWithImages.this.matchGpxTrack(arrayList, gpxDataWrapper.data, l);
            return I18n.trn("<html>Matched <b>{0}</b> of <b>{1}</b> photo to GPX track.</html>", "<html>Matched <b>{0}</b> of <b>{1}</b> photos to GPX track.</html>", arrayList.size(), CorrelateGpxWithImages.this.lastNumMatched, arrayList.size());
        }
    }

    private class SetOffsetActionListener
    implements ActionListener {
        JPanel panel;
        JLabel lbExifTime;
        JTextField tfGpsTime;
        JComboBox cbTimezones;
        ImageDisplay imgDisp;
        JList imgList;

        private SetOffsetActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)new JLabel(I18n.tr("<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>")), "North");
            this.imgDisp = new ImageDisplay();
            this.imgDisp.setPreferredSize(new Dimension(300, 225));
            this.panel.add((Component)this.imgDisp, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr("Photo time (from exif):")), gridBagConstraints);
            this.lbExifTime = new JLabel();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.lbExifTime, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr("Gps time (read from the above photo): ")), gridBagConstraints);
            this.tfGpsTime = new JTextField(12);
            this.tfGpsTime.setEnabled(false);
            this.tfGpsTime.setMinimumSize(new Dimension(155, this.tfGpsTime.getMinimumSize().height));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.tfGpsTime, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.2;
            jPanel.add((Component)new JLabel(I18n.tr(" [dd/mm/yyyy hh:mm:ss]")), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr("I am in the timezone of: ")), gridBagConstraints);
            Vector<String> vector = new Vector<String>();
            String[] stringArray = TimeZone.getAvailableIDs();
            for (String object2 : stringArray) {
                TimeZone bl = TimeZone.getTimeZone(object2);
                String n = new StringBuffer(object2).append(" (").append(CorrelateGpxWithImages.this.formatTimezone((double)bl.getRawOffset() / 3600000.0)).append(')').toString();
                vector.add(n);
            }
            Collections.sort(vector);
            this.cbTimezones = new JComboBox(vector);
            Object object3 = Main.pref.get("geoimage.timezoneid", "");
            TimeZone timeZone = ((String)object3).length() == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone((String)object3);
            this.cbTimezones.setSelectedItem(new StringBuffer(timeZone.getID()).append(" (").append(CorrelateGpxWithImages.this.formatTimezone((double)timeZone.getRawOffset() / 3600000.0)).append(')').toString());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.cbTimezones, gridBagConstraints);
            this.panel.add((Component)jPanel, "South");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            this.imgList = new JList(new AbstractListModel(){

                public Object getElementAt(int n) {
                    return CorrelateGpxWithImages.this.yLayer.data.get(n).getFile().getName();
                }

                public int getSize() {
                    return CorrelateGpxWithImages.this.yLayer.data.size();
                }
            });
            this.imgList.getSelectionModel().setSelectionMode(0);
            this.imgList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = SetOffsetActionListener.this.imgList.getSelectedIndex();
                    Integer n2 = null;
                    try {
                        n2 = ExifReader.readOrientation(CorrelateGpxWithImages.this.yLayer.data.get(n).getFile());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SetOffsetActionListener.this.imgDisp.setImage(CorrelateGpxWithImages.this.yLayer.data.get(n).getFile(), n2);
                    Date date = CorrelateGpxWithImages.this.yLayer.data.get(n).getExifTime();
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setCaretPosition(SetOffsetActionListener.this.tfGpsTime.getText().length());
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                        SetOffsetActionListener.this.tfGpsTime.requestFocus();
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr("No date"));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            jPanel2.add((Component)new JScrollPane(this.imgList), "Center");
            JButton jButton = new JButton(I18n.tr("Open another photo"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(Main.pref.get("geoimage.lastdirectory"));
                    jFileChooser.setAcceptAllFileFilterUsed(false);
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setFileFilter(JpegFileFilter.getInstance());
                    jFileChooser.showOpenDialog(Main.parent);
                    File file = jFileChooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    Integer n = null;
                    try {
                        n = ExifReader.readOrientation(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SetOffsetActionListener.this.imgDisp.setImage(file, n);
                    Date date = null;
                    try {
                        date = ExifReader.readTime(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(new SimpleDateFormat("dd/MM/yyyy ").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr("No date"));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            jPanel2.add((Component)jButton, "Last");
            this.panel.add((Component)jPanel2, "Before");
            boolean bl = false;
            while (!bl) {
                long l;
                int n = JOptionPane.showConfirmDialog(Main.parent, this.panel, I18n.tr("Synchronize time from a photo of the GPS receiver"), 2, 3);
                if (n == 2) {
                    return;
                }
                try {
                    l = simpleDateFormat.parse(this.lbExifTime.getText()).getTime() - simpleDateFormat.parse(this.tfGpsTime.getText()).getTime();
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing the date.\nPlease use the requested format"), I18n.tr("Invalid date"), 0);
                    continue;
                }
                String parseException = (String)this.cbTimezones.getSelectedItem();
                int n2 = parseException.lastIndexOf(40);
                object3 = parseException.substring(0, n2 - 1);
                String string = parseException.substring(n2 + 1, parseException.length() - 1);
                Main.pref.put("geoimage.timezoneid", (String)object3);
                CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(l / 1000L));
                CorrelateGpxWithImages.this.tfTimezone.setText(string);
                bl = true;
            }
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void actionPerformed(ActionEvent actionEvent) {
            block13: {
                JFileChooser jFileChooser = new JFileChooser(Main.pref.get("lastDirectory"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".gpx") || file.getName().toLowerCase().endsWith(".gpx.gz");
                    }

                    public String getDescription() {
                        return I18n.tr("GPX Files (*.gpx *.gpx.gz)");
                    }
                });
                jFileChooser.showOpenDialog(Main.parent);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                try {
                    Object object;
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    Main.pref.put("lastDirectory", file.getPath());
                    for (int i = CorrelateGpxWithImages.this.gpxLst.size() - 1; i >= 0; --i) {
                        object = CorrelateGpxWithImages.this.gpxLst.get(i);
                        if (((GpxDataWrapper)object).file == null || !file.equals(((GpxDataWrapper)object).file)) continue;
                        CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(i);
                        if (!file.getName().equals(((GpxDataWrapper)object).name)) {
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr("File {0} is loaded yet under the name \"{1}\"", file.getName(), ((GpxDataWrapper)object).name), I18n.tr("Error"), 0);
                        }
                        return;
                    }
                    GpxData gpxData = null;
                    try {
                        object = file.getName().toLowerCase().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
                        GpxReader gpxReader = new GpxReader((InputStream)object);
                        gpxReader.parse(false);
                        gpxData = gpxReader.data;
                        gpxData.storageFile = file;
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace();
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing {0}", file.getName()) + ": " + sAXException.getMessage(), I18n.tr("Error"), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read \"{0}\"", file.getName()) + "\n" + iOException.getMessage(), I18n.tr("Error"), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    loadedGpxData.add(gpxData);
                    if (CorrelateGpxWithImages.this.gpxLst.get((int)0).file == null) {
                        CorrelateGpxWithImages.this.gpxLst.remove(0);
                    }
                    CorrelateGpxWithImages.this.gpxLst.add(new GpxDataWrapper(file.getName(), gpxData, file));
                    CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(CorrelateGpxWithImages.this.cbGpx.getItemCount() - 1);
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private static class GpxDataWrapper {
        String name;
        GpxData data;
        File file;

        public GpxDataWrapper(String string, GpxData gpxData, File file) {
            this.name = string;
            this.data = gpxData;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }
}

