/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import org.openstreetmap.josm.gui.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.gui.io.UploadStrategy;

public class UploadStrategySpecification {
    public static final int UNSPECIFIED_CHUNK_SIZE = -1;
    private UploadStrategy strategy;
    private int chunkSize;
    private MaxChangesetSizeExceededPolicy policy;
    private boolean closeChangesetAfterUpload;

    public UploadStrategySpecification() {
        this.strategy = UploadStrategy.DEFAULT_UPLOAD_STRATEGY;
        this.chunkSize = -1;
        this.policy = null;
        this.closeChangesetAfterUpload = true;
    }

    public UploadStrategySpecification(UploadStrategySpecification uploadStrategySpecification) {
        if (uploadStrategySpecification == null) {
            return;
        }
        this.strategy = uploadStrategySpecification.strategy;
        this.chunkSize = uploadStrategySpecification.chunkSize;
        this.policy = uploadStrategySpecification.policy;
        this.closeChangesetAfterUpload = uploadStrategySpecification.closeChangesetAfterUpload;
    }

    public UploadStrategy getStrategy() {
        return this.strategy;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public static int getUnspecifiedChunkSize() {
        return -1;
    }

    public MaxChangesetSizeExceededPolicy getPolicy() {
        return this.policy;
    }

    public UploadStrategySpecification setStrategy(UploadStrategy uploadStrategy) {
        this.strategy = uploadStrategy;
        return this;
    }

    public UploadStrategySpecification setChunkSize(int n) {
        this.chunkSize = n;
        return this;
    }

    public UploadStrategySpecification setPolicy(MaxChangesetSizeExceededPolicy maxChangesetSizeExceededPolicy) {
        this.policy = maxChangesetSizeExceededPolicy;
        return this;
    }

    public UploadStrategySpecification setCloseChangesetAfterUpload(boolean bl) {
        this.closeChangesetAfterUpload = bl;
        return this;
    }

    public boolean isCloseChangesetAfterUpload() {
        return this.closeChangesetAfterUpload;
    }

    public int getNumRequests(int n) {
        if (n <= 0) {
            return 0;
        }
        switch (this.strategy) {
            case INDIVIDUAL_OBJECTS_STRATEGY: {
                return n;
            }
            case SINGLE_REQUEST_STRATEGY: {
                return 1;
            }
            case CHUNKED_DATASET_STRATEGY: {
                if (this.chunkSize == -1) {
                    return 0;
                }
                return (int)Math.ceil((double)n / (double)this.chunkSize);
            }
        }
        return 0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.chunkSize;
        n = 31 * n + (this.closeChangesetAfterUpload ? 1231 : 1237);
        n = 31 * n + (this.policy == null ? 0 : this.policy.hashCode());
        n = 31 * n + (this.strategy == null ? 0 : this.strategy.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UploadStrategySpecification uploadStrategySpecification = (UploadStrategySpecification)object;
        if (this.chunkSize != uploadStrategySpecification.chunkSize) {
            return false;
        }
        if (this.closeChangesetAfterUpload != uploadStrategySpecification.closeChangesetAfterUpload) {
            return false;
        }
        if (this.policy == null ? uploadStrategySpecification.policy != null : !this.policy.equals((Object)uploadStrategySpecification.policy)) {
            return false;
        }
        return !(this.strategy == null ? uploadStrategySpecification.strategy != null : !this.strategy.equals((Object)uploadStrategySpecification.strategy));
    }
}

