/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    public static JPanel pluginHook = new JPanel();
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    Comparator<AutoCompletionListItem> defaultACItemComparator = new Comparator<AutoCompletionListItem>(){

        @Override
        public int compare(AutoCompletionListItem autoCompletionListItem, AutoCompletionListItem autoCompletionListItem2) {
            return String.CASE_INSENSITIVE_ORDER.compare(autoCompletionListItem.getValue(), autoCompletionListItem2.getValue());
        }
    };
    private DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private HelpAction helpAction = new HelpAction();
    private AddAction addAction = new AddAction();
    private Shortcut addActionShortcut = Shortcut.registerShortcut("properties:add", I18n.tr("Add Properties"), 66, 6);
    private static String lastAddKey = null;
    private static String lastAddValue = null;
    private String objKey;
    private final DefaultTableModel propertyData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final DefaultTableModel membershipData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable membershipTable = new JTable(this.membershipData);
    public JComboBox taggingPresets = new JComboBox();
    private final SideButton btnAdd;
    private final SideButton btnEdit;
    private final SideButton btnDel;
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Please select the objects you want to change properties for.") + "</p></html>");
    private PresetListPanel.PresetHandler presetHandler = new PresetListPanel.PresetHandler(){

        @Override
        public void updateTags(List<Tag> list) {
            Command command = TaggingPreset.createCommand(this.getSelection(), list);
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }

        @Override
        public Collection<OsmPrimitive> getSelection() {
            if (Main.main == null) {
                return null;
            }
            if (Main.main.getCurrentDataSet() == null) {
                return null;
            }
            return Main.main.getCurrentDataSet().getSelected();
        }
    };

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener(this);
        this.updateSelection();
        Main.registerActionShortcut((Action)this.addAction, this.addActionShortcut);
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MapView.removeEditLayerChangeListener(this);
        Main.unregisterActionShortcut(this.addAction, this.addActionShortcut);
    }

    void propertyEdit(int n) {
        String string;
        String string2;
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            return;
        }
        this.objKey = string2 = this.propertyData.getValueAt(n, 0).toString();
        String string3 = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", string2) + ")</html>";
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string3), "North");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
        List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
        Collections.sort(list, this.defaultACItemComparator);
        AutoCompletingComboBox autoCompletingComboBox = new AutoCompletingComboBox();
        autoCompletingComboBox.setPossibleACItems(list);
        autoCompletingComboBox.setEditable(true);
        autoCompletingComboBox.setSelectedItem(string2);
        jPanel2.add((Component)new JLabel(I18n.tr("Key")), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompletingComboBox, GBC.eol().fill(2));
        final AutoCompletingComboBox autoCompletingComboBox2 = new AutoCompletingComboBox();
        autoCompletingComboBox2.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    Map map;
                    String string = null;
                    string = ((AutoCompletionListItem)object).getValue();
                    if (PropertiesDialog.this.valueCount.containsKey(PropertiesDialog.this.objKey) && (map = (Map)PropertiesDialog.this.valueCount.get(PropertiesDialog.this.objKey)).containsKey(string)) {
                        string = string + "(" + map.get(string) + ")";
                        component.setFont(component.getFont().deriveFont(3));
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        autoCompletingComboBox2.setEditable(true);
        List<AutoCompletionListItem> list2 = autoCompletionManager.getValues(string2);
        Collections.sort(list2, this.defaultACItemComparator);
        autoCompletingComboBox2.setPossibleACItems(list2);
        Map map = (Map)this.propertyData.getValueAt(n, 1);
        String string4 = map.size() != 1 ? I18n.tr("<different>") : (String)map.entrySet().iterator().next().getKey();
        autoCompletingComboBox2.setSelectedItem(string4);
        autoCompletingComboBox2.getEditor().setItem(string4);
        jPanel2.add((Component)new JLabel(I18n.tr("Value")), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompletingComboBox2, GBC.eol().fill(2));
        this.addFocusAdapter(n, autoCompletingComboBox, autoCompletingComboBox2, autoCompletionManager);
        final JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2){

            public void selectInitialValue() {
                autoCompletingComboBox2.requestFocusInWindow();
                autoCompletingComboBox2.getEditor().selectAll();
            }
        };
        final JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr("Change values?"));
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        Dimension dimension = jDialog.getSize();
        if (dimension.width > Main.parent.getSize().width) {
            dimension.width = Math.max(250, Main.parent.getSize().width);
            jDialog.setSize(dimension);
        }
        jDialog.setLocationRelativeTo(Main.parent);
        autoCompletingComboBox2.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jOptionPane.setValue(0);
            }
        });
        String string5 = autoCompletingComboBox2.getEditor().getItem().toString();
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == null || object == JOptionPane.UNINITIALIZED_VALUE || object instanceof Integer && (Integer)object != 0) {
            autoCompletingComboBox2.getEditor().setItem(string5);
            return;
        }
        String string6 = autoCompletingComboBox2.getEditor().getItem().toString().trim();
        if (string6.equals("")) {
            string6 = null;
        }
        if ((string = autoCompletingComboBox.getEditor().getItem().toString().trim()).equals("")) {
            string = string2;
            string6 = null;
        }
        if (string2.equals(string) && I18n.tr("<different>").equals(string6)) {
            return;
        }
        if (string2.equals(string) || string6 == null) {
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string6));
        } else {
            for (OsmPrimitive object2 : collection) {
                if (object2.get(string) == null) continue;
                Iterator iterator = new ExtendedDialog(Main.parent, I18n.tr("Overwrite key"), new String[]{I18n.tr("Replace"), I18n.tr("Cancel")});
                ((ExtendedDialog)((Object)iterator)).setButtonIcons(new String[]{"purge", "cancel"});
                ((ExtendedDialog)((Object)iterator)).setContent(I18n.tr("You changed the key from ''{0}'' to ''{1}''.\nThe new key is already used, overwrite values?", string2, string));
                ((ExtendedDialog)((Object)iterator)).setCancelButton(2);
                ((ExtendedDialog)((Object)iterator)).toggleEnable("overwriteEditKey");
                ((ExtendedDialog)((Object)iterator)).showDialog();
                if (((ExtendedDialog)((Object)iterator)).getValue() == 1) break;
                return;
            }
            Vector vector = new Vector();
            vector.add(new ChangePropertyCommand(collection, string2, null));
            if (string6.equals(I18n.tr("<different>"))) {
                HashMap hashMap = new HashMap();
                for (OsmPrimitive osmPrimitive : collection) {
                    String string7 = osmPrimitive.get(string2);
                    if (string7 == null) continue;
                    if (hashMap.containsKey(string7)) {
                        ((Vector)hashMap.get(string7)).add(osmPrimitive);
                        continue;
                    }
                    Vector<OsmPrimitive> vector2 = new Vector<OsmPrimitive>();
                    vector2.add(osmPrimitive);
                    hashMap.put(string7, vector2);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    vector.add(new ChangePropertyCommand((Collection)entry.getValue(), string, (String)entry.getKey()));
                }
            } else {
                vector.add(new ChangePropertyCommand(collection, string, string6));
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", collection.size(), collection.size()), vector));
        }
        if (!string2.equals(string)) {
            for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                if (!this.propertyData.getValueAt(i, 0).toString().equals(string)) continue;
                n = i;
                break;
            }
        }
        this.propertyTable.changeSelection(n, 0, false, false);
    }

    void membershipEdit(int n) {
        Relation relation = (Relation)this.membershipData.getValueAt(n, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, ((MemberInfo)this.membershipData.getValueAt((int)n, (int)1)).role).setVisible(true);
    }

    void add() {
        Object object;
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>" + I18n.tr("Please select a key")), "North");
        final AutoCompletingComboBox autoCompletingComboBox = new AutoCompletingComboBox();
        AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
        List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
        AutoCompletionListItem autoCompletionListItem = null;
        Iterator<AutoCompletionListItem> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            object = iterator.next();
            if (((AutoCompletionListItem)object).getValue().equals(lastAddKey)) {
                autoCompletionListItem = object;
            }
            for (int i = 0; i < this.propertyData.getRowCount(); ++i) {
                if (!((AutoCompletionListItem)object).getValue().equals(this.propertyData.getValueAt(i, 0))) continue;
                if (autoCompletionListItem == object) {
                    autoCompletionListItem = null;
                }
                iterator.remove();
                continue block0;
            }
        }
        Collections.sort(list, this.defaultACItemComparator);
        autoCompletingComboBox.setPossibleACItems(list);
        autoCompletingComboBox.setEditable(true);
        jPanel.add((Component)autoCompletingComboBox, "Center");
        object = new JPanel(new BorderLayout());
        jPanel.add((Component)object, "South");
        ((Container)object).add((Component)new JLabel(I18n.tr("Please select a value")), "North");
        AutoCompletingComboBox autoCompletingComboBox2 = new AutoCompletingComboBox();
        autoCompletingComboBox2.setEditable(true);
        ((Container)object).add((Component)autoCompletingComboBox2, "Center");
        if (autoCompletionListItem != null) {
            autoCompletingComboBox.setSelectedItem(autoCompletionListItem);
            if (lastAddValue != null && lastAddValue.length() > 1) {
                autoCompletingComboBox2.setSelectedItem(lastAddValue);
            }
        }
        FocusAdapter focusAdapter = this.addFocusAdapter(-1, autoCompletingComboBox, autoCompletingComboBox2, autoCompletionManager);
        focusAdapter.focusGained(null);
        JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2){

            public void selectInitialValue() {
                autoCompletingComboBox.requestFocusInWindow();
                autoCompletingComboBox.getEditor().selectAll();
            }
        };
        JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr("Change values?"));
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        jDialog.setVisible(true);
        if (!Integer.valueOf(0).equals(jOptionPane.getValue())) {
            return;
        }
        String string = autoCompletingComboBox.getEditor().getItem().toString().trim();
        String string2 = autoCompletingComboBox2.getEditor().getItem().toString().trim();
        if (string2.equals("")) {
            return;
        }
        lastAddKey = string;
        lastAddValue = string2;
        Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string2));
        this.btnAdd.requestFocusInWindow();
    }

    private FocusAdapter addFocusAdapter(int n, final AutoCompletingComboBox autoCompletingComboBox, final AutoCompletingComboBox autoCompletingComboBox2, final AutoCompletionManager autoCompletionManager) {
        JTextComponent jTextComponent = (JTextComponent)autoCompletingComboBox2.getEditor().getEditorComponent();
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                String string = autoCompletingComboBox.getEditor().getItem().toString();
                List<AutoCompletionListItem> list = autoCompletionManager.getValues(string);
                Collections.sort(list, PropertiesDialog.this.defaultACItemComparator);
                autoCompletingComboBox2.setPossibleACItems(list);
                PropertiesDialog.this.objKey = string;
            }
        };
        jTextComponent.addFocusListener(focusAdapter);
        return focusAdapter;
    }

    public PropertiesDialog(MapFrame mapFrame) {
        super(I18n.tr("Properties/Memberships"), "propertiesdialog", I18n.tr("Properties for selected objects."), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Properties/Memberships")), 80, 4, 1), 150, true);
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key"), I18n.tr("Value")});
        this.propertyTable.setSelectionMode(0);
        this.propertyTable.getTableHeader().setReorderingAllowed(false);
        this.propertyTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(point);
                if (n > -1) {
                    PropertiesDialog.this.propertyTable.changeSelection(n, 0, false, false);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(PropertiesDialog.this.helpAction);
                    jPopupMenu.show(PropertiesDialog.this.propertyTable, point.x, point.y - 3);
                }
            }
        });
        this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (object == null) {
                    return this;
                }
                if (component instanceof JLabel) {
                    String string = null;
                    if (object instanceof String) {
                        string = (String)object;
                    } else if (object instanceof Map) {
                        Map map = (Map)object;
                        if (map.size() != 1) {
                            string = I18n.tr("<different>");
                            component.setFont(component.getFont().deriveFont(2));
                        } else {
                            Map.Entry entry = map.entrySet().iterator().next();
                            string = (String)entry.getKey();
                        }
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of"), I18n.tr("Role"), I18n.tr("Position")});
        this.membershipTable.setSelectionMode(0);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(point);
                if (n > -1) {
                    PropertiesDialog.this.membershipTable.changeSelection(n, 0, false, false);
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
                    jPopupMenu.add(new SelectRelationAction(relation, true));
                    jPopupMenu.add(new SelectRelationAction(relation, false));
                    jPopupMenu.add(new SelectRelationMembersAction(relation));
                    jPopupMenu.add(new DownloadIncompleteMembersAction(relation));
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(PropertiesDialog.this.helpAction);
                    jPopupMenu.show(PropertiesDialog.this.membershipTable, point.x, point.y - 3);
                }
            }
        });
        TableColumnModel tableColumnModel = this.membershipTable.getColumnModel();
        this.membershipTable.getTableHeader().setReorderingAllowed(false);
        tableColumnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (object == null) {
                    return this;
                }
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    Relation relation = (Relation)object;
                    jLabel.setText(relation.getDisplayName(DefaultNameFormatter.getInstance()));
                    if (relation.isDisabledAndHidden()) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object == null) {
                    return this;
                }
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    MemberInfo memberInfo = (MemberInfo)object;
                    String string = null;
                    for (RelationMember relationMember : memberInfo.role) {
                        if (string == null) {
                            string = relationMember.getRole();
                            continue;
                        }
                        if (string.equals(relationMember.getRole())) continue;
                        string = I18n.tr("<different>");
                        break;
                    }
                    jLabel.setText(string);
                    if (bl3) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setText(((MemberInfo)jTable.getValueAt(n, 1)).getPositionString());
                    if (bl3) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(2).setPreferredWidth(20);
        tableColumnModel.getColumn(1).setPreferredWidth(40);
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        JPanel jPanel = new JPanel();
        boolean bl = Main.pref.getBoolean("properties.presets.top", true);
        jPanel.setLayout(new GridBagLayout());
        if (bl) {
            jPanel.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double d = Double.MIN_VALUE;
            jPanel.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(d, d));
        }
        jPanel.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        jPanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        jPanel.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!bl) {
            jPanel.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        DblClickWatch dblClickWatch = new DblClickWatch();
        this.propertyTable.addMouseListener(dblClickWatch);
        this.membershipTable.addMouseListener(dblClickWatch);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.addMouseListener(dblClickWatch);
        this.add((Component)jScrollPane, "Center");
        this.selectSth.setPreferredSize(jScrollPane.getSize());
        this.presets.setSize(jScrollPane.getSize());
        JPanel jPanel2 = this.getButtonPanel(3);
        this.btnAdd = new SideButton(this.addAction);
        this.btnAdd.setFocusable(true);
        jPanel2.add(this.btnAdd);
        this.btnAdd.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "onEnter");
        this.btnAdd.getActionMap().put("onEnter", this.addAction);
        EditAction editAction = new EditAction();
        this.propertyTable.getSelectionModel().addListSelectionListener(editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(editAction);
        this.btnEdit = new SideButton(editAction);
        jPanel2.add(this.btnEdit);
        DeleteAction deleteAction = new DeleteAction();
        this.btnDel = new SideButton(deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.propertyTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteAction);
        jPanel2.add(this.btnDel);
        this.add((Component)jPanel2, "South");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    private int findRow(TableModel tableModel, Object object) {
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, 0).equals(object)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        int n;
        int n2;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        if (this.propertyTable == null) {
            return;
        }
        if (this.propertyTable.getCellEditor() != null) {
            this.propertyTable.getCellEditor().cancelCellEditing();
        }
        String string = null;
        Relation relation = null;
        if (this.propertyTable.getSelectedRowCount() == 1) {
            string = (String)this.propertyData.getValueAt(this.propertyTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            relation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.propertyData.setRowCount(0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.valueCount.clear();
        for (OsmPrimitive object22 : collection) {
            if (object22 instanceof Node) {
                ++n3;
            } else if (object22 instanceof Relation) {
                ++n5;
            } else if (((Way)object22).isClosed()) {
                ++n6;
            } else {
                ++n4;
            }
            for (String string2 : object22.keySet()) {
                String string3 = object22.get(string2);
                hashMap.put(string2, hashMap.containsKey(string2) ? (Integer)hashMap.get(string2) + 1 : 1);
                if (this.valueCount.containsKey(string2)) {
                    object.put((Object)string3, (object = this.valueCount.get(string2)).containsKey(string3) ? (Integer)object.get(string3) + 1 : 1);
                    continue;
                }
                object = new TreeMap<String, Integer>();
                ((TreeMap)object).put(string3, 1);
                this.valueCount.put(string2, (Map<String, Integer>)object);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            void var11_17;
            boolean bl = false;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                var11_17 += ((Integer)entry2.getValue()).intValue();
            }
            if (var11_17 < collection.size()) {
                ((Map)entry.getValue()).put("", collection.size() - var11_17);
            }
            this.propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        this.membershipData.setRowCount(0);
        HashMap hashMap2 = new HashMap();
        for (OsmPrimitive osmPrimitive : collection) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || osmPrimitive2.isIncomplete() || osmPrimitive2.isDeleted()) continue;
                object = (Relation)osmPrimitive2;
                MemberInfo memberInfo = (MemberInfo)hashMap2.get(object);
                if (memberInfo == null) {
                    memberInfo = new MemberInfo();
                }
                hashMap2.put(object, memberInfo);
                int n7 = 1;
                for (RelationMember relationMember : ((Relation)object).getMembers()) {
                    if (relationMember.getMember() == osmPrimitive) {
                        memberInfo.add(relationMember, n7);
                    }
                    ++n7;
                }
            }
        }
        ArrayList arrayList = new ArrayList(hashMap2.keySet());
        Collections.sort(arrayList, new Comparator<Relation>(){

            @Override
            public int compare(Relation relation, Relation relation2) {
                int n = Boolean.valueOf(relation.isDisabledAndHidden()).compareTo(relation2.isDisabledAndHidden());
                if (n == 0) {
                    n = relation.getDisplayName(DefaultNameFormatter.getInstance()).compareTo(relation2.getDisplayName(DefaultNameFormatter.getInstance()));
                }
                return n;
            }
        });
        for (Relation relation2 : arrayList) {
            this.membershipData.addRow(new Object[]{relation2, hashMap2.get(relation2)});
        }
        this.presets.updatePresets(n3, n4, n5, n6, this.valueCount, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean bl = !collection.isEmpty();
        boolean bl2 = bl && this.propertyData.getRowCount() > 0;
        boolean bl3 = bl && this.membershipData.getRowCount() > 0;
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(bl2 || bl3);
        this.btnDel.setEnabled(bl2 || bl3);
        this.propertyTable.setVisible(bl2);
        this.propertyTable.getTableHeader().setVisible(bl2);
        this.selectSth.setVisible(!bl);
        pluginHook.setVisible(bl);
        if (string != null && (n2 = this.findRow(this.propertyData, string)) != -1) {
            this.propertyTable.changeSelection(n2, 0, false, false);
        } else if (relation != null && (n = this.findRow(this.membershipData, relation)) != -1) {
            this.membershipTable.changeSelection(n, 0, false, false);
        } else if (bl2) {
            this.propertyTable.changeSelection(0, 0, false, false);
        } else if (bl3) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.propertyData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Properties: {0} / Memberships: {1}", this.propertyData.getRowCount(), this.membershipData.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Properties / Memberships"));
        }
    }

    private void updateSelection() {
        if (Main.main.getCurrentDataSet() == null) {
            this.selectionChanged(Collections.emptyList());
        } else {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        this.updateSelection();
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.updateSelection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadIncompleteMembersAction
    extends AbstractAction {
        Relation relation;

        public DownloadIncompleteMembersAction(Relation relation) {
            this.relation = relation;
            this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download incomplete members"));
        }

        public Set<OsmPrimitive> buildSetOfIncompleteMembers(Relation relation) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            hashSet.addAll(relation.getIncompleteMembers());
            return hashSet;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.relation.hasIncompleteMembers()) {
                return;
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>();
            arrayList.add(this.relation);
            Main.worker.submit(new DownloadRelationMemberTask(arrayList, this.buildSetOfIncompleteMembers(this.relation), Main.map.mapView.getEditLayer()));
        }
    }

    class SelectRelationMembersAction
    extends AbstractAction {
        Relation relation;

        public SelectRelationMembersAction(Relation relation) {
            this.relation = relation;
            this.putValue("ShortDescription", I18n.tr("Select the members of selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("selectall"));
            this.putValue("Name", I18n.tr("Select members"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            hashSet.addAll(this.relation.getMemberPrimitives());
            Main.map.mapView.getEditLayer().data.setSelected(hashSet);
        }
    }

    static class SelectRelationAction
    extends AbstractAction {
        boolean selectionmode;
        Relation relation;

        public SelectRelationAction(Relation relation, boolean bl) {
            this.selectionmode = bl;
            this.relation = relation;
            if (bl) {
                this.putValue("Name", I18n.tr("Select relation"));
                this.putValue("ShortDescription", I18n.tr("Select relation in main selection."));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            } else {
                this.putValue("Name", I18n.tr("Select in relation list"));
                this.putValue("ShortDescription", I18n.tr("Select relation in relation list."));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "relationlist"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.selectionmode) {
                Main.map.mapView.getEditLayer().data.setSelected(this.relation);
            } else {
                Main.map.relationListDialog.selectRelation(this.relation);
                Main.map.relationListDialog.unfurlDialog();
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", I18n.tr("Go to OSM wiki for tag help (F1)"));
            this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
                String string2 = LanguageInfo.getWikiLanguagePrefix();
                final ArrayList<URI> arrayList = new ArrayList<URI>();
                if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                    String string3 = URLEncoder.encode(PropertiesDialog.this.propertyData.getValueAt(n, 0).toString(), "UTF-8");
                    String string4 = URLEncoder.encode((String)((Map)PropertiesDialog.this.propertyData.getValueAt(n, 1)).entrySet().iterator().next().getKey(), "UTF-8");
                    arrayList.add(new URI(String.format("%s%sTag:%s=%s", string, string2, string3, string4)));
                    arrayList.add(new URI(String.format("%sTag:%s=%s", string, string3, string4)));
                    arrayList.add(new URI(String.format("%s%sKey:%s", string, string2, string3)));
                    arrayList.add(new URI(String.format("%sKey:%s", string, string3)));
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                    String string5 = URLEncoder.encode(((Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0)).get("type"), "UTF-8");
                    if (string5 != null && !string5.equals("")) {
                        arrayList.add(new URI(String.format("%s%sRelation:%s", string, string2, string5)));
                        arrayList.add(new URI(String.format("%sRelation:%s", string, string5)));
                    }
                    arrayList.add(new URI(String.format("%s%sRelations", string, string2)));
                    arrayList.add(new URI(String.format("%sRelations", string)));
                } else {
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                }
                Main.worker.execute(new Runnable(){

                    public void run() {
                        try {
                            for (URI uRI : arrayList) {
                                HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
                                httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (httpURLConnection.getResponseCode() != 200) {
                                    System.out.println("INFO: " + uRI + " does not exist");
                                    httpURLConnection.disconnect();
                                    continue;
                                }
                                int n = httpURLConnection.getContentLength();
                                httpURLConnection.disconnect();
                                httpURLConnection = (HttpURLConnection)new URI(uRI.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title=")).toURL().openConnection();
                                httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (Math.abs(httpURLConnection.getContentLength() - n) > 200) {
                                    System.out.println("INFO: " + uRI + " is a mediawiki redirect");
                                    httpURLConnection.disconnect();
                                    continue;
                                }
                                System.out.println("INFO: browsing to " + uRI);
                                httpURLConnection.disconnect();
                                OpenBrowser.displayUrl(uRI.toString());
                                break;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the value of the selected key for all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                PropertiesDialog.this.propertyEdit(n);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                PropertiesDialog.this.membershipEdit(n);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1 ^ PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", I18n.tr("Add"));
            this.putValue("ShortDescription", I18n.tr("Add a new key/value pair to all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesDialog.this.add();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        protected void deleteProperty(int n) {
            String string = PropertiesDialog.this.propertyData.getValueAt(n, 0).toString();
            String string2 = null;
            int n2 = PropertiesDialog.this.propertyData.getRowCount();
            if (n2 > 1) {
                string2 = (String)PropertiesDialog.this.propertyData.getValueAt(n + 1 < n2 ? n + 1 : n - 1, 0);
            }
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, null));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (string2 != null) {
                PropertiesDialog.this.propertyTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.propertyData, string2), 0, false, false);
            }
        }

        protected void deleteFromRelation(int n) {
            Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
            Relation relation2 = null;
            int n2 = PropertiesDialog.this.membershipTable.getRowCount();
            if (n2 > 1) {
                relation2 = (Relation)PropertiesDialog.this.membershipData.getValueAt(n + 1 < n2 ? n + 1 : n - 1, 0);
            }
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change relation"), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")});
            extendedDialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            extendedDialog.setContent(I18n.tr("Really delete selection from relation {0}?", relation.getDisplayName(DefaultNameFormatter.getInstance())));
            extendedDialog.toggleEnable("delete_from_relation");
            extendedDialog.showDialog();
            if (extendedDialog.getValue() != 1) {
                return;
            }
            Relation relation3 = new Relation(relation);
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            for (OsmPrimitive osmPrimitive : collection) {
                relation3.removeMembersFor(osmPrimitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(relation, relation3));
            PropertiesDialog.this.propertyTable.clearSelection();
            if (relation2 != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.membershipData, relation2), 0, false, false);
            }
        }

        public DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected key in all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            Shortcut shortcut = Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Properties"), 81, 6);
            this.putValue("MnemonicKey", KeyEvent.getKeyText(shortcut.getAssignedKey()).charAt(0));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0) {
                int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                this.deleteProperty(n);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                this.deleteFromRelation(n);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0 || PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class MemberInfo {
        List<RelationMember> role = new ArrayList<RelationMember>();
        List<Integer> position = new ArrayList<Integer>();
        private String positionString = null;

        MemberInfo() {
        }

        void add(RelationMember relationMember, Integer n) {
            this.role.add(relationMember);
            this.position.add(n);
        }

        String getPositionString() {
            if (this.positionString == null) {
                Collections.sort(this.position);
                this.positionString = String.valueOf(this.position.get(0));
                int n = 0;
                int n2 = this.position.get(0);
                for (int i = 1; i < this.position.size(); ++i) {
                    int n3 = this.position.get(i);
                    if (n3 == n2 + 1) {
                        ++n;
                    } else {
                        if (n == 1) {
                            this.positionString = this.positionString + "," + String.valueOf(n2);
                        } else if (n > 1) {
                            this.positionString = this.positionString + "-" + String.valueOf(n2);
                        }
                        this.positionString = this.positionString + "-" + String.valueOf(n3);
                        n = 0;
                    }
                    n2 = n3;
                }
                if (n == 1) {
                    this.positionString = this.positionString + "," + String.valueOf(n2);
                } else if (n > 1) {
                    this.positionString = this.positionString + "-" + String.valueOf(n2);
                }
            }
            if (this.positionString.length() > 20) {
                this.positionString = this.positionString.substring(0, 17) + "...";
            }
            return this.positionString;
        }
    }

    public class DblClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.propertyTable.clearSelection();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.propertyEdit(n);
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.membershipEdit(n);
                }
            } else {
                PropertiesDialog.this.add();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.propertyTable.clearSelection();
            }
        }
    }
}

