/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationToChildReference {
    private Relation parent;
    private int position;
    private String role;
    private OsmPrimitive child;

    public static Set<RelationToChildReference> getRelationToChildReferences(OsmPrimitive osmPrimitive) {
        LinkedHashSet<Relation> linkedHashSet = OsmPrimitive.getFilteredSet(osmPrimitive.getReferrers(), Relation.class);
        HashSet<RelationToChildReference> hashSet = new HashSet<RelationToChildReference>();
        for (Relation relation : linkedHashSet) {
            for (int i = 0; i < relation.getMembersCount(); ++i) {
                if (!relation.getMember(i).refersTo(osmPrimitive)) continue;
                hashSet.add(new RelationToChildReference(relation, i, relation.getMember(i)));
            }
        }
        return hashSet;
    }

    public static Set<RelationToChildReference> getRelationToChildReferences(Collection<? extends OsmPrimitive> collection) {
        HashSet<RelationToChildReference> hashSet = new HashSet<RelationToChildReference>();
        for (OsmPrimitive osmPrimitive : collection) {
            hashSet.addAll(RelationToChildReference.getRelationToChildReferences(osmPrimitive));
        }
        return hashSet;
    }

    public RelationToChildReference(Relation relation, int n, String string, OsmPrimitive osmPrimitive) {
        this.parent = relation;
        this.position = n;
        this.role = string;
        this.child = osmPrimitive;
    }

    public RelationToChildReference(Relation relation, int n, RelationMember relationMember) {
        this.parent = relation;
        this.position = n;
        this.role = relationMember.getRole();
        this.child = relationMember.getMember();
    }

    public Relation getParent() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRole() {
        return this.role;
    }

    public OsmPrimitive getChild() {
        return this.child;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.child == null ? 0 : this.child.hashCode());
        n = 31 * n + (this.parent == null ? 0 : this.parent.hashCode());
        n = 31 * n + this.position;
        n = 31 * n + (this.role == null ? 0 : this.role.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationToChildReference relationToChildReference = (RelationToChildReference)object;
        if (this.child == null ? relationToChildReference.child != null : !this.child.equals(relationToChildReference.child)) {
            return false;
        }
        if (this.parent == null ? relationToChildReference.parent != null : !this.parent.equals(relationToChildReference.parent)) {
            return false;
        }
        if (this.position != relationToChildReference.position) {
            return false;
        }
        return !(this.role == null ? relationToChildReference.role != null : !this.role.equals(relationToChildReference.role));
    }
}

