/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceCommand
extends Command {
    private Command[] sequence;
    private boolean sequence_complete;
    private final String name;
    public boolean continueOnError = false;

    public SequenceCommand(String string, Collection<Command> collection) {
        this.name = string;
        this.sequence = new Command[collection.size()];
        this.sequence = collection.toArray(this.sequence);
    }

    public SequenceCommand(String string, Command ... commandArray) {
        this(string, Arrays.asList(commandArray));
    }

    @Override
    public boolean executeCommand() {
        for (int i = 0; i < this.sequence.length; ++i) {
            Command command = this.sequence[i];
            boolean bl = command.executeCommand();
            if (bl || this.continueOnError) continue;
            this.undoCommands(i - 1);
            return false;
        }
        this.sequence_complete = true;
        return true;
    }

    public Command getLastCommand() {
        if (this.sequence.length == 0) {
            return null;
        }
        return this.sequence[this.sequence.length - 1];
    }

    private void undoCommands(int n) {
        if (!this.sequence_complete) {
            return;
        }
        for (int i = n; i >= 0; --i) {
            this.sequence[i].undoCommand();
        }
    }

    @Override
    public void undoCommand() {
        this.undoCommands(this.sequence.length - 1);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        for (Command command : this.sequence) {
            command.fillModifiedData(collection, collection2, collection3);
        }
    }

    @Override
    public JLabel getDescription() {
        return new JLabel(I18n.tr("Sequence") + ": " + this.name, ImageProvider.get("data", "sequence"), 0);
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        return Arrays.asList(this.sequence);
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Command command : this.sequence) {
            hashSet.addAll(command.getParticipatingPrimitives());
        }
        return hashSet;
    }
}

