/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command
extends PseudoCommand {
    private Map<OsmPrimitive, PrimitiveData> cloneMap = new HashMap<OsmPrimitive, PrimitiveData>();
    private OsmDataLayer layer;

    public Command() {
        this.layer = Main.map.mapView.getEditLayer();
    }

    public Command(OsmDataLayer osmDataLayer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.layer = osmDataLayer;
    }

    public boolean executeCommand() {
        CloneVisitor cloneVisitor = new CloneVisitor();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        this.fillModifiedData(arrayList, arrayList, arrayList);
        for (OsmPrimitive osmPrimitive : arrayList) {
            osmPrimitive.visit(cloneVisitor);
        }
        this.cloneMap = cloneVisitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, PrimitiveData> entry : this.cloneMap.entrySet()) {
            OsmPrimitive osmPrimitive = entry.getKey();
            if (osmPrimitive.getDataSet() == null) continue;
            entry.getKey().load(entry.getValue());
        }
    }

    public boolean invalidBecauselayerRemoved(Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return this.layer == layer;
    }

    public PrimitiveData getOrig(OsmPrimitive osmPrimitive) {
        PrimitiveData primitiveData = this.cloneMap.get(osmPrimitive);
        if (primitiveData != null) {
            return primitiveData;
        }
        for (OsmPrimitive osmPrimitive2 : this.cloneMap.keySet()) {
            PrimitiveData primitiveData2 = this.cloneMap.get(osmPrimitive2);
        }
        return primitiveData;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.cloneMap.keySet();
    }

    @Override
    public Object getDescription() {
        return ((DefaultMutableTreeNode)this.description()).getUserObject();
    }

    @Deprecated
    public MutableTreeNode description() {
        return null;
    }

    private static final class CloneVisitor
    extends AbstractVisitor {
        public final Map<OsmPrimitive, PrimitiveData> orig = new LinkedHashMap<OsmPrimitive, PrimitiveData>();

        private CloneVisitor() {
        }

        public void visit(Node node) {
            this.orig.put(node, node.save());
        }

        public void visit(Way way) {
            this.orig.put(way, way.save());
        }

        public void visit(Relation relation) {
            this.orig.put(relation, relation.save());
        }
    }
}

