/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.AllFormatsImporter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenFileAction
extends DiskAccessAction {
    public OpenFileAction() {
        super(I18n.tr("Open..."), "open", I18n.tr("Open a file."), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...")), 79, 2));
        this.putValue("help", HelpUtil.ht("/Action/Open"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (jFileChooser == null) {
            return;
        }
        File[] fileArray = jFileChooser.getSelectedFiles();
        OpenFileTask openFileTask = new OpenFileTask(Arrays.asList(fileArray), jFileChooser.getFileFilter());
        openFileTask.setRecordHistory(true);
        Main.worker.submit(openFileTask);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!Main.applet);
    }

    public static void openFiles(List<File> list) {
        OpenFileAction.openFiles(list, false);
    }

    public static void openFiles(List<File> list, boolean bl) {
        OpenFileTask openFileTask = new OpenFileTask(list, null);
        openFileTask.setRecordHistory(bl);
        Main.worker.submit(openFileTask);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenFileTask
    extends PleaseWaitRunnable {
        private List<File> files;
        private List<File> successfullyOpenedFiles = new ArrayList<File>();
        private FileFilter fileFilter;
        private boolean cancelled;
        private boolean recordHistory = false;

        public OpenFileTask(List<File> list, FileFilter fileFilter, String string) {
            super(string, false);
            this.files = new ArrayList<File>(list);
            this.fileFilter = fileFilter;
        }

        public OpenFileTask(List<File> list, FileFilter fileFilter) {
            this(list, fileFilter, I18n.tr("Opening files"));
        }

        public void setRecordHistory(boolean bl) {
            this.recordHistory = bl;
        }

        public boolean isRecordHistory() {
            return this.recordHistory;
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
        }

        @Override
        protected void finish() {
        }

        protected void alertFilesNotMatchingWithImporter(Collection<File> collection, FileImporter fileImporter) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(I18n.trn("Cannot open {0} file with the file importer ''{1}''.", "Cannot open {0} files with the file importer ''{1}''.", collection.size(), collection.size(), fileImporter.filter.getDescription())).append("<br>");
            stringBuffer.append("<ul>");
            for (File file : collection) {
                stringBuffer.append("<li>").append(file.getAbsolutePath()).append("</li>");
            }
            stringBuffer.append("</ul>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuffer.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/Open#ImporterCantImportFiles"));
        }

        protected void alertFilesWithUnknownImporter(Collection<File> collection) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append(I18n.trn("Cannot open {0} file because no suitable file importer is available.", "Cannot open {0} files because no suitable file importer is available.", collection.size(), collection.size())).append("<br>");
            stringBuffer.append("<ul>");
            for (File file : collection) {
                stringBuffer.append("<li>").append(file.getAbsolutePath()).append("</li>");
            }
            stringBuffer.append("</ul>");
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, stringBuffer.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/Open#MissingImporterForFiles"));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            MultiMap<FileImporter, File> multiMap;
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            FileImporter fileImporter = null;
            for (FileImporter linkedList2 : ExtensionFileFilter.importers) {
                if (this.fileFilter != linkedList2.filter) continue;
                fileImporter = linkedList2;
            }
            if (fileImporter instanceof AllFormatsImporter) {
                fileImporter = null;
            }
            this.getProgressMonitor().setTicksCount(this.files.size());
            if (fileImporter != null) {
                multiMap = new LinkedList();
                LinkedList<File> linkedList = new LinkedList<File>();
                for (final File file : this.files) {
                    if (!fileImporter.acceptFile(file)) {
                        if (file.isDirectory()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Cannot open directory ''{0}''.<br>Please select a file.</html>", file.getAbsolutePath()), I18n.tr("Open file"), 0);
                                }
                            });
                            return;
                        }
                        multiMap.add(file);
                        continue;
                    }
                    linkedList.add(file);
                }
                if (!multiMap.isEmpty()) {
                    this.alertFilesNotMatchingWithImporter((Collection<File>)((Object)multiMap), fileImporter);
                }
                if (!linkedList.isEmpty()) {
                    this.importData(fileImporter, linkedList);
                }
            } else {
                ArrayList<File> arrayList;
                multiMap = new MultiMap<FileImporter, File>();
                LinkedList<File> linkedList = new LinkedList<File>();
                block2: for (File file : this.files) {
                    for (FileImporter fileImporter2 : ExtensionFileFilter.importers) {
                        if (!fileImporter2.acceptFile(file)) continue;
                        multiMap.put(fileImporter2, file);
                        continue block2;
                    }
                    linkedList.add(file);
                }
                if (!linkedList.isEmpty()) {
                    this.alertFilesWithUnknownImporter(linkedList);
                }
                ArrayList arrayList2 = new ArrayList(multiMap.keySet());
                Collections.sort(arrayList2);
                Collections.reverse(arrayList2);
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                HashSet hashSet = new HashSet();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    FileImporter fileImporter3 = (FileImporter)iterator.next();
                    arrayList = new ArrayList<File>(multiMap.get(fileImporter3));
                    this.importData(fileImporter3, arrayList);
                    ArrayList<File> arrayList3 = new ArrayList<File>(arrayList);
                    if (!this.recordHistory || fileImporter3.isBatchImporter()) continue;
                    arrayList3.removeAll(this.successfullyOpenedFiles);
                    for (File file : this.successfullyOpenedFiles) {
                        linkedHashSet.add(file.getCanonicalPath());
                    }
                    for (File file : arrayList3) {
                        hashSet.add(file.getCanonicalPath());
                    }
                }
                if (this.recordHistory) {
                    Collection<String> collection = Main.pref.getCollection("file-open.history");
                    linkedHashSet.addAll(collection);
                    linkedHashSet.removeAll(hashSet);
                    int n = Math.max(0, Main.pref.getInteger("file-open.history.max-size", 15));
                    arrayList = new ArrayList(Math.min(n, linkedHashSet.size()));
                    int n2 = 0;
                    for (String string : linkedHashSet) {
                        if (++n2 > n) break;
                        arrayList.add((File)((Object)string));
                    }
                    Main.pref.putCollection("file-open.history", arrayList);
                }
            }
        }

        public void importData(FileImporter fileImporter, List<File> list) {
            if (fileImporter.isBatchImporter()) {
                if (this.cancelled) {
                    return;
                }
                String string = list.size() == 1 ? I18n.tr("Opening 1 file...") : I18n.trn("Opening {0} file...", "Opening {0} files...", list.size(), list.size());
                this.getProgressMonitor().setCustomText(string);
                this.getProgressMonitor().indeterminateSubTask(string);
                if (fileImporter.importDataHandleExceptions(list, this.getProgressMonitor().createSubTaskMonitor(list.size(), false))) {
                    this.successfullyOpenedFiles.addAll(list);
                }
            } else {
                for (File file : list) {
                    if (this.cancelled) {
                        return;
                    }
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Opening file ''{0}'' ...", file.getAbsolutePath()));
                    if (!fileImporter.importDataHandleExceptions(file, this.getProgressMonitor().createSubTaskMonitor(1, false))) continue;
                    this.successfullyOpenedFiles.add(file);
                }
            }
        }

        public List<File> getSuccessfullyOpenedFiles() {
            return this.successfullyOpenedFiles;
        }
    }
}

