/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.MergeSourceBuildingVisitor;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeSelectionAction
extends AbstractMergeAction {
    public MergeSelectionAction() {
        super(I18n.tr("Merge selection"), "dialogs/mergedown", I18n.tr("Merge the currently selected objects into another layer"), Shortcut.registerShortcut("system:mergeselection", I18n.tr("Edit: {0}", I18n.tr("Merge selection")), 77, 2, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/MergeSelection"));
    }

    public void mergeSelected(DataSet dataSet) {
        List<Layer> list = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(MergeSelectionAction.getEditLayer());
        if (list.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(MergeSelectionAction.getEditLayer());
            return;
        }
        Layer layer = this.askTargetLayer(list);
        if (layer == null) {
            return;
        }
        MergeSourceBuildingVisitor mergeSourceBuildingVisitor = new MergeSourceBuildingVisitor(MergeSelectionAction.getEditLayer().data);
        ((OsmDataLayer)layer).mergeFrom(mergeSourceBuildingVisitor.build());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (MergeSelectionAction.getEditLayer() == null || MergeSelectionAction.getEditLayer().data.getSelected().isEmpty()) {
            return;
        }
        this.mergeSelected(MergeSelectionAction.getEditLayer().data);
    }

    @Override
    protected void updateEnabledState() {
        if (MergeSelectionAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MergeSelectionAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

