/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Main {
    public static Component parent;
    public static Main main;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static PrimitiveDeepCopy pasteBuffer;
    public static Layer pasteSource;
    public static MapFrame map;
    public static boolean applet;
    public static ToolbarPreferences toolbar;
    public UndoRedoHandler undoRedo = new UndoRedoHandler();
    public final MainMenu menu;
    public final OsmValidator validator;
    private GettingStarted gettingStarted = new GettingStarted();
    public static int log_level;
    public static PlatformHook platform;
    public static boolean isOpenjdk;
    protected static JPanel contentPanePrivate;
    @Deprecated
    public static final JPanel contentPane;
    public static JPanel panel;
    protected static Rectangle bounds;
    protected static int windowState;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = new OsmDataLayer.CommandQueueListener(){

        public void commandChanged(int n, int n2) {
            Main.this.menu.undo.setEnabled(n > 0);
            Main.this.menu.redo.setEnabled(n2 > 0);
        }
    };
    @Deprecated
    public static Projection proj;
    private static final ArrayList<WeakReference<ProjectionChangeListener>> listeners;

    public static boolean isDisplayingMapView() {
        if (map == null) {
            return false;
        }
        return Main.map.mapView != null;
    }

    public static void warn(String string) {
        if (log_level < 1) {
            return;
        }
        System.out.println(string);
    }

    public static void info(String string) {
        if (log_level < 2) {
            return;
        }
        System.out.println(string);
    }

    public static void debug(String string) {
        if (log_level < 3) {
            return;
        }
        System.out.println(string);
    }

    public final void setMapFrame(MapFrame mapFrame) {
        MapFrame mapFrame2 = map;
        panel.setVisible(false);
        panel.removeAll();
        if (mapFrame != null) {
            mapFrame.fillPanel(panel);
        } else {
            mapFrame2.destroy();
            panel.add((Component)this.gettingStarted, "Center");
        }
        panel.setVisible(true);
        this.redoUndoListener.commandChanged(0, 0);
        map = mapFrame;
        PluginHandler.notifyMapFrameChanged(mapFrame2, mapFrame);
    }

    public final void removeLayer(Layer layer) {
        if (map != null) {
            Main.map.mapView.removeLayer(layer);
            if (Main.map.mapView.getAllLayers().isEmpty()) {
                this.setMapFrame(null);
            }
        }
    }

    public Main() {
        main = this;
        isOpenjdk = System.getProperty("java.vm.name").toUpperCase().indexOf("OPENJDK") != -1;
        platform.startupHook();
        try {
            OsmApi.getOsmApi().initialize(null, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        contentPanePrivate.add((Component)panel, "Center");
        panel.add((Component)this.gettingStarted, "Center");
        this.menu = new MainMenu();
        this.undoRedo.listenerCommands.add(this.redoUndoListener);
        contentPanePrivate.add((Component)Main.toolbar.control, "North");
        Main.registerActionShortcut((Action)this.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help"), 112, 5));
        TaggingPresetPreference.initialize();
        MapPaintPreference.initialize();
        ImageryPreference.initialize();
        this.validator = new OsmValidator();
        MapView.addLayerChangeListener(this.validator);
        toolbar.refreshToolbarControl();
        Main.toolbar.control.updateUI();
        contentPanePrivate.updateUI();
    }

    public final void addLayer(Layer layer) {
        if (map == null) {
            MapFrame mapFrame = new MapFrame(contentPanePrivate);
            this.setMapFrame(mapFrame);
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction());
            mapFrame.setVisible(true);
            mapFrame.initializeDialogsPane();
            layer.addPropertyChangeListener(LayerListDialog.getInstance().getModel());
        }
        Main.map.mapView.addLayer(layer);
    }

    public boolean hasEditLayer() {
        return this.getEditLayer() != null;
    }

    public OsmDataLayer getEditLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getEditLayer();
    }

    public DataSet getCurrentDataSet() {
        if (!this.hasEditLayer()) {
            return null;
        }
        return this.getEditLayer().data;
    }

    public Layer getActiveLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getActiveLayer();
    }

    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        Main.registerActionShortcut(action, shortcut.getKeyStroke());
    }

    public static void registerActionShortcut(Action action, KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = contentPanePrivate.getInputMap(2);
        Object object = inputMap.get(keyStroke);
        if (object != null && !object.equals(action)) {
            System.out.println(String.format("Keystroke %s is already assigned to %s, will be overridden by %s", keyStroke, object, action));
        }
        inputMap.put(keyStroke, action);
        contentPanePrivate.getActionMap().put(action, action);
    }

    public static void unregisterActionShortcut(Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
    }

    public static void unregisterActionShortcut(JosmAction josmAction) {
        Main.unregisterActionShortcut(josmAction, josmAction.getShortcut());
    }

    public static void unregisterActionShortcut(Action action, Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
        contentPanePrivate.getActionMap().remove(action);
    }

    public static void preConstructorInit(Map<String, Collection<String>> map) {
        String string;
        Object object;
        ProjectionPreference.setProjection();
        try {
            object = platform.getDefaultStyle();
            string = pref.get("laf", (String)object);
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Look and Feel not found: " + string);
                pref.put("laf", (String)object);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.out.println("Look and Feel not supported: " + string);
                pref.put("laf", (String)object);
            }
            toolbar = new ToolbarPreferences();
            contentPanePrivate.updateUI();
            panel.updateUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        I18n.translateJavaInternalMessages();
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
        object = Toolkit.getDefaultToolkit().getScreenSize();
        string = null;
        string = map.containsKey("geometry") ? map.get("geometry").iterator().next() : pref.get("gui.geometry");
        if (string.length() != 0) {
            Matcher matcher = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(string);
            if (matcher.matches()) {
                int n = Integer.valueOf(matcher.group(1));
                int n2 = Integer.valueOf(matcher.group(2));
                int n3 = 0;
                int n4 = 0;
                if (matcher.group(3) != null) {
                    n3 = Integer.valueOf(matcher.group(5));
                    n4 = Integer.valueOf(matcher.group(7));
                    if (matcher.group(4).equals("-")) {
                        n3 = ((Dimension)object).width - n3 - n;
                    }
                    if (matcher.group(6).equals("-")) {
                        n4 = ((Dimension)object).height - n4 - n2;
                    }
                }
                if (n3 > Toolkit.getDefaultToolkit().getScreenSize().width - 10) {
                    n3 = 0;
                }
                if (n4 > Toolkit.getDefaultToolkit().getScreenSize().height - 10) {
                    n4 = 0;
                }
                bounds = new Rectangle(n3, n4, n, n2);
                if (!pref.get("gui.geometry").equals(string)) {
                    pref.put("gui.geometry", string);
                }
            } else {
                System.out.println("Ignoring malformed geometry: " + string);
            }
        }
        if (bounds == null) {
            bounds = !map.containsKey("no-maximize") ? new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height) : new Rectangle(1000, 740);
        }
    }

    public void postConstructorProcessCmdLine(Map<String, Collection<String>> map) {
        if (map.containsKey("download")) {
            Iterator<String> iterator = new ArrayList();
            for (String string : map.get("download")) {
                File file = null;
                switch (this.paramType(string)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(false, string);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(false, string);
                        break;
                    }
                    case fileUrl: {
                        try {
                            file = new File(new URI(string));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", string), I18n.tr("Warning"), 2);
                        }
                        if (file == null) break;
                        iterator.add((String)((Object)file));
                        break;
                    }
                    case fileName: {
                        file = new File(string);
                        iterator.add((String)((Object)file));
                    }
                }
            }
            if (!iterator.isEmpty()) {
                OpenFileAction.openFiles(iterator, true);
            }
        }
        if (map.containsKey("downloadgps")) {
            for (String string : map.get("downloadgps")) {
                switch (this.paramType(string)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(true, string);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(true, string);
                        break;
                    }
                    case fileUrl: 
                    case fileName: {
                        JOptionPane.showMessageDialog(parent, I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs"), I18n.tr("Warning"), 2);
                    }
                }
            }
        }
        if (map.containsKey("selection")) {
            for (String string : map.get("selection")) {
                SearchAction.search(string, SearchAction.SearchMode.add);
            }
        }
    }

    public static boolean saveUnsavedModifications() {
        if (map == null) {
            return true;
        }
        SaveLayersDialog saveLayersDialog = new SaveLayersDialog(parent);
        ArrayList<OsmDataLayer> arrayList = new ArrayList<OsmDataLayer>();
        for (OsmDataLayer osmDataLayer : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
            if (!osmDataLayer.requiresSaveToFile() && !osmDataLayer.requiresUploadToServer()) continue;
            arrayList.add(osmDataLayer);
        }
        saveLayersDialog.prepareForSavingAndUpdatingLayersBeforeExit();
        if (!arrayList.isEmpty()) {
            saveLayersDialog.getModel().populate(arrayList);
            saveLayersDialog.setVisible(true);
            switch (saveLayersDialog.getUserAction()) {
                case CANCEL: {
                    return false;
                }
                case PROCEED: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean exitJosm(boolean bl) {
        if (Main.saveUnsavedModifications()) {
            Main.saveGuiGeometry();
            if (Main.isDisplayingMapView()) {
                ArrayList<Layer> arrayList = new ArrayList<Layer>(Main.map.mapView.getAllLayers());
                for (Layer layer : arrayList) {
                    Main.map.mapView.removeLayer(layer);
                }
            }
            if (bl) {
                System.exit(0);
                return true;
            }
            return true;
        }
        return false;
    }

    private DownloadParamType paramType(String string) {
        if (string.startsWith("http:")) {
            return DownloadParamType.httpUrl;
        }
        if (string.startsWith("file:")) {
            return DownloadParamType.fileUrl;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 4) {
            return DownloadParamType.bounds;
        }
        return DownloadParamType.fileName;
    }

    private static void downloadFromParamHttp(boolean bl, String string) {
        Bounds bounds = OsmUrlToBounds.parse(string);
        if (bounds == null) {
            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", string), I18n.tr("Warning"), 2);
        } else {
            Main.downloadFromParamBounds(bl, bounds);
        }
    }

    private static void downloadFromParamBounds(boolean bl, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 4) {
            Bounds bounds = new Bounds(new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())), new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())));
            Main.downloadFromParamBounds(bl, bounds);
        }
    }

    private static void downloadFromParamBounds(boolean bl, Bounds bounds) {
        AbstractDownloadTask abstractDownloadTask = bl ? new DownloadGpsTask() : new DownloadOsmTask();
        Future<?> future = abstractDownloadTask.download(true, bounds, null);
        worker.execute(new PostDownloadHandler((DownloadTask)abstractDownloadTask, future));
    }

    public static void determinePlatformHook() {
        String string = System.getProperty("os.name");
        if (string == null) {
            System.err.println("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if (string.equals("Linux") || string.equals("Solaris") || string.equals("SunOS") || string.equals("AIX") || string.equals("FreeBSD") || string.equals("NetBSD") || string.equals("OpenBSD")) {
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            System.err.println("I don't know your operating system '" + string + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static void saveGuiGeometry() {
        String string = "";
        String string2 = null;
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)bounds.getWidth();
            int n2 = (int)bounds.getHeight();
            int n3 = (int)bounds.getX();
            int n4 = (int)bounds.getY();
            if (n > dimension.width) {
                n = dimension.width;
            }
            if (n2 > dimension.height) {
                n = dimension.height;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            string = n + "x" + n2 + "+" + n3 + "+" + n4;
            if (map != null && (string2 = Integer.toString(map.getToggleDlgWidth())).equals(Integer.toString(330))) {
                string2 = "";
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to get GUI geometry: " + exception);
            exception.printStackTrace();
        }
        boolean bl = (windowState & 6) != 0;
        pref.put("gui.maximized", bl);
        pref.put("gui.geometry", string);
        if (string2 != null) {
            pref.put("toggleDialogs.width", string2);
        }
    }

    public static void addListener() {
        parent.addComponentListener(new WindowPositionSizeListener());
        ((JFrame)parent).addWindowStateListener(new WindowPositionSizeListener());
    }

    public static void checkJava6() {
        String string = System.getProperty("java.version");
        if (string != null) {
            if (string.startsWith("1.6") || string.startsWith("6") || string.startsWith("1.7") || string.startsWith("7")) {
                return;
            }
            if (string.startsWith("1.5") || string.startsWith("5")) {
                JLabel jLabel = new JLabel("<html>" + I18n.tr("<h2>JOSM requires Java version 6.</h2>Detected Java version: {0}.<br>You can <ul><li>update your Java (JRE) or</li><li>use an earlier (Java 5 compatible) version of JOSM.</li></ul>More Info:", string) + "</html>");
                JTextArea jTextArea = new JTextArea("http://josm.openstreetmap.de/wiki/Help/SystemRequirements");
                jTextArea.setEditable(false);
                jTextArea.setBackground(panel.getBackground());
                JPanel jPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                jPanel.add((Component)jLabel, gridBagConstraints);
                jPanel.add((Component)jTextArea, gridBagConstraints);
                String string2 = I18n.tr("Exit JOSM");
                String string3 = I18n.tr("Continue, try anyway");
                int n = JOptionPane.showOptionDialog(null, jPanel, I18n.tr("Error"), 0, 0, null, new String[]{string2, string3}, string2);
                if (n == 0) {
                    System.exit(0);
                }
                return;
            }
        }
        System.err.println("Error: Could not recognize Java Version: " + string);
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection projection) {
        CheckParameterUtil.ensureParameterNotNull(projection);
        Projection projection2 = proj;
        proj = projection;
        Main.fireProjectionChanged(projection2, proj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fireProjectionChanged(Projection projection, Projection projection2) {
        if (!(projection2 == null ^ projection == null)) {
            if (projection2 == null) return;
            if (projection == null) return;
            if (projection2.getClass().getName().equals(projection.getClass().getName())) return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                if (weakReference.get() == null) {
                    iterator.remove();
                    continue;
                }
                ((ProjectionChangeListener)weakReference.get()).projectionChanged(projection, projection2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (projection2 == null) return;
            if (map == null) return;
            if (Main.map.mapView == null) return;
            Bounds bounds = Main.map.mapView.getRealBounds();
            clazz = bounds;
            if (clazz == null) return;
            Main.map.mapView.zoomTo((Bounds)((Object)clazz));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<ProjectionChangeListener> weakReference : listeners) {
                if (weakReference.get() != projectionChangeListener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            listeners.add(new WeakReference<ProjectionChangeListener>(projectionChangeListener));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                if (weakReference.get() != null && weakReference.get() != projectionChangeListener) continue;
                iterator.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        worker = Executors.newSingleThreadExecutor();
        pasteBuffer = new PrimitiveDeepCopy();
        applet = false;
        log_level = 2;
        contentPane = contentPanePrivate = new JPanel(new BorderLayout());
        panel = new JPanel(new BorderLayout());
        windowState = 0;
        listeners = new ArrayList();
    }

    private static class WindowPositionSizeListener
    extends WindowAdapter
    implements ComponentListener {
        private WindowPositionSizeListener() {
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            windowState = windowEvent.getNewState();
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        private void handleComponentEvent(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component instanceof JFrame && windowState == 0) {
                bounds = ((JFrame)component).getBounds();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DownloadParamType {
        httpUrl,
        fileUrl,
        bounds,
        fileName;

    }
}

