/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProvider {
    private static Map<String, ImageWrapper> cache = new HashMap<String, ImageWrapper>();
    static final double DEGREE_90 = 1.5707963267948966;

    public static ImageIcon get(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.getIfAvailable(string, string2);
        if (imageIcon == null) {
            String string3 = string2.indexOf(46) != -1 ? "" : ".png";
            throw new NullPointerException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", string2 + string3));
        }
        return imageIcon;
    }

    public static ImageIcon getIfAvailable(String string, String string2) {
        return ImageProvider.getIfAvailable((Collection<String>)null, null, string, string2);
    }

    public static ImageIcon getIfAvailable(String[] stringArray, String string, String string2, String string3) {
        return ImageProvider.getIfAvailable(Arrays.asList(stringArray), string, string2, string3);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3) {
        return ImageProvider.getIfAvailable(collection, string, string2, string3, null);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3, File file) {
        return ImageProvider.getIfAvailable(collection, string, string2, string3, file, false);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3, File file, boolean bl) {
        ImageWrapper imageWrapper = ImageProvider.getIfAvailableImpl(collection, string, string2, string3, file);
        if (imageWrapper == null) {
            return null;
        }
        if (bl && !imageWrapper.sanitized) {
            imageWrapper.img = ImageProvider.sanitize(imageWrapper.img);
            imageWrapper.sanitized = true;
        }
        return new ImageIcon(imageWrapper.img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageWrapper getIfAvailableImpl(Collection<String> collection, String string, String string2, String string3, File file) {
        ImageWrapper imageWrapper;
        String string4;
        if (string3 == null) {
            return null;
        }
        if (string3.startsWith("http://")) {
            ImageWrapper imageWrapper2 = cache.get(string3);
            if (imageWrapper2 == null) {
                try {
                    MirroredInputStream mirroredInputStream = new MirroredInputStream(string3, new File(Main.pref.getPreferencesDir(), "images").toString());
                    Image image = Toolkit.getDefaultToolkit().createImage(mirroredInputStream.getFile().toURI().toURL());
                    imageWrapper2 = new ImageWrapper(image, false);
                    cache.put(string3, imageWrapper2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return imageWrapper2;
        }
        if (string2 == null) {
            string2 = "";
        } else if (!string2.equals("")) {
            string2 = string2 + "/";
        }
        String string5 = string3.indexOf(46) != -1 ? "" : ".png";
        String string6 = string4 = string2 + string3 + string5;
        if (collection != null && collection.size() > 0) {
            string6 = "id:" + string + ":" + string4;
            if (file != null) {
                string6 = string6 + ":" + file.getName();
            }
        }
        if ((imageWrapper = cache.get(string6)) == null) {
            Object object;
            Object object2;
            block31: {
                if (file != null) {
                    object2 = null;
                    try {
                        int n;
                        object2 = new ZipFile(file);
                        object = ((ZipFile)object2).getEntry(string4);
                        if (object == null) break block31;
                        int n2 = 0;
                        byte[] byArray = new byte[n];
                        InputStream inputStream = null;
                        try {
                            int n3;
                            inputStream = ((ZipFile)object2).getInputStream((ZipEntry)object);
                            for (n = (int)((ZipEntry)object).getSize(); n > 0; n -= n3) {
                                n3 = inputStream.read(byArray, n2, n);
                                n2 += n3;
                            }
                            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                            imageWrapper = new ImageWrapper(image, false);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(I18n.tr("Warning: failed to handle zip file ''{0}''. Exception was: {1}", file.getName(), exception.toString()));
                    }
                    finally {
                        if (object2 != null) {
                            try {
                                ((ZipFile)object2).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            if (imageWrapper == null) {
                object2 = ImageProvider.getImageUrl(string4, collection);
                if (object2 == null) {
                    return null;
                }
                object = Toolkit.getDefaultToolkit().createImage((URL)object2);
                imageWrapper = new ImageWrapper((Image)object, false);
            }
            cache.put(string6, imageWrapper);
        }
        return imageWrapper;
    }

    private static URL getImageUrl(String string, String string2) {
        if (string.startsWith("resource://")) {
            String string3 = string.substring("resource://".length());
            for (ClassLoader classLoader : PluginHandler.getResourceClassLoaders()) {
                URL uRL = classLoader.getResource(string3 + string2);
                if (uRL == null) continue;
                return uRL;
            }
        } else {
            try {
                File file = new File(string, string2);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL getImageUrl(String string, Collection<String> collection) {
        URL uRL = null;
        if (collection != null) {
            for (String object : collection) {
                try {
                    uRL = ImageProvider.getImageUrl(object, string);
                    if (uRL == null) continue;
                    return uRL;
                }
                catch (SecurityException securityException) {
                    System.out.println(I18n.tr("Warning: failed to access directory ''{0}'' for security reasons. Exception was: {1}", object, securityException.toString()));
                }
            }
        }
        String string2 = Main.pref.getPreferencesDir() + "images";
        try {
            uRL = ImageProvider.getImageUrl(string2, string);
            if (uRL != null) {
                return uRL;
            }
        }
        catch (SecurityException securityException) {
            System.out.println(I18n.tr("Warning: failed to access directory ''{0}'' for security reasons. Exception was: {1}", string2, securityException.toString()));
        }
        uRL = ImageProvider.getImageUrl("resource://images/", string);
        if (uRL != null) {
            return uRL;
        }
        for (String string3 : Main.pref.getAllPossiblePreferenceDirs()) {
            uRL = ImageProvider.getImageUrl(string3 + "images", string);
            if (uRL != null) {
                return uRL;
            }
            uRL = ImageProvider.getImageUrl(string3, string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    public static ImageIcon get(String string) {
        return ImageProvider.get("", string);
    }

    public static Cursor getCursor(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.get("cursor", string);
        if (string2 != null) {
            imageIcon = ImageProvider.overlay((Icon)imageIcon, "cursor/modifier/" + string2, OverlayPosition.SOUTHEAST);
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), string.equals("crosshair") ? new Point(10, 10) : new Point(3, 2), "Cursor");
        return cursor;
    }

    public static ImageIcon overlay(Icon icon, String string, OverlayPosition overlayPosition) {
        return ImageProvider.overlay(icon, ImageProvider.get(string), overlayPosition);
    }

    public static ImageIcon overlay(Icon icon, Icon icon2, OverlayPosition overlayPosition) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = icon2.getIconWidth();
        int n4 = icon2.getIconHeight();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        int n5 = 0;
        int n6 = 0;
        switch (overlayPosition) {
            case NORTHWEST: {
                n5 = 0;
                n6 = 0;
                break;
            }
            case NORTHEAST: {
                n5 = n - n3;
                n6 = 0;
                break;
            }
            case SOUTHWEST: {
                n5 = 0;
                n6 = n2 - n4;
                break;
            }
            case SOUTHEAST: {
                n5 = n - n3;
                n6 = n2 - n4;
            }
        }
        icon2.paintIcon(null, graphics2D, n5, n6);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon createRotatedImage(Component component, Icon icon, double d) {
        int n;
        int n2;
        double d2 = d % 360.0;
        if (d != 0.0 && d2 == 0.0) {
            d2 = 360.0;
        }
        double d3 = d2 % 90.0;
        if (d2 != 0.0 && d3 == 0.0) {
            d3 = 90.0;
        }
        double d4 = Math.toRadians(d3);
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        if (d2 >= 0.0 && d2 <= 90.0 || d2 > 180.0 && d2 <= 270.0) {
            n2 = (int)((double)n3 * Math.sin(1.5707963267948966 - d4) + (double)n4 * Math.sin(d4));
            n = (int)((double)n3 * Math.sin(d4) + (double)n4 * Math.sin(1.5707963267948966 - d4));
        } else {
            n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d4) + (double)n3 * Math.sin(d4));
            n = (int)((double)n4 * Math.sin(d4) + (double)n3 * Math.sin(1.5707963267948966 - d4));
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        graphics2D.translate(n2 / 2, n / 2);
        graphics2D.rotate(Math.toRadians(d2));
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(component, graphics2D, -n5, -n6);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon get(OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        return ImageProvider.get("data", osmPrimitiveType.getAPIName());
    }

    public static BufferedImage sanitize(Image image) {
        new ImageIcon(image).getImage();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    private static class ImageWrapper {
        Image img;
        boolean sanitized;

        public ImageWrapper(Image image, boolean bl) {
            this.img = image;
            this.sanitized = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

