/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.LanguageInfo;

public class I18n {
    private static PluralMode pluralMode = PluralMode.MODE_NOTONE;
    private static String loadedCode = "en";
    private static final String[] javaInternalMessageKeys = new String[]{"FileChooser.detailsViewActionLabelText", "FileChooser.detailsViewButtonAccessibleName", "FileChooser.detailsViewButtonToolTipText", "FileChooser.fileAttrHeaderText", "FileChooser.fileDateHeaderText", "FileChooser.fileNameHeaderText", "FileChooser.fileNameLabelText", "FileChooser.fileSizeHeaderText", "FileChooser.fileTypeHeaderText", "FileChooser.filesOfTypeLabelText", "FileChooser.homeFolderAccessibleName", "FileChooser.homeFolderToolTipText", "FileChooser.listViewActionLabelText", "FileChooser.listViewButtonAccessibleName", "FileChooser.listViewButtonToolTipText", "FileChooser.lookInLabelText", "FileChooser.newFolderAccessibleName", "FileChooser.newFolderActionLabelText", "FileChooser.newFolderToolTipText", "FileChooser.refreshActionLabelText", "FileChooser.saveInLabelText", "FileChooser.upFolderAccessibleName", "FileChooser.upFolderToolTipText", "FileChooser.viewMenuLabelText", "FileChooser.acceptAllFileFilterText", "FileChooser.cancelButtonText", "FileChooser.cancelButtonToolTipText", "FileChooser.deleteFileButtonText", "FileChooser.filesLabelText", "FileChooser.filterLabelText", "FileChooser.foldersLabelText", "FileChooser.newFolderButtonText", "FileChooser.newFolderDialogText", "FileChooser.openButtonText", "FileChooser.openButtonToolTipText", "FileChooser.openDialogTitleText", "FileChooser.pathLabelText", "FileChooser.renameFileButtonText", "FileChooser.renameFileDialogText", "FileChooser.renameFileErrorText", "FileChooser.renameFileErrorTitle", "FileChooser.saveButtonText", "FileChooser.saveButtonToolTipText", "FileChooser.saveDialogTitleText", "FileChooser.enterFileNameLabelText", "FileChooser.helpButtonText", "FileChooser.helpButtonToolTipText", "FileChooser.updateButtonText", "FileChooser.updateButtonToolTipText", "GTKColorChooserPanel.blueText", "GTKColorChooserPanel.colorNameText", "GTKColorChooserPanel.greenText", "GTKColorChooserPanel.hueText", "GTKColorChooserPanel.nameText", "GTKColorChooserPanel.redText", "GTKColorChooserPanel.saturationText", "GTKColorChooserPanel.valueText", "OptionPane.okButtonText", "OptionPane.yesButtonText", "OptionPane.noButtonText", "OptionPane.cancelButtonText"};
    private static HashMap<String, String> strings = null;
    private static HashMap<String, String[]> pstrings = null;
    private static HashMap<String, PluralMode> languages = new HashMap();

    public static final String tr(String string, Object ... objectArray) {
        return MessageFormat.format(I18n.gettext(string, null), objectArray);
    }

    public static final String tr(String string) {
        if (string == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext(string, null), new Object[]{null});
    }

    public static final String trc(String string, String string2) {
        if (string == null) {
            return I18n.tr(string2);
        }
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext(string2, string), new Object[]{null});
    }

    public static final String trc_lazy(String string, String string2) {
        if (string == null) {
            return I18n.tr(string2);
        }
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext_lazy(string2, string), new Object[]{null});
    }

    public static final String marktr(String string) {
        return string;
    }

    public static final String marktrc(String string, String string2) {
        return string2;
    }

    public static final String trn(String string, String string2, long l, Object ... objectArray) {
        return MessageFormat.format(I18n.gettextn(string, string2, null, l), objectArray);
    }

    public static final String trn(String string, String string2, long l) {
        return MessageFormat.format(I18n.gettextn(string, string2, null, l), new Object[]{null});
    }

    public static final String trnc(String string, String string2, String string3, long l, Object ... objectArray) {
        return MessageFormat.format(I18n.gettextn(string2, string3, string, l), objectArray);
    }

    public static final String trnc(String string, String string2, String string3, long l) {
        return MessageFormat.format(I18n.gettextn(string2, string3, string, l), new Object[]{null});
    }

    private static final String gettext(String string, String string2) {
        String[] stringArray;
        int n;
        if (string2 == null && string.startsWith("_:") && (n = string.indexOf("\n")) >= 0) {
            string2 = string.substring(2, n - 1);
            string = string.substring(n + 1);
        }
        if (strings != null && (stringArray = strings.get(string2 == null ? string : "_:" + string2 + "\n" + string)) != null) {
            return stringArray;
        }
        if (pstrings != null && (stringArray = pstrings.get(string2 == null ? string : "_:" + string2 + "\n" + string)) != null) {
            return stringArray[0];
        }
        return string;
    }

    private static final String gettext_lazy(String string, String string2) {
        String[] stringArray;
        int n;
        if (string2 == null && string.startsWith("_:") && (n = string.indexOf("\n")) >= 0) {
            string2 = string.substring(2, n - 1);
            string = string.substring(n + 1);
        }
        if (strings != null && (stringArray = strings.get(string2 == null ? string : "_:" + string2 + "\n" + string)) != null) {
            return stringArray;
        }
        if (pstrings != null && (stringArray = pstrings.get(string2 == null ? string : "_:" + string2 + "\n" + string)) != null) {
            return stringArray[0];
        }
        return I18n.gettext(string, null);
    }

    private static final String gettextn(String string, String string2, String string3, long l) {
        int n;
        if (string3 == null && string.startsWith("_:") && (n = string.indexOf("\n")) >= 0) {
            string3 = string.substring(2, n - 1);
            string = string.substring(n + 1);
        }
        if (pstrings != null) {
            n = I18n.pluralEval(l);
            String[] stringArray = pstrings.get(string3 == null ? string : "_:" + string3 + "\n" + string);
            if (stringArray != null && stringArray.length > n) {
                return stringArray[n];
            }
        }
        return l == 1L ? string : string2;
    }

    public static final Locale[] getAvailableTranslations() {
        Vector<Locale> vector = new Vector<Locale>();
        if (Main.class.getResource("/data/en.lang") != null) {
            for (String string : languages.keySet()) {
                if (Main.class.getResource("/data/" + string + ".lang") == null) continue;
                vector.add(LanguageInfo.getLocale(string));
            }
        }
        vector.add(Locale.ENGLISH);
        Locale[] localeArray = new Locale[vector.size()];
        localeArray = vector.toArray(localeArray);
        Arrays.sort(localeArray, new Comparator<Locale>(){

            @Override
            public int compare(Locale locale, Locale locale2) {
                return locale.toString().compareTo(locale2.toString());
            }
        });
        return localeArray;
    }

    public static boolean hasCode(String string) {
        return languages.containsKey(string);
    }

    public static void init() {
        languages.put("ar", PluralMode.MODE_AR);
        languages.put("bg", PluralMode.MODE_NOTONE);
        languages.put("cs", PluralMode.MODE_CS);
        languages.put("da", PluralMode.MODE_NOTONE);
        languages.put("de", PluralMode.MODE_NOTONE);
        languages.put("el", PluralMode.MODE_NOTONE);
        languages.put("en_AU", PluralMode.MODE_NOTONE);
        languages.put("en_GB", PluralMode.MODE_NOTONE);
        languages.put("es", PluralMode.MODE_NOTONE);
        languages.put("et", PluralMode.MODE_NOTONE);
        languages.put("eu", PluralMode.MODE_NOTONE);
        languages.put("fi", PluralMode.MODE_NOTONE);
        languages.put("fr", PluralMode.MODE_GREATERONE);
        languages.put("gl", PluralMode.MODE_NOTONE);
        languages.put("he", PluralMode.MODE_NOTONE);
        languages.put("is", PluralMode.MODE_NOTONE);
        languages.put("it", PluralMode.MODE_NOTONE);
        languages.put("ja", PluralMode.MODE_NONE);
        languages.put("nb", PluralMode.MODE_NOTONE);
        languages.put("nl", PluralMode.MODE_NOTONE);
        languages.put("pl", PluralMode.MODE_PL);
        languages.put("pt_BR", PluralMode.MODE_GREATERONE);
        languages.put("ru", PluralMode.MODE_RU);
        languages.put("sk", PluralMode.MODE_SK);
        languages.put("sv", PluralMode.MODE_NOTONE);
        languages.put("tr", PluralMode.MODE_NONE);
        languages.put("uk", PluralMode.MODE_RU);
        languages.put("zh_CN", PluralMode.MODE_NONE);
        languages.put("zh_TW", PluralMode.MODE_NONE);
        if (!I18n.load(Locale.getDefault().toString())) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTexts(File file) {
        if (loadedCode.equals("en")) {
            return;
        }
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        FileInputStream fileInputStream2 = null;
        ZipInputStream zipInputStream2 = null;
        String string = "data/en.lang";
        String string2 = "data/" + loadedCode + ".lang";
        try {
            String string3;
            ZipEntry zipEntry;
            fileInputStream = new FileInputStream(file);
            zipInputStream = new JarInputStream(fileInputStream);
            boolean bl = false;
            while (!bl && (zipEntry = ((JarInputStream)zipInputStream).getNextEntry()) != null) {
                string3 = zipEntry.getName();
                if (!string3.equals(string)) continue;
                bl = true;
            }
            if (bl) {
                fileInputStream2 = new FileInputStream(file);
                zipInputStream2 = new JarInputStream(fileInputStream2);
                bl = false;
                while (!bl && (zipEntry = ((JarInputStream)zipInputStream2).getNextEntry()) != null) {
                    string3 = zipEntry.getName();
                    if (!string3.equals(string2)) continue;
                    bl = true;
                }
                if (bl) {
                    I18n.load(zipInputStream, zipInputStream2, true);
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (zipInputStream2 != null) {
                    zipInputStream2.close();
                }
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean load(String string) {
        if (string.equals("en") || string.equals("en_US")) {
            strings = null;
            pstrings = null;
            loadedCode = "en";
            pluralMode = PluralMode.MODE_NOTONE;
            return true;
        }
        URL uRL = Main.class.getResource("/data/en.lang");
        if (uRL == null) {
            return false;
        }
        URL uRL2 = Main.class.getResource("/data/" + string + ".lang");
        if (uRL2 == null || !languages.containsKey(string)) {
            int n = string.indexOf(95);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((uRL2 = Main.class.getResource("/data/" + string + ".lang")) == null || !languages.containsKey(string)) {
                return false;
            }
        }
        try {
            if (I18n.load(uRL.openStream(), uRL2.openStream(), false)) {
                pluralMode = languages.get(string);
                loadedCode = string;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static boolean load(InputStream inputStream, InputStream inputStream2, boolean bl) {
        HashMap<String, Object> hashMap;
        HashMap<String, String> hashMap2;
        if (bl) {
            hashMap2 = strings;
            hashMap = pstrings;
        } else {
            hashMap2 = new HashMap();
            hashMap = new HashMap();
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(inputStream2);
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[2];
            boolean bl2 = false;
            byte[] byArray3 = new byte[4096];
            while (true) {
                Object object;
                int n;
                int n2;
                if (bl2) {
                    n2 = ((InputStream)bufferedInputStream).read();
                    n = ((InputStream)bufferedInputStream2).read();
                    if (n2 == -1 && n != -1 || n2 != -1 && n == -1) {
                        return false;
                    }
                    if (n2 != -1) {
                        int n3;
                        int n4;
                        int n5;
                        String[] stringArray = new String[n2];
                        object = new String[n];
                        for (n5 = 0; n5 < n2; ++n5) {
                            n4 = ((InputStream)bufferedInputStream).read(byArray);
                            if (n4 != 2) {
                                return false;
                            }
                            n4 = (byArray[0] < 0 ? 256 + byArray[0] : byArray[0]) * 256 + (byArray[1] < 0 ? 256 + byArray[1] : byArray[1]);
                            if (n4 > byArray3.length) {
                                byArray3 = new byte[n4];
                            }
                            if ((n3 = ((InputStream)bufferedInputStream).read(byArray3, 0, n4)) != n4) {
                                return false;
                            }
                            stringArray[n5] = new String(byArray3, 0, n4, "utf-8");
                        }
                        for (n5 = 0; n5 < n; ++n5) {
                            n4 = ((InputStream)bufferedInputStream2).read(byArray2);
                            if (n4 != 2) {
                                return false;
                            }
                            n4 = (byArray2[0] < 0 ? 256 + byArray2[0] : byArray2[0]) * 256 + (byArray2[1] < 0 ? 256 + byArray2[1] : byArray2[1]);
                            if (n4 > byArray3.length) {
                                byArray3 = new byte[n4];
                            }
                            if ((n3 = ((InputStream)bufferedInputStream2).read(byArray3, 0, n4)) != n4) {
                                return false;
                            }
                            object[n5] = new String(byArray3, 0, n4, "utf-8");
                        }
                        if (n <= 0 || hashMap.containsKey(stringArray[0])) continue;
                        hashMap.put(stringArray[0], object);
                        continue;
                    }
                } else {
                    n2 = ((InputStream)bufferedInputStream).read(byArray);
                    if (n2 != (n = ((InputStream)bufferedInputStream2).read(byArray2))) {
                        return false;
                    }
                    if (n2 != -1) {
                        int n6;
                        if (n2 != 2) {
                            return false;
                        }
                        n2 = (byArray[0] < 0 ? 256 + byArray[0] : byArray[0]) * 256 + (byArray[1] < 0 ? 256 + byArray[1] : byArray[1]);
                        n = (byArray2[0] < 0 ? 256 + byArray2[0] : byArray2[0]) * 256 + (byArray2[1] < 0 ? 256 + byArray2[1] : byArray2[1]);
                        if (n2 == 65535) {
                            bl2 = true;
                            if (n == 65535) continue;
                            return false;
                        }
                        if (n2 > byArray3.length) {
                            byArray3 = new byte[n2];
                        }
                        if (n > byArray3.length) {
                            byArray3 = new byte[n];
                        }
                        if ((n6 = ((InputStream)bufferedInputStream).read(byArray3, 0, n2)) != n2) {
                            return false;
                        }
                        object = new String(byArray3, 0, n2, "utf-8");
                        if (n == 0) continue;
                        n6 = ((InputStream)bufferedInputStream2).read(byArray3, 0, n);
                        if (n6 != n) {
                            return false;
                        }
                        String string = new String(byArray3, 0, n, "utf-8");
                        if (hashMap2.containsKey(object)) continue;
                        hashMap2.put((String)object, string);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (!hashMap2.isEmpty()) {
            strings = hashMap2;
            pstrings = hashMap;
            return true;
        }
        return false;
    }

    public static void set(String string) {
        if (string != null) {
            Locale locale = LanguageInfo.getLocale(string);
            if (I18n.load(LanguageInfo.getJOSMLocaleCode(locale))) {
                Locale.setDefault(locale);
            } else if (!locale.getLanguage().equals("en")) {
                System.out.println(I18n.tr("Unable to find translation for the locale {0}. Reverting to {1}.", locale.getDisplayName(), Locale.getDefault().getDisplayName()));
            } else {
                strings = null;
                pstrings = null;
            }
        }
    }

    public static void translateJavaInternalMessages() {
        Locale locale = Locale.getDefault();
        JFileChooser.setDefaultLocale(locale);
        JColorChooser.setDefaultLocale(locale);
        for (String string : javaInternalMessageKeys) {
            String string2 = UIManager.getString((Object)string, Locale.US);
            String string3 = UIManager.getString((Object)string, locale);
            if (string2 == null || !string2.equals(string3)) continue;
            UIManager.put(string, I18n.tr(string2));
        }
    }

    private static int pluralEval(long l) {
        switch (pluralMode) {
            case MODE_NOTONE: {
                return l != 1L ? 1 : 0;
            }
            case MODE_NONE: {
                return 0;
            }
            case MODE_GREATERONE: {
                return l > 1L ? 1 : 0;
            }
            case MODE_CS: {
                return l == 1L ? 0 : (l >= 2L && l <= 4L ? 1 : 2);
            }
            case MODE_AR: {
                return l == 0L ? 0 : (l == 1L ? 1 : (l == 2L ? 2 : (l % 100L >= 3L && l % 100L <= 10L ? 3 : (l % 100L >= 11L && l % 100L <= 99L ? 4 : 5))));
            }
            case MODE_PL: {
                return l == 1L ? 0 : (l % 10L >= 2L && l % 10L <= 4L && (l % 100L < 10L || l % 100L >= 20L) ? 1 : 2);
            }
            case MODE_RU: {
                return l % 10L == 1L && l % 100L != 11L ? 0 : (l % 10L >= 2L && l % 10L <= 4L && (l % 100L < 10L || l % 100L >= 20L) ? 1 : 2);
            }
            case MODE_SK: {
                return l == 1L ? 1 : (l >= 2L && l <= 4L ? 2 : 0);
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PluralMode {
        MODE_NOTONE,
        MODE_NONE,
        MODE_GREATERONE,
        MODE_CS,
        MODE_AR,
        MODE_PL,
        MODE_RU,
        MODE_SK;

    }
}

