/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class ImageryHandler
extends RequestHandler {
    public static final String command = "imagery";
    public static final String permissionKey = "remotecontrol.permission.imagery";
    public static final boolean permissionDefault = true;

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load an imagery layer from the following URL:") + "<br>" + (String)this.args.get("url");
    }

    protected String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return new PermissionPrefWithDefault(permissionKey, true, "RemoteControl: import forbidden by preferences");
    }

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        if (Main.map == null) {
            throw new RequestHandler.RequestHandlerErrorException();
        }
        String string = (String)this.args.get("url");
        String string2 = (String)this.args.get("title");
        if (string2 == null || string2.length() == 0) {
            string2 = I18n.tr("Remote imagery");
        }
        String string3 = (String)this.args.get("cookies");
        ImageryLayer imageryLayer = ImageryLayer.create(new ImageryInfo(string2, string, string3));
        Main.main.addLayer(imageryLayer);
    }

    public void parseArgs() {
        int n;
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.request, "&?");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf("=");
            if (n2 <= -1) continue;
            string = string2.substring(0, n2);
            if ("url".equals(string)) break;
            String string3 = string2.substring(n2 + 1);
            try {
                string3 = URLDecoder.decode(string3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            hashMap.put(string, string3);
        }
        if ((n = this.request.indexOf("&url=")) < 0) {
            n = this.request.indexOf("?url=");
        }
        if (n >= 0) {
            String string4 = this.request.substring(n + 5);
            string = (String)hashMap.get("urldecode");
            if (string == null || Boolean.valueOf(string).booleanValue()) {
                try {
                    string4 = URLDecoder.decode(string4, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            hashMap.put("url", string4);
        }
        this.args = hashMap;
    }
}

