/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyleSource
extends SourceEntry {
    private List<Throwable> errors = new ArrayList<Throwable>();
    public File zipIcons;
    private ImageIcon imageIcon;
    public String icon;
    private static ImageIcon defaultIcon;

    public StyleSource(String string, String string2, String string3) {
        super(string, string2, string3, true);
    }

    public StyleSource(SourceEntry sourceEntry) {
        super(sourceEntry.url, sourceEntry.name, sourceEntry.title, sourceEntry.active);
    }

    public abstract void apply(MultiCascade var1, OsmPrimitive var2, double var3, OsmPrimitive var5, boolean var6);

    public abstract void loadStyleSource();

    public abstract InputStream getSourceInputStream() throws IOException;

    public void logError(Throwable throwable) {
        this.errors.add(throwable);
    }

    public Collection<Throwable> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    protected void init() {
        this.errors.clear();
        this.imageIcon = null;
        this.icon = null;
    }

    private static ImageIcon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = ImageProvider.get("dialogs/mappaint", "pencil");
        }
        return defaultIcon;
    }

    protected ImageIcon getSourceIcon() {
        if (this.imageIcon == null) {
            if (this.icon != null) {
                this.imageIcon = MapPaintStyles.getIcon(new MapPaintStyles.IconReference(this.icon, this), false);
            }
            if (this.imageIcon == null) {
                this.imageIcon = StyleSource.getDefaultIcon();
            }
        }
        return this.imageIcon;
    }

    public final ImageIcon getIcon() {
        if (this.getErrors().isEmpty()) {
            return this.getSourceIcon();
        }
        return ImageProvider.overlay((Icon)this.getSourceIcon(), "dialogs/mappaint/error_small", ImageProvider.OverlayPosition.SOUTHEAST);
    }

    public String getToolTipText() {
        if (this.errors.isEmpty()) {
            return null;
        }
        return I18n.trn("There was an error when loading this style. Select ''Info'' from the right click menu for details.", "There were {0} errors when loading this style. Select ''Info'' from the right click menu for details.", this.errors.size(), this.errors.size());
    }

    public Color getBackgroundColorOverride() {
        return null;
    }
}

