/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.ScanexTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMSLayer
extends ImageryLayer
implements ImageObserver,
TileLoaderListener {
    public static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    public static final int DEFAULT_MAX_ZOOM = 20;
    public static final int DEFAULT_MIN_ZOOM = 2;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.tms.default_autozoom", true);
    public static final BooleanProperty PROP_DEFAULT_AUTOLOAD = new BooleanProperty("imagery.tms.default_autoload", true);
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", 2);
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", 20);
    public static final BooleanProperty PROP_ADD_TO_SLIPPYMAP_CHOOSER = new BooleanProperty("imagery.tms.add_to_slippymap_chooser", true);
    public static final StringProperty PROP_TILECACHE_DIR;
    protected MemoryTileCache tileCache;
    protected TileSource tileSource;
    protected TileLoader tileLoader;
    JobDispatcher jobDispatcher = JobDispatcher.getInstance();
    HashSet<Tile> tileRequestsOutstanding = new HashSet();
    public int currentZoomLevel;
    private Tile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;
    JCheckBoxMenuItem autoZoomPopup;
    JCheckBoxMenuItem autoLoadPopup;
    Tile showMetadataTile;
    private Image attrImage;
    private String attrTermsUrl;
    private Rectangle attrImageBounds;
    private Rectangle attrToUBounds;
    private Rectangle attrTextBounds;
    private static final Font InfoFont;
    private static final Font ATTR_FONT;
    private static final Font ATTR_LINK_FONT;
    protected boolean autoZoom;
    protected boolean autoLoad;
    Image lastScaledImage = null;
    private final TileSet nullTileSet = new TileSet((LatLon)null, (LatLon)null, 0);

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean bl) {
        if (tile.hasError()) {
            bl = false;
            tile.setImage(null);
        }
        if (this.sharpenLevel != 0 && bl) {
            tile.setImage(this.sharpenImage(tile.getImage()));
        }
        tile.setLoaded(true);
        this.needRedraw = true;
        Main.map.repaint(100L);
        this.tileRequestsOutstanding.remove(tile);
    }

    @Override
    public TileCache getTileCache() {
        return this.tileCache;
    }

    void clearTileCache() {
        this.tileCache = new MemoryTileCache();
        this.tileCache.setCacheSize(200);
    }

    void redraw() {
        this.needRedraw = true;
        Main.map.repaint();
    }

    static int checkMaxZoomLvl(int n, TileSource tileSource) {
        if (n > 30) {
            n = 30;
        }
        if (n < PROP_MIN_ZOOM_LVL.get()) {
            n = PROP_MIN_ZOOM_LVL.get();
        }
        if (tileSource != null && tileSource.getMaxZoom() != 0 && tileSource.getMaxZoom() < n) {
            n = tileSource.getMaxZoom();
        }
        return n;
    }

    public static int getMaxZoomLvl(TileSource tileSource) {
        return TMSLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), tileSource);
    }

    public static void setMaxZoomLvl(int n) {
        n = TMSLayer.checkMaxZoomLvl(n, null);
        PROP_MAX_ZOOM_LVL.put(n);
    }

    static int checkMinZoomLvl(int n, TileSource tileSource) {
        if (n < 2) {
            n = 2;
        }
        if (n > PROP_MAX_ZOOM_LVL.get()) {
            n = TMSLayer.getMaxZoomLvl(tileSource);
        }
        if (tileSource != null && tileSource.getMinZoom() > n) {
            n = tileSource.getMinZoom();
        }
        return n;
    }

    public static int getMinZoomLvl(TileSource tileSource) {
        return TMSLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), tileSource);
    }

    public static void setMinZoomLvl(int n) {
        n = TMSLayer.checkMinZoomLvl(n, null);
        PROP_MIN_ZOOM_LVL.put(n);
    }

    public static TileSource getTileSource(ImageryInfo imageryInfo) {
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.TMS) {
            if (ImageryInfo.isUrlWithPatterns(imageryInfo.getUrl())) {
                TemplatedTMSTileSource templatedTMSTileSource = new TemplatedTMSTileSource(imageryInfo.getName(), imageryInfo.getUrl(), imageryInfo.getMinZoom(), imageryInfo.getMaxZoom());
                imageryInfo.setAttribution(templatedTMSTileSource);
                return templatedTMSTileSource;
            }
            TMSTileSource tMSTileSource = new TMSTileSource(imageryInfo.getName(), imageryInfo.getUrl(), imageryInfo.getMinZoom(), imageryInfo.getMaxZoom());
            imageryInfo.setAttribution(tMSTileSource);
            return tMSTileSource;
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.BING) {
            return new BingAerialTileSource();
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            return new ScanexTileSource(imageryInfo.getUrl());
        }
        return null;
    }

    private void initTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
        boolean bl = tileSource.requiresAttribution();
        if (bl) {
            this.attrImage = tileSource.getAttributionImage();
            this.attrTermsUrl = tileSource.getTermsOfUseURL();
        }
        this.currentZoomLevel = this.getBestZoom();
        this.clearTileCache();
        String string = PROP_TILECACHE_DIR.get();
        this.tileLoader = null;
        if (string != null && !string.isEmpty()) {
            try {
                this.tileLoader = new OsmFileCacheTileLoader(this, new File(string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tileLoader == null) {
            this.tileLoader = new OsmTileLoader(this);
        }
    }

    @Override
    public void setOffset(double d, double d2) {
        super.setOffset(d, d2);
        this.needRedraw = true;
    }

    private double getScaleFactor(int n) {
        if (Main.map == null || Main.map.mapView == null) {
            return 1.0;
        }
        MapView mapView = Main.map.mapView;
        LatLon latLon = mapView.getLatLon(0, 0);
        LatLon latLon2 = mapView.getLatLon(mapView.getWidth(), mapView.getHeight());
        double d = this.tileSource.lonToTileX(latLon.lon(), n);
        double d2 = this.tileSource.latToTileY(latLon.lat(), n);
        double d3 = this.tileSource.lonToTileX(latLon2.lon(), n);
        double d4 = this.tileSource.latToTileY(latLon2.lat(), n);
        int n2 = mapView.getWidth() * mapView.getHeight();
        double d5 = Math.abs((d4 - d2) * (d3 - d) * (double)this.tileSource.getTileSize() * (double)this.tileSource.getTileSize());
        if (n2 == 0 || d5 == 0.0) {
            return 1.0;
        }
        return (double)n2 / d5;
    }

    private int getBestZoom() {
        double d = this.getScaleFactor(1);
        double d2 = Math.log(d) / Math.log(2.0) / 2.0 + 1.0;
        int n = (int)Math.round(d2);
        if (n > this.getMaxZoomLvl()) {
            return this.getMaxZoomLvl();
        }
        if (n < this.getMinZoomLvl()) {
            return this.getMinZoomLvl();
        }
        return n;
    }

    public TMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        if (!this.isProjectionSupported(Main.getProjection())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("TMS layers do not support the projection {0}.\n{1}\nChange the projection or remove the layer.", Main.getProjection().toCode(), this.nameSupportedProjections()), I18n.tr("Warning"), 2);
        }
        this.setBackgroundLayer(true);
        this.setVisible(true);
        TileSource tileSource = TMSLayer.getTileSource(imageryInfo);
        if (tileSource == null) {
            throw new IllegalStateException("cannot create TMSLayer with non-TMS ImageryInfo");
        }
        this.initTileSource(tileSource);
        this.tileOptionMenu = new JPopupMenu();
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
        this.autoZoomPopup = new JCheckBoxMenuItem();
        this.autoZoomPopup.setAction(new AbstractAction(I18n.tr("Auto Zoom")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.autoZoom = !TMSLayer.this.autoZoom;
            }
        });
        this.autoZoomPopup.setSelected(this.autoZoom);
        this.tileOptionMenu.add(this.autoZoomPopup);
        this.autoLoad = PROP_DEFAULT_AUTOLOAD.get();
        this.autoLoadPopup = new JCheckBoxMenuItem();
        this.autoLoadPopup.setAction(new AbstractAction(I18n.tr("Auto load tiles")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.autoLoad = !TMSLayer.this.autoLoad;
            }
        });
        this.autoLoadPopup.setSelected(this.autoLoad);
        this.tileOptionMenu.add(this.autoLoadPopup);
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load Tile")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.loadTile(TMSLayer.this.clickedTile);
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Show Tile Info")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.showMetadataTile = TMSLayer.this.clickedTile;
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load All Tiles")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.loadAllTiles(true);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Increase zoom")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.increaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Decrease zoom")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.decreaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Snap to tile size")){

            public void actionPerformed(ActionEvent actionEvent) {
                double d = Math.sqrt(TMSLayer.this.getScaleFactor(TMSLayer.this.currentZoomLevel));
                Main.map.mapView.zoomToFactor(d);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Flush Tile Cache")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.clearTileCache();
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final MouseAdapter mouseAdapter = new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (!TMSLayer.this.isVisible()) {
                            return;
                        }
                        if (mouseEvent.getButton() == 3) {
                            TMSLayer.this.clickedTile = TMSLayer.this.getTileForPixelpos(mouseEvent.getX(), mouseEvent.getY());
                            TMSLayer.this.tileOptionMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        } else if (mouseEvent.getButton() == 1) {
                            if (!TMSLayer.this.tileSource.requiresAttribution()) {
                                return;
                            }
                            if (TMSLayer.this.attrImageBounds != null && TMSLayer.this.attrImageBounds.contains(mouseEvent.getPoint()) || TMSLayer.this.attrTextBounds != null && TMSLayer.this.attrTextBounds.contains(mouseEvent.getPoint())) {
                                try {
                                    Desktop desktop = Desktop.getDesktop();
                                    desktop.browse(new URI(TMSLayer.this.tileSource.getAttributionLinkURL()));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    uRISyntaxException.printStackTrace();
                                }
                            } else if (TMSLayer.this.attrToUBounds.contains(mouseEvent.getPoint())) {
                                try {
                                    Desktop desktop = Desktop.getDesktop();
                                    desktop.browse(new URI(TMSLayer.this.tileSource.getTermsOfUseURL()));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    uRISyntaxException.printStackTrace();
                                }
                            }
                        }
                    }
                };
                Main.map.mapView.addMouseListener(mouseAdapter);
                MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

                    public void activeLayerChange(Layer layer, Layer layer2) {
                    }

                    public void layerAdded(Layer layer) {
                    }

                    public void layerRemoved(Layer layer) {
                        if (layer == TMSLayer.this) {
                            Main.map.mapView.removeMouseListener(mouseAdapter);
                            MapView.removeLayerChangeListener(this);
                        }
                    }
                });
            }
        });
    }

    void zoomChanged() {
        this.needRedraw = true;
        this.jobDispatcher.cancelOutstandingJobs();
        this.tileRequestsOutstanding.clear();
    }

    int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return TMSLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return TMSLayer.getMaxZoomLvl(this.tileSource);
    }

    int getMinZoomLvl() {
        return TMSLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean bl = this.currentZoomLevel < this.getMaxZoomLvl();
        return bl;
    }

    public boolean increaseZoomLevel() {
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
        } else {
            Main.warn("Current zoom level (" + this.currentZoomLevel + ") could not be increased. " + "Max.zZoom Level " + this.getMaxZoomLvl() + " reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean setZoomLevel(int n) {
        if (n == this.currentZoomLevel) {
            return true;
        }
        if (n > this.getMaxZoomLvl()) {
            return false;
        }
        if (n < this.getMinZoomLvl()) {
            return false;
        }
        this.currentZoomLevel = n;
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > this.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        int n = this.getMinZoomLvl();
        if (this.zoomDecreaseAllowed()) {
            --this.currentZoomLevel;
        } else {
            return false;
        }
        this.zoomChanged();
        return true;
    }

    synchronized Tile tempCornerTile(Tile tile) {
        int n;
        int n2;
        int n3 = tile.getXtile() + 1;
        Tile tile2 = this.getTile(n3, n2 = tile.getYtile() + 1, n = tile.getZoom());
        if (tile2 != null) {
            return tile2;
        }
        return new Tile(this.tileSource, n3, n2, n);
    }

    synchronized Tile getOrCreateTile(int n, int n2, int n3) {
        Tile tile = this.getTile(n, n2, n3);
        if (tile == null) {
            tile = new Tile(this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        return tile;
    }

    synchronized Tile getTile(int n, int n2, int n3) {
        int n4 = 1 << n3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, n, n2, n3);
        return tile;
    }

    synchronized boolean loadTile(Tile tile) {
        if (tile == null) {
            return false;
        }
        if (tile.hasError()) {
            return false;
        }
        if (tile.isLoaded()) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        if (this.tileRequestsOutstanding.contains(tile)) {
            return false;
        }
        this.tileRequestsOutstanding.add(tile);
        this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(this.tileSource, tile.getXtile(), tile.getYtile(), tile.getZoom()));
        return true;
    }

    void loadAllTiles(boolean bl) {
        EastNorth eastNorth;
        MapView mapView = Main.map.mapView;
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = new TileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), this.currentZoomLevel);
        if (tileSet.tooLarge()) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        tileSet.loadAllTiles(bl);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = (n & 0x70) != 0;
        this.needRedraw = true;
        Main.map.repaint(bl ? 0L : 100L);
        return !bl;
    }

    boolean imageLoaded(Image image) {
        if (image == null) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().checkImage(image, -1, -1, this);
        return (n & 0x20) != 0;
    }

    Image getLoadedTileImage(Tile tile) {
        if (!tile.isLoaded()) {
            return null;
        }
        BufferedImage bufferedImage = tile.getImage();
        if (!this.imageLoaded(bufferedImage)) {
            return null;
        }
        return bufferedImage;
    }

    LatLon tileLatLon(Tile tile) {
        int n = tile.getZoom();
        return new LatLon(this.tileSource.tileYToLat(tile.getYtile(), n), this.tileSource.tileXToLon(tile.getXtile(), n));
    }

    Rectangle tileToRect(Tile tile) {
        Tile tile2 = this.tempCornerTile(tile);
        Rectangle rectangle = new Rectangle(this.pixelPos(tile));
        rectangle.add(this.pixelPos(tile2));
        return rectangle;
    }

    void drawImageInside(Graphics graphics, Image image, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle;
        if (rectangle2 != null) {
            rectangle3 = rectangle.intersection(rectangle2);
        }
        double d = (double)image.getHeight(this) / rectangle.getHeight();
        double d2 = (double)image.getWidth(this) / rectangle.getWidth();
        int n = rectangle3.x - rectangle.x;
        int n2 = rectangle3.y - rectangle.y;
        int n3 = (int)((double)n * d2);
        int n4 = (int)((double)n2 * d);
        int n5 = n3 + (int)(rectangle3.getWidth() * d2);
        int n6 = n4 + (int)(rectangle3.getHeight() * d);
        graphics.drawImage(image, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, n3, n4, n5, n6, this);
        if (PROP_FADE_AMOUNT.get() != 0) {
            graphics.setColor(TMSLayer.getFadeColorWithAlpha());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    List<Tile> paintTileImages(Graphics graphics, TileSet tileSet, int n, Tile tile) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        Rectangle rectangle = null;
        if (tile != null) {
            rectangle = this.tileToRect(tile);
        }
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        for (Tile tile2 : tileSet.allTiles()) {
            Image image = this.getLoadedTileImage(tile2);
            if (image == null || tile2.hasError()) {
                linkedList.add(tile2);
                continue;
            }
            Rectangle rectangle2 = this.tileToRect(tile2);
            if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
            this.drawImageInside(graphics, image, rectangle2, rectangle);
        }
        return linkedList;
    }

    void myDrawString(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
    }

    void paintTileText(TileSet tileSet, Tile tile, Graphics graphics, MapView mapView, int n, Tile tile2) {
        String string;
        int n2 = graphics.getFontMetrics().getHeight();
        if (tile == null) {
            return;
        }
        Point point = this.pixelPos(tile2);
        int n3 = point.y + 2 + n2;
        if (tile == this.showMetadataTile) {
            Map<String, String> map;
            string = tile.toString();
            if (string != null) {
                this.myDrawString(graphics, string, point.x + 2, n3);
                n3 += 1 + n2;
            }
            if ((map = tile.getMetadata()) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.myDrawString(graphics, entry.getKey() + ": " + entry.getValue(), point.x + 2, n3);
                    n3 += 1 + n2;
                }
            }
        }
        string = tile.getStatus();
        if (tile.hasError()) {
            this.myDrawString(graphics, I18n.tr("Error") + ": " + I18n.tr(tile.getErrorMessage()), point.x + 2, n3);
            n3 += 1 + n2;
        }
    }

    private Point pixelPos(LatLon latLon) {
        return Main.map.mapView.getPoint(Main.getProjection().latlon2eastNorth(latLon).add(this.getDx(), this.getDy()));
    }

    private Point pixelPos(Tile tile) {
        double d = this.tileSource.tileXToLon(tile.getXtile(), tile.getZoom());
        LatLon latLon = new LatLon(this.tileSource.tileYToLat(tile.getYtile(), tile.getZoom()), d);
        return this.pixelPos(latLon);
    }

    private LatLon getShiftedLatLon(EastNorth eastNorth) {
        return Main.getProjection().eastNorth2latlon(eastNorth.add(-this.getDx(), -this.getDy()));
    }

    private Coordinate getShiftedCoord(EastNorth eastNorth) {
        LatLon latLon = this.getShiftedLatLon(eastNorth);
        return new Coordinate(latLon.lat(), latLon.lon());
    }

    private static TileSetInfo getTileSetInfo(TileSet tileSet) {
        List<Tile> list = tileSet.allTiles();
        TileSetInfo tileSetInfo = new TileSetInfo();
        tileSetInfo.hasLoadingTiles = list.size() < tileSet.size();
        for (Tile tile : list) {
            if (tile.isLoaded()) {
                if (!tile.hasError()) {
                    tileSetInfo.hasVisibleTiles = true;
                }
                if (!"no-tile".equals(tile.getValue("tile-info"))) continue;
                tileSetInfo.hasOverzoomedTiles = true;
                continue;
            }
            tileSetInfo.hasLoadingTiles = true;
        }
        return tileSetInfo;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        int n;
        LinkedList<Tile> linkedList;
        double d;
        EastNorth eastNorth = mapView.getEastNorth(0, 0);
        EastNorth eastNorth2 = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight());
        if (eastNorth2.east() == 0.0 || eastNorth2.north() == 0.0) {
            return;
        }
        this.needRedraw = false;
        int n2 = this.currentZoomLevel;
        if (this.autoZoom && ((d = this.getScaleFactor(n2)) > 3.0 || d < 0.45)) {
            n2 = this.getBestZoom();
        }
        DeepTileSet deepTileSet = new DeepTileSet(eastNorth, eastNorth2, this.getMinZoomLvl(), n2);
        TileSet tileSet = deepTileSet.getTileSet(n2);
        int n3 = n2;
        boolean bl = false;
        if (this.autoZoom && this.autoLoad) {
            linkedList = deepTileSet.getTileSetInfo(n2);
            if (!(((TileSetInfo)((Object)linkedList)).hasVisibleTiles || ((TileSetInfo)((Object)linkedList)).hasLoadingTiles && !((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles)) {
                bl = true;
            }
            while (n3 > deepTileSet.minZoom && !deepTileSet.getTileSetInfo((int)n3).hasVisibleTiles) {
                --n3;
            }
            while (n2 > n3 && !((TileSetInfo)((Object)linkedList)).hasVisibleTiles && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles) {
                n2 = (n2 + n3) / 2;
                linkedList = deepTileSet.getTileSetInfo(n2);
            }
            this.setZoomLevel(n2);
            if (n2 == n3 && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles && n2 < deepTileSet.maxZoom) {
                linkedList = deepTileSet.getTileSetInfo(++n2);
            }
            while (n2 > deepTileSet.minZoom && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles) {
                linkedList = deepTileSet.getTileSetInfo(--n2);
            }
            tileSet = deepTileSet.getTileSet(n2);
        } else if (this.autoZoom) {
            this.setZoomLevel(n2);
        }
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        if (n3 != n2) {
            tileSet = deepTileSet.getTileSet(n3);
        }
        graphics2D.setColor(Color.DARK_GRAY);
        linkedList = this.paintTileImages(graphics2D, tileSet, n3, null);
        int[] nArray = new int[]{-1, 1, -2, 2, -3, -4, -5};
        for (int n4 : nArray) {
            if (!this.autoZoom || !this.autoLoad) break;
            n = n3 + n4;
            if (linkedList.size() <= 0) break;
            LinkedList<Tile> linkedList2 = new LinkedList<Tile>();
            for (Tile tile : linkedList) {
                LatLon latLon;
                if ("no-tile".equals(tile.getValue("tile-info")) && n4 > 0) {
                    linkedList2.add(tile);
                    continue;
                }
                Tile tile2 = this.tempCornerTile(tile);
                LatLon latLon2 = this.tileLatLon(tile);
                TileSet tileSet2 = new TileSet(latLon2, latLon = this.tileLatLon(tile2), n);
                if (tileSet2.tooLarge()) continue;
                linkedList2.addAll(this.paintTileImages(graphics2D, tileSet2, n, tile));
            }
            linkedList = linkedList2;
        }
        graphics2D.setColor(Color.red);
        graphics2D.setFont(InfoFont);
        Object object = tileSet.allTiles().iterator();
        while (object.hasNext()) {
            Tile tile = (Tile)object.next();
            this.paintTileText(tileSet, tile, graphics2D, mapView, n3, tile);
        }
        if (this.tileSource.requiresAttribution()) {
            int n4;
            object = graphics2D.getFont();
            graphics2D.setFont(ATTR_LINK_FONT);
            graphics2D.setColor(Color.white);
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds("Background Terms of Use", graphics2D);
            int n5 = (int)rectangle2D.getHeight();
            n4 = n5 - 5;
            n = (int)rectangle2D.getWidth();
            int n6 = mapView.getHeight() - n4;
            if (this.attrTermsUrl != null) {
                int n7 = 2;
                int n8 = mapView.getHeight() - n4;
                this.attrToUBounds = new Rectangle(n7, n8 - n4, n, n5);
                this.myDrawString(graphics2D, "Background Terms of Use", n7, n8);
            }
            if (this.attrImage != null) {
                int n9 = 2;
                int n10 = this.attrImage.getWidth(this);
                int n11 = this.attrImage.getHeight(this);
                int n12 = n6 - n11 - n4 - 5;
                this.attrImageBounds = new Rectangle(n9, n12, n10, n11);
                graphics2D.drawImage(this.attrImage, n9, n12, this);
            }
            graphics2D.setFont(ATTR_FONT);
            String string = this.tileSource.getAttributionText(n3, this.getShiftedCoord(eastNorth), this.getShiftedCoord(eastNorth2));
            Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            int n13 = mapView.getWidth() - (int)rectangle2D2.getWidth();
            int n14 = mapView.getHeight() - n4;
            this.myDrawString(graphics2D, string, n13, n14);
            this.attrTextBounds = new Rectangle(n13, n14 - n4, n, n5);
            graphics2D.setFont((Font)object);
        }
        graphics2D.setColor(Color.lightGray);
        if (!this.autoZoom) {
            if (tileSet.insane()) {
                this.myDrawString(graphics2D, I18n.tr("zoom in to load any tiles"), 120, 120);
            } else if (tileSet.tooLarge()) {
                this.myDrawString(graphics2D, I18n.tr("zoom in to load more tiles"), 120, 120);
            } else if (tileSet.tooSmall()) {
                this.myDrawString(graphics2D, I18n.tr("increase zoom level to see more detail"), 120, 120);
            }
        }
        if (bl) {
            this.myDrawString(graphics2D, I18n.tr("No tiles at this zoom level"), 120, 120);
        }
    }

    Tile getTileForPixelpos(int n, int n2) {
        int n3;
        EastNorth eastNorth;
        MapView mapView = Main.map.mapView;
        Point point = new Point(n, n2);
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = new TileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), n3 = this.currentZoomLevel);
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        Tile tile = null;
        for (Tile tile2 : tileSet.allTiles()) {
            Tile tile3 = this.tempCornerTile(tile2);
            Rectangle rectangle = new Rectangle(this.pixelPos(tile2));
            rectangle.add(this.pixelPos(tile3));
            if (!rectangle.contains(point)) continue;
            tile = tile2;
            break;
        }
        if (tile == null) {
            return null;
        }
        return tile;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    @Override
    public boolean isChanged() {
        return this.needRedraw;
    }

    @Override
    public boolean isProjectionSupported(Projection projection) {
        return projection instanceof Mercator || projection instanceof Epsg4326;
    }

    @Override
    public String nameSupportedProjections() {
        return I18n.tr("EPSG:4326 and Mercator projection are supported");
    }

    static {
        Object object = null;
        try {
            object = OsmFileCacheTileLoader.getDefaultCacheDir().getAbsolutePath();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        PROP_TILECACHE_DIR = new StringProperty("imagery.tms.tilecache_path", (String)object);
        InfoFont = new Font("sansserif", 1, 13);
        ATTR_FONT = new Font("Arial", 0, 10);
        object = new HashMap();
        ((HashMap)object).put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        ATTR_LINK_FONT = ATTR_FONT.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)object);
    }

    private class DeepTileSet {
        final EastNorth topLeft;
        final EastNorth botRight;
        final int minZoom;
        final int maxZoom;
        private final TileSet[] tileSets;
        private final TileSetInfo[] tileSetInfos;

        public DeepTileSet(EastNorth eastNorth, EastNorth eastNorth2, int n, int n2) {
            this.topLeft = eastNorth;
            this.botRight = eastNorth2;
            this.minZoom = n;
            this.maxZoom = n2;
            this.tileSets = new TileSet[n2 - n + 1];
            this.tileSetInfos = new TileSetInfo[n2 - n + 1];
        }

        public TileSet getTileSet(int n) {
            if (n < this.minZoom) {
                return TMSLayer.this.nullTileSet;
            }
            TileSet tileSet = this.tileSets[n - this.minZoom];
            if (tileSet == null) {
                this.tileSets[n - this.minZoom] = tileSet = new TileSet(this.topLeft, this.botRight, n);
            }
            return tileSet;
        }

        public TileSetInfo getTileSetInfo(int n) {
            if (n < this.minZoom) {
                return new TileSetInfo();
            }
            TileSetInfo tileSetInfo = this.tileSetInfos[n - this.minZoom];
            if (tileSetInfo == null) {
                this.tileSetInfos[n - this.minZoom] = tileSetInfo = TMSLayer.getTileSetInfo(this.getTileSet(n));
            }
            return tileSetInfo;
        }
    }

    private static class TileSetInfo {
        public boolean hasVisibleTiles = false;
        public boolean hasOverzoomedTiles = false;
        public boolean hasLoadingTiles = false;

        private TileSetInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TileSet {
        int x0;
        int x1;
        int y0;
        int y1;
        int zoom;
        int tileMax = -1;

        TileSet(EastNorth eastNorth, EastNorth eastNorth2, int n) {
            this(tMSLayer.getShiftedLatLon(eastNorth), tMSLayer.getShiftedLatLon(eastNorth2), n);
        }

        TileSet(LatLon latLon, LatLon latLon2, int n) {
            int n2;
            this.zoom = n;
            if (n == 0) {
                return;
            }
            this.x0 = (int)TMSLayer.this.tileSource.lonToTileX(latLon.lon(), n);
            this.y0 = (int)TMSLayer.this.tileSource.latToTileY(latLon.lat(), n);
            this.x1 = (int)TMSLayer.this.tileSource.lonToTileX(latLon2.lon(), n);
            this.y1 = (int)TMSLayer.this.tileSource.latToTileY(latLon2.lat(), n);
            if (this.x0 > this.x1) {
                n2 = this.x0;
                this.x0 = this.x1;
                this.x1 = n2;
            }
            if (this.y0 > this.y1) {
                n2 = this.y0;
                this.y0 = this.y1;
                this.y1 = n2;
            }
            this.tileMax = (int)Math.pow(2.0, n);
            if (this.x0 < 0) {
                this.x0 = 0;
            }
            if (this.y0 < 0) {
                this.y0 = 0;
            }
            if (this.x1 > this.tileMax) {
                this.x1 = this.tileMax;
            }
            if (this.y1 > this.tileMax) {
                this.y1 = this.tileMax;
            }
        }

        boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        boolean tooLarge() {
            return this.tilesSpanned() > 10.0;
        }

        boolean insane() {
            return this.tilesSpanned() > 100.0;
        }

        double tilesSpanned() {
            return Math.sqrt(1.0 * (double)this.size());
        }

        int size() {
            int n = this.x1 - this.x0 + 1;
            int n2 = this.y1 - this.y0 + 1;
            return n * n2;
        }

        List<Tile> allTiles() {
            return this.allTiles(false);
        }

        private List<Tile> allTiles(boolean bl) {
            if (this.zoom == 0 || this.insane()) {
                return Collections.emptyList();
            }
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            for (int i = this.x0; i <= this.x1; ++i) {
                for (int j = this.y0; j <= this.y1; ++j) {
                    Tile tile = bl ? TMSLayer.this.getOrCreateTile(i % this.tileMax, j % this.tileMax, this.zoom) : TMSLayer.this.getTile(i % this.tileMax, j % this.tileMax, this.zoom);
                    if (tile == null) continue;
                    arrayList.add(tile);
                }
            }
            return arrayList;
        }

        void loadAllTiles(boolean bl) {
            List<Tile> list = this.allTiles(true);
            if (!TMSLayer.this.autoLoad && !bl) {
                return;
            }
            int n = 0;
            for (Tile tile : list) {
                if (!TMSLayer.this.loadTile(tile)) continue;
                ++n;
            }
        }
    }
}

