/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetContentTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public ChangesetContentTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.setFont(UIManager.getFont("Table.font"));
    }

    protected void renderColors(boolean bl) {
        if (bl) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
    }

    protected void renderId(HistoryOsmPrimitive historyOsmPrimitive) {
        this.setText(Long.toString(historyOsmPrimitive.getId()));
        this.setToolTipText("");
    }

    protected void renderModificationType(ChangesetDataSet.ChangesetModificationType changesetModificationType) {
        switch (changesetModificationType) {
            case CREATED: {
                this.setText(I18n.tr("Created"));
                break;
            }
            case UPDATED: {
                this.setText(I18n.tr("Updated"));
                break;
            }
            case DELETED: {
                this.setText(I18n.tr("Deleted"));
            }
        }
        this.setToolTipText("");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        this.reset();
        this.renderColors(bl);
        switch (n2) {
            case 0: {
                ChangesetDataSet.ChangesetModificationType changesetModificationType = (ChangesetDataSet.ChangesetModificationType)((Object)object);
                this.renderModificationType(changesetModificationType);
                break;
            }
            case 1: {
                HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)object;
                this.renderId(historyOsmPrimitive);
                break;
            }
        }
        return this;
    }
}

