/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static int UNORDERED_COASTLINE = 901;
    protected static int REVERSED_COASTLINE = 902;
    protected static int UNCONNECTED_COASTLINE = 903;
    private List<Way> coastlines;
    private Area downloadedArea = null;

    public Coastlines() {
        super(I18n.tr("Coastlines."), I18n.tr("This test checks that coastlines are correct."));
    }

    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        OsmDataLayer osmDataLayer = Main.map.mapView.getEditLayer();
        if (osmDataLayer != null) {
            this.downloadedArea = osmDataLayer.data.getDataSourceArea();
        }
        this.coastlines = new LinkedList<Way>();
    }

    /*
     * WARNING - void declaration
     */
    public void endTest() {
        for (Way way : this.coastlines) {
            void bl6;
            boolean bl;
            List<OsmPrimitive> list;
            Node node = way.firstNode();
            Node node2 = way.lastNode();
            if (way.getNodesCount() == 0 || node.equals(node2)) continue;
            int n = 0;
            int n2 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            Way object2 = null;
            Way object3 = null;
            for (Way object4 : this.coastlines) {
                if (way == object4) continue;
                if (object4.containsNode(node)) {
                    ++n;
                    object2 = object4;
                    if (node.equals(object4.firstNode())) {
                        bl2 = true;
                    } else if (!node.equals(object4.lastNode())) {
                        bl4 = true;
                    }
                }
                if (!object4.containsNode(node2)) continue;
                ++n2;
                object3 = object4;
                if (node2.equals(object4.lastNode())) {
                    bl3 = true;
                    continue;
                }
                if (node2.equals(object4.firstNode())) continue;
                bl5 = true;
            }
            if (n == 0) {
                list = node.getReferrers();
                for (OsmPrimitive osmPrimitive : list) {
                    if (osmPrimitive == way || !Coastlines.isCoastline(osmPrimitive)) continue;
                    ++n;
                    object2 = (Way)osmPrimitive;
                    if (node.equals(object2.firstNode())) {
                        bl2 = true;
                        continue;
                    }
                    if (node.equals(object2.lastNode())) continue;
                    bl4 = true;
                }
            }
            if (n2 == 0) {
                list = node2.getReferrers();
                for (OsmPrimitive osmPrimitive : list) {
                    if (osmPrimitive == way || !Coastlines.isCoastline(osmPrimitive)) continue;
                    ++n2;
                    object3 = (Way)osmPrimitive;
                    if (node2.equals(object3.lastNode())) {
                        bl3 = true;
                        continue;
                    }
                    if (node2.equals(object3.firstNode())) continue;
                    bl5 = true;
                }
            }
            list = new ArrayList<OsmPrimitive>();
            list.add(way);
            if (n == 0 || n2 == 0) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                System.out.println("Unconnected coastline: " + way.getId());
                if (n == 0 && (this.downloadedArea == null || this.downloadedArea.contains(node.getCoor()))) {
                    System.out.println("headways: " + n + " node: " + node.toString());
                    arrayList.add(node);
                }
                if (n2 == 0 && (this.downloadedArea == null || this.downloadedArea.contains(node2.getCoor()))) {
                    System.out.println("tailways: " + n2 + " tail: " + node2.toString());
                    arrayList.add(node2);
                }
                if (arrayList.size() > 0) {
                    this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Unconnected coastline"), UNCONNECTED_COASTLINE, list, arrayList));
                }
            }
            boolean bl7 = false;
            boolean bl8 = bl = n == 1 && bl2 && n2 == 1 && bl3;
            if (n > 1 || n2 > 1) {
                boolean bl9 = true;
            } else if (bl4 || bl5) {
                boolean bl10 = true;
            } else if (bl && object2 == object3) {
                boolean bl11 = true;
            }
            if (bl6 != false) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                System.out.println("Unordered coastline: " + way.toString());
                if (n > 1 || bl4 || bl) {
                    System.out.println("head: " + node.toString());
                    arrayList.add(node);
                }
                if (n2 > 1 || bl5 || bl) {
                    System.out.println("tail: " + node2.toString());
                    arrayList.add(node2);
                }
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Unordered coastline"), UNORDERED_COASTLINE, list, arrayList));
                continue;
            }
            if (!bl) continue;
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Reversed coastline"), REVERSED_COASTLINE, list));
        }
        this.coastlines = null;
        this.downloadedArea = null;
        super.endTest();
    }

    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        if (Coastlines.isCoastline(way)) {
            this.coastlines.add(way);
        }
    }

    private static boolean isCoastline(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Way && "coastline".equals(osmPrimitive.get("natural"));
    }

    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            Way way = (Way)testError.getPrimitives().iterator().next();
            Way way2 = new Way(way);
            List<Node> list = way2.getNodes();
            Collections.reverse(list);
            way2.setNodes(list);
            return new ChangeCommand(way, way2);
        }
        return null;
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == REVERSED_COASTLINE;
        }
        return false;
    }
}

