/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Color;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PaintColors implements Preferences.ColorKey
{
    INACTIVE(I18n.marktr("inactive"), Color.darkGray),
    SELECTED(I18n.marktr("selected"), Color.red),
    RELATIONSELECTED(I18n.marktr("Relation: selected"), Color.magenta),
    NODE(I18n.marktr("Node: standard"), Color.yellow),
    CONNECTION(I18n.marktr("Node: connection"), Color.yellow),
    TAGGED(I18n.marktr("Node: tagged"), new Color(204, 255, 255)),
    DEFAULT_WAY(I18n.marktr("way"), new Color(0, 0, 128)),
    RELATION(I18n.marktr("relation"), new Color(0, 128, 128)),
    UNTAGGED_WAY(I18n.marktr("untagged way"), new Color(0, 128, 0)),
    INCOMPLETE_WAY(I18n.marktr("incomplete way"), new Color(0, 0, 96)),
    BACKGROUND(I18n.marktr("background"), Color.BLACK),
    HIGHLIGHT(I18n.marktr("highlight"), new Color(0, 255, 186)),
    UNTAGGED(I18n.marktr("untagged"), Color.GRAY),
    TEXT(I18n.marktr("text"), Color.WHITE),
    AREA_TEXT(I18n.marktr("areatext"), Color.LIGHT_GRAY);

    private final String name;
    private final Color defaultColor;
    private static Color backgroundColorCache;
    private static final MapPaintStyles.MapPaintSylesUpdateListener styleOverrideListener;

    private PaintColors(String string2, Color color) {
        this.name = string2;
        this.defaultColor = color;
    }

    @Override
    public String getColorName() {
        return this.name;
    }

    @Override
    public Color getDefault() {
        return this.defaultColor;
    }

    @Override
    public String getSpecialName() {
        return null;
    }

    public Color get() {
        return Main.pref.getColor(this);
    }

    public static void getColors() {
        for (PaintColors paintColors : PaintColors.values()) {
            paintColors.get();
        }
    }

    public static Color getBackgroundColor() {
        if (backgroundColorCache != null) {
            return backgroundColorCache;
        }
        List<StyleSource> list = MapPaintStyles.getStyles().getStyleSources();
        for (StyleSource styleSource : list) {
            Color color;
            if (!styleSource.active || (color = styleSource.getBackgroundColorOverride()) == null) continue;
            backgroundColorCache = color;
        }
        if (backgroundColorCache == null) {
            backgroundColorCache = BACKGROUND.get();
        }
        return backgroundColorCache;
    }

    static {
        backgroundColorCache = null;
        styleOverrideListener = new MapPaintStyles.MapPaintSylesUpdateListener(){

            public void mapPaintStylesUpdated() {
                backgroundColorCache = null;
            }

            public void mapPaintStyleEntryUpdated(int n) {
                this.mapPaintStylesUpdated();
            }
        };
        MapPaintStyles.addMapPaintSylesUpdateListener(styleOverrideListener);
    }
}

