/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MultiValueCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_UNDECIDED = new Color(255, 197, 197);
    private ImageIcon iconDecided;
    private ImageIcon iconUndecided;
    private DefaultComboBoxModel model;
    private JComboBox cbDecisionRenderer;

    public MultiValueCellRenderer() {
        this.setOpaque(true);
        this.iconDecided = ImageProvider.get("dialogs/conflict", "tagconflictresolved");
        this.iconUndecided = ImageProvider.get("dialogs/conflict", "tagconflictunresolved");
        this.model = new DefaultComboBoxModel();
        this.cbDecisionRenderer = new JComboBox(this.model);
    }

    protected void renderColors(MultiValueResolutionDecision multiValueResolutionDecision, boolean bl) {
        if (bl) {
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
        } else {
            switch (multiValueResolutionDecision.getDecisionType()) {
                case UNDECIDED: {
                    this.setForeground(UIManager.getColor("Table.foreground"));
                    this.setBackground(BGCOLOR_UNDECIDED);
                    break;
                }
                case KEEP_NONE: {
                    this.setForeground(UIManager.getColor("Panel.foreground"));
                    this.setBackground(UIManager.getColor("Panel.background"));
                    break;
                }
                default: {
                    this.setForeground(UIManager.getColor("Table.foreground"));
                    this.setBackground(UIManager.getColor("Table.background"));
                }
            }
        }
    }

    protected void renderValue(MultiValueResolutionDecision multiValueResolutionDecision) {
        this.model.removeAllElements();
        switch (multiValueResolutionDecision.getDecisionType()) {
            case UNDECIDED: {
                this.model.addElement(I18n.tr("Choose a value"));
                this.setFont(this.getFont().deriveFont(2));
                this.setToolTipText(I18n.tr("Please decide which values to keep"));
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            case KEEP_ONE: {
                this.model.addElement(multiValueResolutionDecision.getChosenValue());
                this.setToolTipText(I18n.tr("Value ''{0}'' is going to be applied for key ''{1}''", multiValueResolutionDecision.getChosenValue(), multiValueResolutionDecision.getKey()));
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            case KEEP_NONE: {
                this.model.addElement(I18n.tr("deleted"));
                this.setFont(this.getFont().deriveFont(2));
                this.setToolTipText(I18n.tr("The key ''{0}'' and all its values are going to be removed", multiValueResolutionDecision.getKey()));
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            case KEEP_ALL: {
                this.model.addElement(multiValueResolutionDecision.getChosenValue());
                this.setToolTipText(I18n.tr("All values joined as ''{0}'' are going to be applied for key ''{1}''", multiValueResolutionDecision.getChosenValue(), multiValueResolutionDecision.getKey()));
                this.cbDecisionRenderer.setSelectedIndex(0);
            }
        }
    }

    protected void reset() {
        this.setFont(UIManager.getFont("Table.font"));
        this.setIcon(null);
        this.setText("");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        MultiValueResolutionDecision multiValueResolutionDecision = (MultiValueResolutionDecision)object;
        this.renderColors(multiValueResolutionDecision, bl);
        switch (n2) {
            case 0: {
                if (multiValueResolutionDecision.isDecided()) {
                    this.setIcon(this.iconDecided);
                } else {
                    this.setIcon(this.iconUndecided);
                }
                return this;
            }
            case 1: {
                this.setText(multiValueResolutionDecision.getKey());
                return this;
            }
            case 2: {
                this.renderValue(multiValueResolutionDecision);
                return this.cbDecisionRenderer;
            }
        }
        return this;
    }
}

